/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.DefaultRepositorySelector;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.slf4j.Logger;

public class LoggerUtil {
    private static final Logger logger = org.slf4j.LoggerFactory.getLogger(LoggerUtil.class);
    private static final Map<String, Level> patternLevel = Maps.newHashMap();
    private static final Map<String, Pattern> patterns = Maps.newHashMap();
    private static final Function<Level, String> levelToString = new Function<Level, String>(){

        public String apply(@Nullable Level input) {
            return input == null ? "" : input.toString();
        }
    };

    private static synchronized Level getLevelFor(String name) {
        if (patternLevel.isEmpty()) {
            return null;
        }
        String longestPatternKey = null;
        for (String patternKey : patternLevel.keySet()) {
            Pattern pattern = patterns.get(patternKey);
            if (!pattern.matcher(name).matches() || longestPatternKey != null && longestPatternKey.length() >= patternKey.length()) continue;
            longestPatternKey = patternKey;
        }
        if (longestPatternKey != null) {
            return patternLevel.get(longestPatternKey);
        }
        return null;
    }

    public static ImmutableMap<String, String> getPatternLevels() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(patternLevel, levelToString));
    }

    public static synchronized void changeLoggersLevel(@Nonnull Map<String, String> targetChanges) {
        for (Map.Entry<String, String> changeEntry : targetChanges.entrySet()) {
            Iterator<Map.Entry<String, Pattern>> patternsIterator = patterns.entrySet().iterator();
            while (patternsIterator.hasNext()) {
                Map.Entry<String, Pattern> entry = patternsIterator.next();
                String finer = entry.getKey();
                String wider = changeEntry.getKey();
                if (finer.length() < wider.length()) continue;
                boolean remove = false;
                for (int i = 0; i < wider.length(); ++i) {
                    if (wider.charAt(i) == '*') {
                        remove = true;
                        break;
                    }
                    if (wider.charAt(i) != finer.charAt(i)) break;
                    if (i != wider.length() - 1) continue;
                    remove = true;
                }
                if (!remove) continue;
                patternsIterator.remove();
                patternLevel.remove(finer);
            }
        }
        for (Map.Entry<String, String> loggerEntry : targetChanges.entrySet()) {
            String target = loggerEntry.getKey();
            patternLevel.put(target, Level.toLevel((String)loggerEntry.getValue()));
            patterns.put(target, Pattern.compile(target));
        }
        if (!patternLevel.isEmpty()) {
            Enumeration loggerEnumeration = LogManager.getCurrentLoggers();
            while (loggerEnumeration.hasMoreElements()) {
                org.apache.log4j.Logger classLogger = (org.apache.log4j.Logger)loggerEnumeration.nextElement();
                Level oldLevel = classLogger.getLevel();
                Level newLevel = LoggerUtil.getLevelFor(classLogger.getName());
                if (newLevel == null || oldLevel != null && newLevel.equals((Object)oldLevel)) continue;
                logger.info("changing level of {} to {}", (Object)classLogger.getName(), (Object)newLevel);
                classLogger.setLevel(newLevel);
            }
        }
    }

    public static synchronized ImmutableMap<String, String> getClassesMatching(@Nonnull String searchKey) {
        Pattern searchPattern = Pattern.compile(searchKey);
        HashMap matchedClasses = Maps.newHashMap();
        Enumeration loggerEnumeration = LogManager.getCurrentLoggers();
        while (loggerEnumeration.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)loggerEnumeration.nextElement();
            if (!searchPattern.matcher(logger.getName()).matches()) continue;
            Level level = logger.getLevel();
            matchedClasses.put(logger.getName(), level == null ? "" : level.toString());
        }
        return ImmutableMap.copyOf((Map)matchedClasses);
    }

    static {
        logger.debug("initializing LoggerUtil");
        LogManager.setRepositorySelector((RepositorySelector)new DefaultRepositorySelector((LoggerRepository)new DelegatingLoggerRepository(LogManager.getLoggerRepository())), null);
    }

    private static class DelegatingLoggerRepository
    implements LoggerRepository {
        private final LoggerFactory loggerFactory = new DefaultLoggerFactory();
        private final LoggerRepository loggerRepository;

        private DelegatingLoggerRepository(LoggerRepository loggerRepository) {
            this.loggerRepository = loggerRepository;
        }

        public void addHierarchyEventListener(HierarchyEventListener listener) {
            this.loggerRepository.addHierarchyEventListener(listener);
        }

        public boolean isDisabled(int level) {
            return this.loggerRepository.isDisabled(level);
        }

        public void setThreshold(Level level) {
            this.loggerRepository.setThreshold(level);
        }

        public void setThreshold(String val) {
            this.loggerRepository.setThreshold(val);
        }

        public void emitNoAppenderWarning(Category cat) {
            this.loggerRepository.emitNoAppenderWarning(cat);
        }

        public Level getThreshold() {
            return this.loggerRepository.getThreshold();
        }

        public org.apache.log4j.Logger getLogger(String name) {
            return this.loggerRepository.getLogger(name, this.loggerFactory);
        }

        public org.apache.log4j.Logger getLogger(String name, LoggerFactory factory) {
            return this.loggerRepository.getLogger(name, factory);
        }

        public org.apache.log4j.Logger getRootLogger() {
            return this.loggerRepository.getRootLogger();
        }

        public org.apache.log4j.Logger exists(String name) {
            return this.loggerRepository.exists(name);
        }

        public void shutdown() {
            this.loggerRepository.shutdown();
        }

        public Enumeration<org.apache.log4j.Logger> getCurrentLoggers() {
            return this.loggerRepository.getCurrentLoggers();
        }

        public Enumeration<org.apache.log4j.Logger> getCurrentCategories() {
            return this.loggerRepository.getCurrentCategories();
        }

        public void fireAddAppenderEvent(Category logger, Appender appender) {
            this.loggerRepository.fireAddAppenderEvent(logger, appender);
        }

        public void resetConfiguration() {
            this.loggerRepository.resetConfiguration();
        }

        private static class DefaultLoggerFactory
        implements LoggerFactory {
            private DefaultLoggerFactory() {
            }

            public org.apache.log4j.Logger makeNewLoggerInstance(String name) {
                DefaultLogger logger = new DefaultLogger(name);
                Level level = LoggerUtil.getLevelFor(name);
                if (level != null) {
                    logger.setLevel(level);
                }
                return logger;
            }

            private static class DefaultLogger
            extends org.apache.log4j.Logger {
                public DefaultLogger(String name) {
                    super(name);
                }
            }
        }
    }
}

