/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import java.io.IOException;
import java.security.PrivilegedAction;
import org.apache.hadoop.security.UserGroupInformation;

public class SecureExecutor {
    public static <T> T execute(final WorkLoad<T> workLoad) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            return (T)loginUser.doAs(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    return workLoad.run();
                }
            });
        }
        return workLoad.run();
    }

    public static interface WorkLoad<T> {
        public T run();
    }
}

