/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import com.datatorrent.api.Context;
import com.datatorrent.stram.security.AuthScheme;
import com.datatorrent.stram.util.WebServicesClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class SecurityUtils {
    public static final String HADOOP_HTTP_AUTH_PROP = "hadoop.http.authentication.type";
    private static final String HADOOP_HTTP_AUTH_VALUE_SIMPLE = "simple";
    private static boolean stramWebSecurityEnabled;
    private static boolean hadoopWebSecurityEnabled;

    public static void init(Configuration configuration) {
        SecurityUtils.init(configuration, null);
    }

    public static void init(Configuration configuration, Context.StramHTTPAuthentication stramHTTPAuth) {
        hadoopWebSecurityEnabled = false;
        String authValue = configuration.get(HADOOP_HTTP_AUTH_PROP);
        if (authValue != null && !authValue.equals(HADOOP_HTTP_AUTH_VALUE_SIMPLE)) {
            hadoopWebSecurityEnabled = true;
            SecurityUtils.initAuth(configuration);
        }
        stramWebSecurityEnabled = stramHTTPAuth == Context.StramHTTPAuthentication.FOLLOW_HADOOP_HTTP_AUTH ? hadoopWebSecurityEnabled : (stramHTTPAuth == Context.StramHTTPAuthentication.ENABLE ? true : (stramHTTPAuth == Context.StramHTTPAuthentication.DISABLE ? false : UserGroupInformation.isSecurityEnabled()));
    }

    private static void initAuth(final Configuration configuration) {
        WebServicesClient.initAuth(new WebServicesClient.ConfigProvider(){

            @Override
            public String getProperty(AuthScheme scheme, String name) {
                StringBuilder propNamesb = new StringBuilder("dt.authentication.").append(scheme.getName()).append(".").append(name);
                return configuration.get(propNamesb.toString());
            }
        });
    }

    public static boolean isHadoopWebSecurityEnabled() {
        return hadoopWebSecurityEnabled;
    }

    public static boolean isStramWebSecurityEnabled() {
        return stramWebSecurityEnabled;
    }

    static {
        hadoopWebSecurityEnabled = stramWebSecurityEnabled = UserGroupInformation.isSecurityEnabled();
    }
}

