/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class VersionInfo {
    private String version = "Unknown";
    private String user = "Unknown";
    private String date = "Unknown";
    private String revision = "Unknown";
    private static String groupId = "org.apache.apex";
    private static String artifactId = "apex-engine";
    private static Class<?> classInJar = VersionInfo.class;
    private static String gitPropertiesResource = artifactId + ".git.properties";
    public static final VersionInfo APEX_VERSION = new VersionInfo(classInJar, groupId, artifactId, gitPropertiesResource);

    public VersionInfo(Class<?> classInJar, String groupId, String artifactId, String gitPropertiesResource) {
        try {
            Manifest mf;
            Attributes mainAttribs;
            String builtBy;
            URL res = classInJar.getResource(classInJar.getSimpleName() + ".class");
            URLConnection conn = res.openConnection();
            if (conn instanceof JarURLConnection && (builtBy = (mainAttribs = (mf = ((JarURLConnection)conn).getManifest()).getMainAttributes()).getValue("Built-By")) != null) {
                this.user = builtBy;
            }
            Enumeration<URL> resources = classInJar.getClassLoader().getResources("META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
            while (resources.hasMoreElements()) {
                String v;
                Properties pomInfo = new Properties();
                pomInfo.load(resources.nextElement().openStream());
                this.version = v = pomInfo.getProperty("version", "unknown");
            }
            resources = VersionInfo.class.getClassLoader().getResources(gitPropertiesResource);
            if (resources.hasMoreElements()) {
                Properties gitInfo = new Properties();
                gitInfo.load(resources.nextElement().openStream());
                String commitAbbrev = gitInfo.getProperty("git.commit.id.abbrev", "unknown");
                String branch = gitInfo.getProperty("git.branch", "unknown");
                this.revision = "rev: " + commitAbbrev + " branch: " + branch;
                this.date = gitInfo.getProperty("git.build.time", this.date);
                this.user = gitInfo.getProperty("git.build.user.name", this.user);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(VersionInfo.class).error("Failed to read version info", (Throwable)e);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getDate() {
        return this.date;
    }

    public String getUser() {
        return this.user;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getBuildVersion() {
        return this.getVersion() + " from " + this.getRevision() + " by " + this.getUser() + " on " + this.getDate();
    }

    public static int compare(String str1, String str2) {
        int i;
        String[] vals1 = VersionInfo.normalizeVersion(str1).split("\\.");
        String[] vals2 = VersionInfo.normalizeVersion(str2).split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            if (vals1[i].isEmpty()) {
                vals1[i] = "0";
            }
            if (vals2[i].isEmpty()) {
                vals2[i] = "0";
            }
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    public static boolean isCompatible(String thisVersion, String requiredVersion) {
        String[] requiredVersionComponent;
        String[] thisVersionComponent = VersionInfo.normalizeVersion(thisVersion).split("\\.");
        if (!thisVersionComponent[0].equals((requiredVersionComponent = VersionInfo.normalizeVersion(requiredVersion).split("\\."))[0])) {
            return false;
        }
        return Integer.parseInt(thisVersionComponent[1]) >= Integer.parseInt(requiredVersionComponent[1]);
    }

    private static String normalizeVersion(String ver) {
        for (int i = 0; i < ver.length(); ++i) {
            char c = ver.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return ver.substring(0, i);
        }
        return ver;
    }

    public static void main(String[] args) {
        System.out.println("Apex " + APEX_VERSION.getVersion());
        System.out.println("Revision " + APEX_VERSION.getRevision());
        System.out.println("Compiled by " + APEX_VERSION.getUser() + " on " + APEX_VERSION.getDate());
    }
}

