/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import com.datatorrent.stram.security.AuthScheme;
import com.datatorrent.stram.util.SecureExecutor;
import com.datatorrent.stram.util.SecurityUtils;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.async.ITypeListener;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServicesClient {
    private static final Logger LOG = LoggerFactory.getLogger(WebServicesClient.class);
    private static final PoolingHttpClientConnectionManager connectionManager;
    private static final CredentialsProvider credentialsProvider;
    private static final RegistryBuilder<AuthSchemeProvider> registryBuilder;
    private static Lookup<AuthSchemeProvider> authRegistry;
    private static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    private static final int DEFAULT_READ_TIMEOUT = 10000;
    private final Client client;
    private final Set<ClientFilter> clientFilters = new HashSet<ClientFilter>();
    private static final Credentials DEFAULT_TOKEN_CREDENTIALS;

    public static void initAuth(ConfigProvider configuration) {
        WebServicesClient.setupUserPassAuthScheme(AuthScheme.BASIC, "Basic", (AuthSchemeProvider)new BasicSchemeFactory(), configuration);
        WebServicesClient.setupUserPassAuthScheme(AuthScheme.DIGEST, "Digest", (AuthSchemeProvider)new DigestSchemeFactory(), configuration);
        WebServicesClient.setupHttpAuthScheme("Kerberos", (AuthSchemeProvider)new KerberosSchemeFactory(), AuthScope.ANY, DEFAULT_TOKEN_CREDENTIALS);
        authRegistry = registryBuilder.build();
    }

    private static void setupUserPassAuthScheme(AuthScheme scheme, String httpScheme, AuthSchemeProvider provider, ConfigProvider configuration) {
        String username = configuration.getProperty(scheme, "username");
        String password = configuration.getProperty(scheme, "password");
        if (username != null && password != null) {
            LOG.info("Setting up scheme {}", (Object)scheme);
            AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, httpScheme);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            WebServicesClient.setupHttpAuthScheme(httpScheme, provider, authScope, (Credentials)credentials);
        } else if (username != null || password != null) {
            LOG.warn("Not setting up scheme {}, missing credentials {}", (Object)scheme, (Object)(username == null ? "username" : "password"));
        }
    }

    private static void setupHttpAuthScheme(String httpScheme, AuthSchemeProvider provider, AuthScope authScope, Credentials credentials) {
        registryBuilder.register(httpScheme, (Object)provider);
        credentialsProvider.setCredentials(authScope, credentials);
    }

    public WebServicesClient() {
        this((ClientConfig)new DefaultClientConfig());
        this.client.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        this.client.getProperties().put("com.sun.jersey.client.property.connectTimeout", 10000);
        this.client.getProperties().put("com.sun.jersey.client.property.readTimeout", 10000);
    }

    public WebServicesClient(ClientConfig config) {
        if (SecurityUtils.isHadoopWebSecurityEnabled()) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            httpClientBuilder.setDefaultAuthSchemeRegistry(authRegistry);
            ApacheHttpClient4Handler httpClientHandler = new ApacheHttpClient4Handler((HttpClient)httpClientBuilder.build(), (CookieStore)new BasicCookieStore(), false);
            this.client = new Client((ClientHandler)httpClientHandler, config);
        } else {
            this.client = Client.create((ClientConfig)config);
        }
    }

    public WebServicesClient(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public boolean isFilterPresent(ClientFilter clientFilter) {
        return this.clientFilters.contains(clientFilter);
    }

    public void addFilter(ClientFilter clientFilter) {
        this.client.addFilter(clientFilter);
        this.clientFilters.add(clientFilter);
    }

    public void clearFilters() {
        this.client.removeAllFilters();
        this.clientFilters.clear();
    }

    public <T> T process(String url, Class<T> clazz, WebServicesHandler<T> handler) throws IOException {
        WebResource wr = this.client.resource(url);
        return this.process(wr.getRequestBuilder(), clazz, handler);
    }

    public <T> Future<T> process(String url, ITypeListener<T> listener, WebServicesAsyncHandler<T> handler) throws IOException {
        AsyncWebResource wr = this.client.asyncResource(url);
        return this.process(wr, listener, handler);
    }

    public <T> T process(final WebResource.Builder wr, final Class<T> clazz, final WebServicesHandler<T> handler) throws IOException {
        return SecureExecutor.execute(new SecureExecutor.WorkLoad<T>(){

            @Override
            public T run() {
                return handler.process(wr, clazz);
            }
        });
    }

    public <T> Future<T> process(final AsyncWebResource wr, final ITypeListener<T> listener, final WebServicesAsyncHandler<T> handler) throws IOException {
        return (Future)SecureExecutor.execute(new SecureExecutor.WorkLoad<Future<T>>(){

            @Override
            public Future<T> run() {
                return handler.process(wr, listener);
            }
        });
    }

    static {
        DEFAULT_TOKEN_CREDENTIALS = new Credentials(){

            public Principal getUserPrincipal() {
                return null;
            }

            public String getPassword() {
                return null;
            }
        };
        connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(5);
        registryBuilder = RegistryBuilder.create();
        credentialsProvider = new BasicCredentialsProvider();
        WebServicesClient.setupHttpAuthScheme("negotiate", (AuthSchemeProvider)new SPNegoSchemeFactory(true), AuthScope.ANY, DEFAULT_TOKEN_CREDENTIALS);
        authRegistry = registryBuilder.build();
    }

    public static class DeleteWebServicesAsyncHandler<T>
    extends WebServicesAsyncHandler<T> {
        @Override
        public Future<T> process(AsyncWebResource webResource, ITypeListener<T> listener) {
            return webResource.delete(listener);
        }
    }

    public static class DeleteWebServicesHandler<T>
    extends WebServicesHandler<T> {
        @Override
        public T process(WebResource.Builder webResource, Class<T> clazz) {
            return (T)webResource.delete(clazz);
        }
    }

    public static class GetWebServicesAsyncHandler<T>
    extends WebServicesAsyncHandler<T> {
        @Override
        public Future<T> process(AsyncWebResource webResource, ITypeListener<T> listener) {
            return webResource.get(listener);
        }
    }

    public static class GetWebServicesHandler<T>
    extends WebServicesHandler<T> {
        @Override
        public T process(WebResource.Builder webResource, Class<T> clazz) {
            return (T)webResource.get(clazz);
        }
    }

    public static abstract class WebServicesAsyncHandler<T> {
        public abstract Future<T> process(AsyncWebResource var1, ITypeListener<T> var2);

        public String toString() {
            return "WebServicesAsyncHandler{Abstract class Useful in Future}";
        }
    }

    public static abstract class WebServicesHandler<T> {
        public abstract T process(WebResource.Builder var1, Class<T> var2);

        public String toString() {
            return "WebServicesHandler{Abstract class Useful in Future}";
        }
    }

    public static interface ConfigProvider {
        public String getProperty(AuthScheme var1, String var2);
    }
}

