/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.stram.StramAppContext;
import com.datatorrent.stram.api.AppDataSource;
import com.datatorrent.stram.util.VersionInfo;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.util.Times;

@XmlRootElement(name="info")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppInfo {
    protected String appId;
    protected String name;
    protected String docLink;
    protected String user;
    protected long startTime;
    protected long elapsedTime;
    protected String appPath;
    protected String gatewayAddress;
    protected boolean gatewayConnected;
    protected List<AppDataSource> appDataSources;
    protected Map<String, Object> metrics;
    public Map<String, String> attributes;
    public String appMasterTrackingUrl;
    public String version;
    public AppStats stats;

    public AppInfo() {
    }

    public AppInfo(StramAppContext context) {
        this.appId = context.getApplicationID().toString();
        this.name = context.getApplicationName();
        this.docLink = context.getApplicationDocLink();
        this.user = context.getUser().toString();
        this.startTime = context.getStartTime();
        this.elapsedTime = Times.elapsed((long)this.startTime, (long)0L);
        this.appPath = context.getApplicationPath();
        this.appMasterTrackingUrl = context.getAppMasterTrackingUrl();
        this.stats = context.getStats();
        this.gatewayAddress = context.getGatewayAddress();
        this.version = VersionInfo.APEX_VERSION.getBuildVersion();
        this.attributes = new TreeMap<String, String>();
        for (Map.Entry entry : Attribute.AttributeMap.AttributeInitializer.getAllAttributes((Context)context, Context.DAGContext.class).entrySet()) {
            this.attributes.put(((Attribute)entry.getKey()).getSimpleName(), ((Attribute)entry.getKey()).codec.toString(entry.getValue()));
        }
        this.gatewayConnected = context.isGatewayConnected();
        this.appDataSources = context.getAppDataSources();
        this.metrics = context.getMetrics();
    }

    public String getId() {
        return this.appId;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    public boolean isGatewayConnected() {
        return this.gatewayConnected;
    }

    public List<AppDataSource> getAppDataSources() {
        return this.appDataSources;
    }

    public Map<String, Object> getMetrics() {
        return this.metrics;
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class AppStats {
        @XmlElement
        @AutoMetric
        public int getAllocatedContainers() {
            return 0;
        }

        @XmlElement
        @AutoMetric
        public int getPlannedContainers() {
            return 0;
        }

        @XmlElement
        @AutoMetric
        public int getFailedContainers() {
            return 0;
        }

        @XmlElement
        @AutoMetric
        public int getNumOperators() {
            return 0;
        }

        @XmlElement
        @AutoMetric
        public long getLatency() {
            return 0L;
        }

        @XmlElement
        public long getWindowStartMillis() {
            return 0L;
        }

        @XmlElement
        public List<Integer> getCriticalPath() {
            return null;
        }

        @XmlElement
        public long getCurrentWindowId() {
            return 0L;
        }

        @XmlElement
        public long getRecoveryWindowId() {
            return 0L;
        }

        @XmlElement
        @AutoMetric
        public long getTuplesProcessedPSMA() {
            return 0L;
        }

        @XmlElement
        @AutoMetric
        public long getTotalTuplesProcessed() {
            return 0L;
        }

        @XmlElement
        @AutoMetric
        public long getTuplesEmittedPSMA() {
            return 0L;
        }

        @XmlElement
        @AutoMetric
        public long getTotalTuplesEmitted() {
            return 0L;
        }

        @XmlElement
        @AutoMetric
        public long getTotalMemoryAllocated() {
            return 0L;
        }

        @XmlElement
        @AutoMetric
        public long getMemoryRequired() {
            return 0L;
        }

        @XmlElement
        @AutoMetric
        public int getTotalVCoresAllocated() {
            return 0;
        }

        @XmlElement
        @AutoMetric
        public int getVCoresRequired() {
            return 0;
        }

        @XmlElement
        @AutoMetric
        public long getTotalBufferServerReadBytesPSMA() {
            return 0L;
        }

        @XmlElement
        @AutoMetric
        public long getTotalBufferServerWriteBytesPSMA() {
            return 0L;
        }
    }
}

