/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp;

import com.datatorrent.stram.StreamingContainerManager;
import com.datatorrent.stram.webapp.AppInfo;
import com.datatorrent.stram.webapp.StramWebServices;
import com.datatorrent.stram.webapp.WebServices;
import com.google.inject.Singleton;
import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.RemoteExceptionData;
import org.apache.hadoop.yarn.webapp.WebApp;

public class StramWebApp
extends WebApp {
    private final StreamingContainerManager moduleManager;

    public StramWebApp(StreamingContainerManager topolManager) {
        this.moduleManager = topolManager;
    }

    public void setup() {
        this.bind(JAXBContextResolver.class);
        this.bind(GenericExceptionHandler.class);
        this.bind(WebServices.class);
        this.bind(StramWebServices.class);
        this.bind(StreamingContainerManager.class).toInstance((Object)this.moduleManager);
    }

    @Singleton
    @Provider
    public static class JAXBContextResolver
    implements ContextResolver<JAXBContext> {
        private final JAXBContext context;
        private final Set<Class<?>> types;
        private final Class<?>[] cTypes = new Class[]{AppInfo.class, RemoteExceptionData.class};

        public JAXBContextResolver() throws Exception {
            this.types = new HashSet(Arrays.asList(this.cTypes));
            this.context = new JSONJAXBContext(JSONConfiguration.natural().rootUnwrapping(false).build(), (Class[])this.cTypes);
        }

        public JAXBContext getContext(Class<?> type) {
            return this.types.contains(type) ? this.context : null;
        }
    }
}

