/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Context;
import com.datatorrent.api.Operator;
import com.datatorrent.api.StringCodec;
import com.datatorrent.stram.StramAppContext;
import com.datatorrent.stram.StramUtils;
import com.datatorrent.stram.StreamingContainerAgent;
import com.datatorrent.stram.StreamingContainerManager;
import com.datatorrent.stram.StringCodecs;
import com.datatorrent.stram.codec.LogicalPlanSerializer;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.datatorrent.stram.plan.logical.LogicalPlanConfiguration;
import com.datatorrent.stram.plan.logical.requests.LogicalPlanRequest;
import com.datatorrent.stram.util.ConfigValidator;
import com.datatorrent.stram.util.JSONSerializationProvider;
import com.datatorrent.stram.util.LoggerUtil;
import com.datatorrent.stram.webapp.AppInfo;
import com.datatorrent.stram.webapp.ContainerInfo;
import com.datatorrent.stram.webapp.ContainersInfo;
import com.datatorrent.stram.webapp.LogicalOperatorInfo;
import com.datatorrent.stram.webapp.LogicalOperatorsInfo;
import com.datatorrent.stram.webapp.OperatorAggregationInfo;
import com.datatorrent.stram.webapp.OperatorDiscoverer;
import com.datatorrent.stram.webapp.OperatorInfo;
import com.datatorrent.stram.webapp.OperatorsInfo;
import com.datatorrent.stram.webapp.PortInfo;
import com.datatorrent.stram.webapp.StreamsInfo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.std.SerializerBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/ws/v2/stram")
public class StramWebServices {
    private static final Logger LOG = LoggerFactory.getLogger(StramWebServices.class);
    public static final String PATH = "/ws/v2/stram";
    public static final String PATH_INFO = "info";
    public static final String PATH_PHYSICAL_PLAN = "physicalPlan";
    public static final String PATH_PHYSICAL_PLAN_OPERATORS = "physicalPlan/operators";
    public static final String PATH_PHYSICAL_PLAN_STREAMS = "physicalPlan/streams";
    public static final String PATH_PHYSICAL_PLAN_CONTAINERS = "physicalPlan/containers";
    public static final String PATH_SHUTDOWN = "shutdown";
    public static final String PATH_RECORDINGS = "recordings";
    public static final String PATH_RECORDINGS_START = "recordings/start";
    public static final String PATH_RECORDINGS_STOP = "recordings/stop";
    public static final String PATH_LOGICAL_PLAN = "logicalPlan";
    public static final String PATH_LOGICAL_PLAN_OPERATORS = "logicalPlan/operators";
    public static final String PATH_OPERATOR_CLASSES = "operatorClasses";
    public static final String PATH_ALERTS = "alerts";
    public static final String PATH_LOGGERS = "loggers";
    public static final String PATH_STACKTRACE = "stackTrace";
    public static final long WAIT_TIME = 5000L;
    public static final long STACK_TRACE_WAIT_TIME = 1000L;
    public static final long STACK_TRACE_ATTEMPTS = 10L;
    private StramAppContext appCtx;
    @Context
    private HttpServletResponse httpResponse;
    @Inject
    @Nullable
    private StreamingContainerManager dagManager;
    private ObjectMapper objectMapper = new JSONSerializationProvider().getContext(null);
    private boolean initialized = false;
    private OperatorDiscoverer operatorDiscoverer = new OperatorDiscoverer();

    @Inject
    public StramWebServices(StramAppContext context) {
        this.appCtx = context;
    }

    Boolean hasAccess(HttpServletRequest request) {
        UserGroupInformation callerUGI;
        String remoteUser = request.getRemoteUser();
        if (remoteUser != null && (callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser)) != null) {
            return false;
        }
        return true;
    }

    private void init() {
        this.httpResponse.setContentType(null);
        if (!this.initialized) {
            Map codecs = (Map)this.dagManager.getApplicationAttributes().get(Context.DAGContext.STRING_CODECS);
            StringCodecs.loadConverters(codecs);
            if (codecs != null) {
                SimpleModule sm = new SimpleModule("DTSerializationModule", new Version(1, 0, 0, null));
                for (Map.Entry entry : codecs.entrySet()) {
                    try {
                        final StringCodec codec = (StringCodec)((Class)entry.getValue()).newInstance();
                        sm.addSerializer((JsonSerializer)new SerializerBase((Class)entry.getKey()){

                            public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                                jgen.writeString(codec.toString(value));
                            }
                        });
                    }
                    catch (Exception ex) {
                        LOG.error("Caught exception when instantiating codec for class {}", (Object)((Class)entry.getKey()).getName(), (Object)ex);
                    }
                }
                this.objectMapper.registerModule((Module)sm);
            }
            this.initialized = true;
        }
    }

    void checkAccess(HttpServletRequest request) {
        if (!this.hasAccess(request).booleanValue()) {
            throw new SecurityException();
        }
    }

    @GET
    @Produces(value={"application/json"})
    public JSONObject get() throws Exception {
        return this.getAppInfo();
    }

    @GET
    @Path(value="info")
    @Produces(value={"application/json"})
    public JSONObject getAppInfo() throws Exception {
        this.init();
        return new JSONObject(this.objectMapper.writeValueAsString((Object)new AppInfo(this.appCtx)));
    }

    @GET
    @Path(value="physicalPlan")
    @Produces(value={"application/json"})
    public JSONObject getPhysicalPlan() throws Exception {
        this.init();
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        result.put("operators", this.dagManager.getOperatorInfoList());
        result.put("streams", this.dagManager.getStreamInfoList());
        return new JSONObject(this.objectMapper.writeValueAsString(result));
    }

    @GET
    @Path(value="physicalPlan/operators")
    @Produces(value={"application/json"})
    public JSONObject getOperatorsInfo() throws Exception {
        this.init();
        OperatorsInfo nodeList = new OperatorsInfo();
        nodeList.operators = this.dagManager.getOperatorInfoList();
        return new JSONObject(this.objectMapper.writeValueAsString((Object)nodeList));
    }

    @GET
    @Path(value="physicalPlan/streams")
    @Produces(value={"application/json"})
    public JSONObject getStreamsInfo() throws Exception {
        this.init();
        StreamsInfo streamList = new StreamsInfo();
        streamList.streams = this.dagManager.getStreamInfoList();
        return new JSONObject(this.objectMapper.writeValueAsString((Object)streamList));
    }

    @GET
    @Path(value="physicalPlan/operators/{operatorId:\\d+}")
    @Produces(value={"application/json"})
    public JSONObject getOperatorInfo(@PathParam(value="operatorId") int operatorId) throws Exception {
        this.init();
        OperatorInfo oi = this.dagManager.getOperatorInfo(operatorId);
        if (oi == null) {
            throw new NotFoundException();
        }
        return new JSONObject(this.objectMapper.writeValueAsString((Object)oi));
    }

    @GET
    @Path(value="physicalPlan/operators/{operatorId:\\d+}/ports")
    @Produces(value={"application/json"})
    public JSONObject getPortsInfo(@PathParam(value="operatorId") int operatorId) throws Exception {
        this.init();
        HashMap<String, List<PortInfo>> map = new HashMap<String, List<PortInfo>>();
        OperatorInfo oi = this.dagManager.getOperatorInfo(operatorId);
        if (oi == null) {
            throw new NotFoundException();
        }
        map.put("ports", oi.ports);
        return new JSONObject(this.objectMapper.writeValueAsString(map));
    }

    @GET
    @Path(value="physicalPlan/operators/{operatorId:\\d+}/ports/{portName}")
    @Produces(value={"application/json"})
    public JSONObject getPortsInfo(@PathParam(value="operatorId") int operatorId, @PathParam(value="portName") String portName) throws Exception {
        this.init();
        OperatorInfo oi = this.dagManager.getOperatorInfo(operatorId);
        if (oi == null) {
            throw new NotFoundException();
        }
        for (PortInfo pi : oi.ports) {
            if (!pi.name.equals(portName)) continue;
            return new JSONObject(this.objectMapper.writeValueAsString((Object)pi));
        }
        throw new NotFoundException();
    }

    @GET
    @Path(value="operatorClasses")
    @Produces(value={"application/json"})
    public JSONObject getOperatorClasses(@QueryParam(value="q") String searchTerm, @QueryParam(value="parent") String parent) {
        this.init();
        JSONObject result = new JSONObject();
        JSONArray classNames = new JSONArray();
        if (parent != null) {
            if (parent.equals("chart")) {
                parent = "com.datatorrent.lib.chart.ChartOperator";
            } else if (parent.equals("filter")) {
                parent = "com.datatorrent.common.util.SimpleFilterOperator";
            }
        }
        try {
            Set<String> operatorClasses = this.operatorDiscoverer.getOperatorClasses(parent, searchTerm);
            for (String clazz : operatorClasses) {
                JSONObject j = new JSONObject();
                j.put("name", (Object)clazz);
                classNames.put((Object)j);
            }
            result.put(PATH_OPERATOR_CLASSES, (Object)classNames);
        }
        catch (ClassNotFoundException ex) {
            throw new NotFoundException();
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    @GET
    @Path(value="operatorClasses/{className}")
    @Produces(value={"application/json"})
    public JSONObject describeOperator(@PathParam(value="className") String className) {
        this.init();
        if (className == null) {
            throw new UnsupportedOperationException();
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (Operator.class.isAssignableFrom(clazz)) {
                return this.operatorDiscoverer.describeOperator(className);
            }
            throw new NotFoundException();
        }
        catch (Exception ex) {
            throw new NotFoundException();
        }
    }

    @POST
    @Path(value="shutdown")
    @Produces(value={"application/json"})
    public JSONObject shutdown() {
        this.init();
        LOG.debug("Shutdown requested");
        this.dagManager.shutdownAllContainers("Shutdown requested externally.");
        return new JSONObject();
    }

    private static String getTupleRecordingId() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        String val = sdf.format(new Date());
        val = val + "-";
        byte[] r = new byte[4];
        new Random().nextBytes(r);
        val = val + Base64.encodeBase64URLSafeString((byte[])r);
        return val;
    }

    @POST
    @Path(value="physicalPlan/operators/{opId:\\d+}/recordings/start")
    @Produces(value={"application/json"})
    public JSONObject startRecording(@PathParam(value="opId") int opId, String content) throws JSONException {
        this.init();
        LOG.debug("Start recording on {} requested", (Object)opId);
        JSONObject response = new JSONObject();
        long numWindows = 0L;
        if (StringUtils.isNotBlank((CharSequence)content)) {
            JSONObject r = new JSONObject(content);
            numWindows = r.optLong("numWindows", 0L);
        }
        String id = StramWebServices.getTupleRecordingId();
        this.dagManager.startRecording(id, opId, null, numWindows);
        response.put("id", (Object)id);
        return response;
    }

    @POST
    @Path(value="physicalPlan/operators/{opId:\\d+}/ports/{portName}/recordings/start")
    @Produces(value={"application/json"})
    public JSONObject startRecording(@PathParam(value="opId") int opId, @PathParam(value="portName") String portName, String content) throws JSONException {
        this.init();
        LOG.debug("Start recording on {}.{} requested", (Object)opId, (Object)portName);
        JSONObject response = new JSONObject();
        long numWindows = 0L;
        if (StringUtils.isNotBlank((CharSequence)content)) {
            JSONObject r = new JSONObject(content);
            numWindows = r.optLong("numWindows", 0L);
        }
        String id = StramWebServices.getTupleRecordingId();
        this.dagManager.startRecording(id, opId, portName, numWindows);
        response.put("id", (Object)id);
        return response;
    }

    @POST
    @Path(value="physicalPlan/operators/{opId:\\d+}/recordings/stop")
    @Produces(value={"application/json"})
    public JSONObject stopRecording(@PathParam(value="opId") int opId) {
        this.init();
        LOG.debug("Start recording on {} requested", (Object)opId);
        JSONObject response = new JSONObject();
        this.dagManager.stopRecording(opId, null);
        return response;
    }

    @POST
    @Path(value="physicalPlan/operators/{opId:\\d+}/ports/{portName}/recordings/stop")
    @Produces(value={"application/json"})
    public JSONObject stopRecording(@PathParam(value="opId") int opId, @PathParam(value="portName") String portName) {
        this.init();
        LOG.debug("Stop recording on {}.{} requested", (Object)opId, (Object)portName);
        JSONObject response = new JSONObject();
        this.dagManager.stopRecording(opId, portName);
        return response;
    }

    @GET
    @Path(value="physicalPlan/containers")
    @Produces(value={"application/json"})
    public JSONObject listContainers(@QueryParam(value="states") String states) throws Exception {
        this.init();
        HashSet<String> stateSet = null;
        if (states != null) {
            stateSet = new HashSet<String>();
            stateSet.addAll(Arrays.asList(StringUtils.split((String)states, (char)',')));
        }
        ContainersInfo ci = new ContainersInfo();
        for (ContainerInfo containerInfo : this.dagManager.getCompletedContainerInfo()) {
            if (stateSet != null && !stateSet.contains(containerInfo.state)) continue;
            ci.add(containerInfo);
        }
        Collection<StreamingContainerAgent> containerAgents = this.dagManager.getContainerAgents();
        ContainerInfo appMasterContainerInfo = this.dagManager.getAppMasterContainerInfo();
        if (stateSet == null || stateSet.contains(appMasterContainerInfo.state)) {
            ci.add(appMasterContainerInfo);
        }
        for (StreamingContainerAgent sca : containerAgents) {
            ContainerInfo containerInfo = sca.getContainerInfo();
            if (stateSet != null && !stateSet.contains(containerInfo.state)) continue;
            ci.add(containerInfo);
        }
        return new JSONObject(this.objectMapper.writeValueAsString((Object)ci));
    }

    @GET
    @Path(value="physicalPlan/containers/{containerId}")
    @Produces(value={"application/json"})
    public JSONObject getContainer(@PathParam(value="containerId") String containerId) throws Exception {
        this.init();
        ContainerInfo ci = null;
        if (containerId.equals(System.getenv(ApplicationConstants.Environment.CONTAINER_ID.toString()))) {
            ci = this.dagManager.getAppMasterContainerInfo();
        } else {
            for (ContainerInfo containerInfo : this.dagManager.getCompletedContainerInfo()) {
                if (!containerInfo.id.equals(containerId)) continue;
                ci = containerInfo;
            }
            if (ci == null) {
                StreamingContainerAgent sca = this.dagManager.getContainerAgent(containerId);
                if (sca == null) {
                    throw new NotFoundException();
                }
                ci = sca.getContainerInfo();
            }
        }
        return new JSONObject(this.objectMapper.writeValueAsString((Object)ci));
    }

    @GET
    @Path(value="physicalPlan/containers/{containerId}/stackTrace")
    @Produces(value={"application/json"})
    public JSONObject getContainerStackTrace(@PathParam(value="containerId") String containerId) throws Exception {
        this.init();
        if (containerId.equals(System.getenv(ApplicationConstants.Environment.CONTAINER_ID.toString()))) {
            return StramUtils.getStackTrace();
        }
        StreamingContainerAgent sca = this.dagManager.getContainerAgent(containerId);
        if (sca == null) {
            throw new NotFoundException("Container not found.");
        }
        if (!sca.getContainerInfo().state.equals("ACTIVE")) {
            throw new NotFoundException("Container is not active.");
        }
        int i = 0;
        while ((long)i < 10L) {
            String result = sca.getStackTrace();
            if (result != null) {
                return new JSONObject(result);
            }
            Thread.sleep(1000L);
            ++i;
        }
        throw new TimeoutException("Not able to get the stack trace");
    }

    @POST
    @Path(value="physicalPlan/containers/{containerId}/kill")
    @Produces(value={"application/json"})
    public JSONObject killContainer(@PathParam(value="containerId") String containerId) {
        this.init();
        JSONObject response = new JSONObject();
        if (containerId.equals(System.getenv(ApplicationConstants.Environment.CONTAINER_ID.toString()))) {
            LOG.info("Received a kill request on application master container. Exiting.");
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                        System.exit(1);
                    }
                    catch (InterruptedException ex) {
                        LOG.info("Received interrupt, aborting exit.");
                    }
                }
            }.start();
        } else {
            this.dagManager.stopContainer(containerId);
        }
        return response;
    }

    @GET
    @Path(value="logicalPlan/operators")
    @Produces(value={"application/json"})
    public JSONObject getLogicalOperators() throws Exception {
        this.init();
        LogicalOperatorsInfo nodeList = new LogicalOperatorsInfo();
        nodeList.operators = this.dagManager.getLogicalOperatorInfoList();
        return new JSONObject(this.objectMapper.writeValueAsString((Object)nodeList));
    }

    @GET
    @Path(value="logicalPlan/operators/{operatorName}")
    @Produces(value={"application/json"})
    public JSONObject getLogicalOperator(@PathParam(value="operatorName") String operatorName) throws Exception {
        this.init();
        LogicalPlan.OperatorMeta logicalOperator = this.dagManager.getLogicalPlan().getOperatorMeta(operatorName);
        if (logicalOperator == null) {
            throw new NotFoundException();
        }
        LogicalOperatorInfo logicalOperatorInfo = this.dagManager.getLogicalOperatorInfo(operatorName);
        return new JSONObject(this.objectMapper.writeValueAsString((Object)logicalOperatorInfo));
    }

    @GET
    @Path(value="logicalPlan/operators/{operatorName}/aggregation")
    @Produces(value={"application/json"})
    public JSONObject getOperatorAggregation(@PathParam(value="operatorName") String operatorName) throws Exception {
        this.init();
        LogicalPlan.OperatorMeta logicalOperator = this.dagManager.getLogicalPlan().getOperatorMeta(operatorName);
        if (logicalOperator == null) {
            throw new NotFoundException();
        }
        OperatorAggregationInfo operatorAggregationInfo = this.dagManager.getOperatorAggregationInfo(operatorName);
        return new JSONObject(this.objectMapper.writeValueAsString((Object)operatorAggregationInfo));
    }

    @POST
    @Path(value="logicalPlan/operators/{operatorName}/properties")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JSONObject setOperatorProperties(JSONObject request, @PathParam(value="operatorName") String operatorName) {
        this.init();
        LogicalPlan.OperatorMeta logicalOperator = this.dagManager.getLogicalPlan().getOperatorMeta(operatorName);
        if (logicalOperator == null) {
            throw new NotFoundException();
        }
        JSONObject response = new JSONObject();
        try {
            Iterator keys = request.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = request.isNull(key) ? null : request.getString(key);
                LOG.debug("Setting property for {}: {}={}", new Object[]{operatorName, key, val});
                this.dagManager.setOperatorProperty(operatorName, key, val);
            }
        }
        catch (JSONException ex) {
            LOG.warn("Got JSON Exception: ", (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error("Caught exception: ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return response;
    }

    @POST
    @Path(value="physicalPlan/operators/{operatorId:\\d+}/properties")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JSONObject setPhysicalOperatorProperties(JSONObject request, @PathParam(value="operatorId") int operatorId) {
        this.init();
        JSONObject response = new JSONObject();
        try {
            Iterator keys = request.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = request.isNull(key) ? null : request.getString(key);
                this.dagManager.setPhysicalOperatorProperty(operatorId, key, val);
            }
        }
        catch (JSONException ex) {
            LOG.warn("Got JSON Exception: ", (Throwable)ex);
        }
        return response;
    }

    @GET
    @Path(value="logicalPlan/operators/{operatorName}/attributes")
    @Produces(value={"application/json"})
    public JSONObject getOperatorAttributes(@PathParam(value="operatorName") String operatorName, @QueryParam(value="attributeName") String attributeName) {
        this.init();
        LogicalPlan.OperatorMeta logicalOperator = this.dagManager.getLogicalPlan().getOperatorMeta(operatorName);
        if (logicalOperator == null) {
            throw new NotFoundException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : this.dagManager.getOperatorAttributes(operatorName).entrySet()) {
            if (attributeName != null && !((Attribute)entry.getKey()).getSimpleName().equals(attributeName)) continue;
            Map.Entry entry1 = entry;
            map.put(((Attribute)entry1.getKey()).getSimpleName(), ((Attribute)entry1.getKey()).codec.toString(entry1.getValue()));
        }
        return new JSONObject(map);
    }

    @GET
    @Path(value="logicalPlan/attributes")
    @Produces(value={"application/json"})
    public JSONObject getApplicationAttributes(@QueryParam(value="attributeName") String attributeName) {
        this.init();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : this.dagManager.getApplicationAttributes().entrySet()) {
            if (attributeName != null && !((Attribute)entry.getKey()).getSimpleName().equals(attributeName)) continue;
            Map.Entry entry1 = entry;
            map.put(((Attribute)entry1.getKey()).getSimpleName(), ((Attribute)entry1.getKey()).codec.toString(entry1.getValue()));
        }
        return new JSONObject(map);
    }

    @GET
    @Path(value="logicalPlan/operators/{operatorName}/ports")
    @Produces(value={"application/json"})
    public JSONObject getPorts(@PathParam(value="operatorName") String operatorName) {
        Set<LogicalPlan.OutputPortMeta> outputPorts;
        Set<LogicalPlan.InputPortMeta> inputPorts;
        this.init();
        LogicalPlan.OperatorMeta logicalOperator = this.dagManager.getLogicalPlan().getOperatorMeta(operatorName);
        if (logicalOperator == null) {
            LogicalPlan.ModuleMeta logicalModule = this.dagManager.getModuleMeta(operatorName);
            if (logicalModule == null) {
                throw new NotFoundException();
            }
            inputPorts = logicalModule.getInputStreams().keySet();
            outputPorts = logicalModule.getOutputStreams().keySet();
        } else {
            inputPorts = logicalOperator.getInputStreams().keySet();
            outputPorts = logicalOperator.getOutputStreams().keySet();
        }
        JSONObject result = this.getPortsObjects(inputPorts, outputPorts);
        return result;
    }

    private JSONObject getPortsObjects(Collection<LogicalPlan.InputPortMeta> inputs, Collection<LogicalPlan.OutputPortMeta> outputs) {
        JSONObject result = new JSONObject();
        JSONArray ports = new JSONArray();
        try {
            JSONObject port;
            for (LogicalPlan.InputPortMeta inputPort : inputs) {
                port = new JSONObject();
                port.put("name", (Object)inputPort.getPortName());
                port.put("type", (Object)"input");
                ports.put((Object)port);
            }
            for (LogicalPlan.OutputPortMeta outputPort : outputs) {
                port = new JSONObject();
                port.put("name", (Object)outputPort.getPortName());
                port.put("type", (Object)"output");
                ports.put((Object)port);
            }
            result.put("ports", (Object)ports);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    private JSONObject getPortObject(Collection<LogicalPlan.InputPortMeta> inputs, Collection<LogicalPlan.OutputPortMeta> outputs, String portName) throws JSONException {
        for (LogicalPlan.InputPortMeta inputPort : inputs) {
            if (!inputPort.getPortName().equals(portName)) continue;
            JSONObject port = new JSONObject();
            port.put("name", (Object)inputPort.getPortName());
            port.put("type", (Object)"input");
            return port;
        }
        for (LogicalPlan.OutputPortMeta outputPort : outputs) {
            if (!outputPort.getPortName().equals(portName)) continue;
            JSONObject port = new JSONObject();
            port.put("name", (Object)outputPort.getPortName());
            port.put("type", (Object)"output");
            return port;
        }
        return null;
    }

    @GET
    @Path(value="logicalPlan/operators/{operatorName}/ports/{portName}")
    @Produces(value={"application/json"})
    public JSONObject getPort(@PathParam(value="operatorName") String operatorName, @PathParam(value="portName") String portName) {
        Set<LogicalPlan.OutputPortMeta> outputPorts;
        Set<LogicalPlan.InputPortMeta> inputPorts;
        this.init();
        LogicalPlan.OperatorMeta logicalOperator = this.dagManager.getLogicalPlan().getOperatorMeta(operatorName);
        if (logicalOperator == null) {
            LogicalPlan.ModuleMeta logicalModule = this.dagManager.getModuleMeta(operatorName);
            if (logicalModule == null) {
                throw new NotFoundException();
            }
            inputPorts = logicalModule.getInputStreams().keySet();
            outputPorts = logicalModule.getOutputStreams().keySet();
        } else {
            inputPorts = logicalOperator.getInputStreams().keySet();
            outputPorts = logicalOperator.getOutputStreams().keySet();
        }
        try {
            JSONObject resp = this.getPortObject(inputPorts, outputPorts, portName);
            if (resp != null) {
                return resp;
            }
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        throw new NotFoundException();
    }

    @GET
    @Path(value="logicalPlan/operators/{operatorName}/ports/{portName}/attributes")
    @Produces(value={"application/json"})
    public JSONObject getPortAttributes(@PathParam(value="operatorName") String operatorName, @PathParam(value="portName") String portName, @QueryParam(value="attributeName") String attributeName) {
        this.init();
        LogicalPlan.OperatorMeta logicalOperator = this.dagManager.getLogicalPlan().getOperatorMeta(operatorName);
        if (logicalOperator == null) {
            throw new NotFoundException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : this.dagManager.getPortAttributes(operatorName, portName).entrySet()) {
            if (attributeName != null && !((Attribute)entry.getKey()).getSimpleName().equals(attributeName)) continue;
            Map.Entry entry1 = entry;
            map.put(((Attribute)entry1.getKey()).getSimpleName(), ((Attribute)entry1.getKey()).codec.toString(entry1.getValue()));
        }
        return new JSONObject(map);
    }

    @GET
    @Path(value="logicalPlan/operators/{operatorName}/properties")
    @Produces(value={"application/json"})
    public JSONObject getOperatorProperties(@PathParam(value="operatorName") String operatorName, @QueryParam(value="propertyName") String propertyName) throws IOException, JSONException {
        this.init();
        LogicalPlan.OperatorMeta logicalOperator = this.dagManager.getLogicalPlan().getOperatorMeta(operatorName);
        BeanMap operatorProperties = null;
        if (logicalOperator == null) {
            LogicalPlan.ModuleMeta logicalModule = this.dagManager.getModuleMeta(operatorName);
            if (logicalModule == null) {
                throw new NotFoundException();
            }
            operatorProperties = LogicalPlanConfiguration.getObjectProperties(logicalModule.getOperator());
        } else {
            operatorProperties = LogicalPlanConfiguration.getObjectProperties(logicalOperator.getOperator());
        }
        Map<String, Object> m = this.getPropertiesAsMap(propertyName, operatorProperties);
        return new JSONObject(this.objectMapper.writeValueAsString(m));
    }

    private Map<String, Object> getPropertiesAsMap(@QueryParam(value="propertyName") String propertyName, BeanMap operatorProperties) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        Iterator entryIterator = operatorProperties.entryIterator();
        while (entryIterator.hasNext()) {
            try {
                Map.Entry entry = (Map.Entry)entryIterator.next();
                if (propertyName == null) {
                    m.put((String)entry.getKey(), entry.getValue());
                    continue;
                }
                if (!propertyName.equals(entry.getKey())) continue;
                m.put((String)entry.getKey(), entry.getValue());
                break;
            }
            catch (Exception ex) {
                LOG.warn("Caught exception", (Throwable)ex);
            }
        }
        return m;
    }

    @GET
    @Path(value="physicalPlan/operators/{operatorId:\\d+}/properties")
    @Produces(value={"application/json"})
    public JSONObject getPhysicalOperatorProperties(@PathParam(value="operatorId") int operatorId, @QueryParam(value="propertyName") String propertyName, @QueryParam(value="waitTime") long waitTime) {
        this.init();
        if (waitTime == 0L) {
            waitTime = 5000L;
        }
        FutureTask<Object> future = this.dagManager.getPhysicalOperatorProperty(operatorId, propertyName, waitTime);
        try {
            Object object = future.get(waitTime, TimeUnit.MILLISECONDS);
            if (object != null) {
                return new JSONObject(new ObjectMapper().writeValueAsString(object));
            }
        }
        catch (Exception ex) {
            LOG.warn("Caught exception", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return new JSONObject();
    }

    @GET
    @Path(value="logicalPlan")
    @Produces(value={"application/json"})
    public JSONObject getLogicalPlan(@QueryParam(value="includeModules") String includeModules) throws JSONException, IOException {
        this.init();
        return new JSONObject(this.objectMapper.writeValueAsString(LogicalPlanSerializer.convertToMap(this.dagManager.getLogicalPlan(), includeModules != null)));
    }

    @POST
    @Path(value="logicalPlan")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JSONObject logicalPlanModification(JSONObject request) {
        this.init();
        JSONObject response = new JSONObject();
        try {
            JSONArray jsonArray = request.getJSONArray("requests");
            ArrayList<LogicalPlanRequest> requests = new ArrayList<LogicalPlanRequest>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObj = (JSONObject)jsonArray.get(i);
                LogicalPlanRequest requestObj = (LogicalPlanRequest)Class.forName(LogicalPlanRequest.class.getPackage().getName() + "." + jsonObj.getString("requestType")).newInstance();
                Map properties = BeanUtils.describe((Object)requestObj);
                Iterator keys = jsonObj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (key.equals("requestType")) continue;
                    properties.put(key, jsonObj.get(key).toString());
                }
                BeanUtils.populate((Object)requestObj, (Map)properties);
                requests.add(requestObj);
            }
            FutureTask<Object> fr = this.dagManager.logicalPlanModification(requests);
            fr.get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            LOG.error("Error processing plan change", (Throwable)ex);
            try {
                if (ex instanceof ExecutionException) {
                    response.put("error", (Object)ex.getCause().toString());
                } else {
                    response.put("error", (Object)ex.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return response;
    }

    @POST
    @Path(value="loggers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JSONObject setLoggersLevel(JSONObject request) {
        this.init();
        JSONObject response = new JSONObject();
        HashMap targetChanges = Maps.newHashMap();
        try {
            JSONArray loggerArray = request.getJSONArray(PATH_LOGGERS);
            for (int i = 0; i < loggerArray.length(); ++i) {
                String level;
                JSONObject loggerNode = loggerArray.getJSONObject(i);
                String target = loggerNode.getString("target");
                if (ConfigValidator.validateLoggersLevel(target, level = loggerNode.getString("logLevel"))) {
                    LOG.info("changing logger level for {} to {}", (Object)target, (Object)level);
                    targetChanges.put(target, level);
                    continue;
                }
                LOG.warn("incorrect logger settings {}:{}", (Object)target, (Object)level);
            }
            if (!targetChanges.isEmpty()) {
                this.dagManager.setLoggersLevel(Collections.unmodifiableMap(targetChanges));
                LoggerUtil.changeLoggersLevel(targetChanges);
            }
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        return response;
    }

    @GET
    @Path(value="loggers/search")
    @Produces(value={"application/json"})
    public JSONObject searchLoggersLevel(@QueryParam(value="pattern") String pattern) {
        this.init();
        JSONObject response = new JSONObject();
        JSONArray loggersArray = new JSONArray();
        try {
            if (pattern != null) {
                ImmutableMap<String, String> matches = LoggerUtil.getClassesMatching(pattern);
                for (Map.Entry match : matches.entrySet()) {
                    JSONObject node = new JSONObject();
                    node.put("name", match.getKey());
                    node.put("level", match.getValue());
                    loggersArray.put((Object)node);
                }
            }
            response.put(PATH_LOGGERS, (Object)loggersArray);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        return response;
    }

    @GET
    @Path(value="loggers")
    @Produces(value={"application/json"})
    public JSONObject getLoggerLevels() throws JSONException {
        this.init();
        JSONObject response = new JSONObject();
        JSONArray levelsArray = new JSONArray();
        ImmutableMap<String, String> currentLevels = LoggerUtil.getPatternLevels();
        for (Map.Entry lvl : currentLevels.entrySet()) {
            JSONObject node = new JSONObject();
            node.put("target", lvl.getKey());
            node.put("logLevel", lvl.getValue());
            levelsArray.put((Object)node);
        }
        response.put(PATH_LOGGERS, (Object)levelsArray);
        return response;
    }
}

