/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Context;
import com.datatorrent.stram.api.BaseContext;
import com.datatorrent.stram.engine.PortContext;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDiscoverer {
    private static final Logger LOG = LoggerFactory.getLogger(TypeDiscoverer.class);
    private static Predicate<Field> attrPredicate = new Predicate<Field>(){

        public boolean apply(Field input) {
            return input.getType().equals(Attribute.class);
        }
    };
    public final Map<String, Type> typeArguments = Maps.newHashMap();

    public static Type getParameterizedTypeArgument(Type type, Class<?> rawType) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            if (rawType == null || rawType.isAssignableFrom((Class)ptype.getRawType())) {
                return ptype.getActualTypeArguments()[0];
            }
        }
        return null;
    }

    private void getParameterizedTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            LOG.debug("generic interface or class {} with type parameters {}", (Object)type, (Object)ptype.getActualTypeArguments());
            Type[] actualTypeArguments = ptype.getActualTypeArguments();
            Type rawType = ptype.getRawType();
            if (rawType instanceof Class) {
                Class rawTypeClass = (Class)rawType;
                TypeVariable<Class<T>>[] typeParameters = rawTypeClass.getTypeParameters();
                if (actualTypeArguments.length != typeParameters.length) {
                    throw new AssertionError((Object)("type parameters don't match for " + type));
                }
                for (int i = 0; i < typeParameters.length; ++i) {
                    LOG.debug("{} tv {} bounds {} type arg {}", new Object[]{rawTypeClass.getSimpleName(), typeParameters[i].getName(), typeParameters[i].getBounds(), actualTypeArguments[i]});
                    if (this.typeArguments.containsKey(typeParameters[i].getName())) continue;
                    this.typeArguments.put(typeParameters[i].getName(), actualTypeArguments[i]);
                }
            }
        }
    }

    private void resolveTypeParameters(Type type, JSONObject meta) throws JSONException {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            JSONArray typeArgs = new JSONArray();
            for (Type argType : ptype.getActualTypeArguments()) {
                JSONObject argMeta = new JSONObject();
                this.resolveTypeParameters(argType, argMeta);
                typeArgs.put((Object)argMeta);
            }
            meta.put("typeArgs", (Object)typeArgs);
            meta.put("type", (Object)((Class)ptype.getRawType()).getName());
            UI_TYPE uiType = UI_TYPE.getEnumFor((Class)ptype.getRawType());
            if (uiType != null) {
                meta.put("uiType", (Object)uiType.getName());
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            JSONArray typeArgs = new JSONArray();
            JSONObject argMeta = new JSONObject();
            Type componentType = gat.getGenericComponentType();
            if ((componentType = this.typeArguments.get(componentType.toString())) == null) {
                componentType = gat.getGenericComponentType();
            }
            this.resolveTypeParameters(componentType, argMeta);
            typeArgs.put((Object)argMeta);
            meta.put("typeArgs", (Object)typeArgs);
            if (componentType instanceof Class) {
                meta.put("type", (Object)Array.newInstance((Class)componentType, 0).getClass().getName());
            } else {
                meta.put("type", (Object)Object[].class.getName());
            }
        } else if (type instanceof WildcardType) {
            meta.put("type", (Object)type);
            WildcardType wtype = (WildcardType)type;
            JSONObject wtMeta = new JSONObject();
            wtMeta.put("upper", (Object)this.getTypes(wtype.getUpperBounds()));
            wtMeta.put("lower", (Object)this.getTypes(wtype.getLowerBounds()));
            meta.put("typeBounds", (Object)wtMeta);
        } else {
            Type ta = this.typeArguments.get(type.toString());
            if (ta == null) {
                ta = type;
            }
            if (ta instanceof Class) {
                meta.put("type", (Object)((Class)ta).getName());
                UI_TYPE uiType = UI_TYPE.getEnumFor((Class)ta);
                if (uiType != null) {
                    meta.put("uiType", (Object)uiType.getName());
                }
            } else if (ta instanceof ParameterizedType) {
                this.resolveTypeParameters(ta, meta);
            } else {
                meta.put("type", (Object)ta.toString());
            }
        }
    }

    private JSONArray getTypes(Type[] types) {
        JSONArray jsontypes = new JSONArray();
        for (Type upperBound : types) {
            String s = upperBound.toString();
            Type type = this.typeArguments.get(s);
            if (type == null) {
                type = upperBound;
            }
            jsontypes.put((Object)type.toString());
        }
        return jsontypes;
    }

    public void setTypeArguments(Class<?> clazz, Type type, JSONObject meta) {
        Type superClassType = clazz.getGenericSuperclass();
        if (superClassType != null) {
            this.getParameterizedTypeArguments(superClassType);
        }
        this.getParameterizedTypeArguments(type);
        try {
            this.resolveTypeParameters(type, meta);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static JSONObject getAppAttributes() throws JSONException, IllegalAccessException {
        Field[] fields = Context.DAGContext.class.getFields();
        Collection attributes = Collections2.filter(Arrays.asList(fields), attrPredicate);
        return TypeDiscoverer.getAttrDescription((Context)new LogicalPlan(), attributes);
    }

    public static JSONObject getOperatorAttributes() throws JSONException, IllegalAccessException {
        Field[] fields = Context.OperatorContext.class.getFields();
        Collection attributes = Collections2.filter(Arrays.asList(fields), attrPredicate);
        return TypeDiscoverer.getAttrDescription(new BaseContext(null, null), attributes);
    }

    public static JSONObject getPortAttributes() throws JSONException, IllegalAccessException {
        Field[] fields = Context.PortContext.class.getFields();
        Collection attributes = Collections2.filter(Arrays.asList(fields), attrPredicate);
        return TypeDiscoverer.getAttrDescription(new PortContext(null, null), attributes);
    }

    private static JSONObject getAttrDescription(Context context, Collection<Field> attributes) throws JSONException, IllegalAccessException {
        JSONObject response = new JSONObject();
        JSONArray attrArray = new JSONArray();
        response.put("attributes", (Object)attrArray);
        for (Field attrField : attributes) {
            JSONObject attrJson = new JSONObject();
            attrJson.put("name", (Object)attrField.getName());
            ParameterizedType attrType = (ParameterizedType)attrField.getGenericType();
            Attribute attr = (Attribute)attrField.get(context);
            Type pType = attrType.getActualTypeArguments()[0];
            TypeDiscoverer discoverer = new TypeDiscoverer();
            discoverer.resolveTypeParameters(pType, attrJson);
            if (attr.defaultValue != null) {
                attrJson.put("default", attr.defaultValue);
            }
            attrArray.put((Object)attrJson);
        }
        return response;
    }

    static enum UI_TYPE {
        LIST(Collection.class, "List"),
        ENUM(Enum.class, "Enum"),
        MAP(Map.class, "Map");

        private final Class<?> assignableTo;
        private final String name;

        private UI_TYPE(Class<?> assignableTo, String name) {
            this.assignableTo = assignableTo;
            this.name = name;
        }

        public static UI_TYPE getEnumFor(Class<?> clazz) {
            if (clazz.isEnum()) {
                return ENUM;
            }
            if (clazz.isArray()) {
                return LIST;
            }
            for (UI_TYPE ui_type : UI_TYPE.values()) {
                if (!ui_type.assignableTo.isAssignableFrom(clazz)) continue;
                return ui_type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

