/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp;

import com.datatorrent.stram.webapp.TypeGraph;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeGraphFactory {
    private static final byte[] preComputeGraph;
    private static final Logger LOG;
    private static TypeGraph tg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeGraph createTypeGraphProtoType() {
        TypeGraph typeGraph;
        Input input = null;
        try {
            input = new Input((InputStream)new ByteArrayInputStream(preComputeGraph));
            Kryo kryo = new Kryo();
            TypeGraph.TypeGraphSerializer tgs = new TypeGraph.TypeGraphSerializer();
            kryo.register(TypeGraph.class, (Serializer)tgs);
            typeGraph = (TypeGraph)kryo.readObject(input, TypeGraph.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        return typeGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String[] paths;
        LOG = LoggerFactory.getLogger(TypeGraphFactory.class);
        tg = null;
        LOG.debug("Pre compute the type graph out of classes in jdk and jars in current classpath");
        HashSet<String> pathsToScan = new HashSet<String>();
        String classpath = System.getProperty("java.class.path");
        for (String path : paths = classpath.split(":")) {
            pathsToScan.add(path);
        }
        String javahome = System.getProperty("java.home");
        String jdkJar = javahome + "/lib/rt.jar";
        pathsToScan.add(jdkJar);
        tg = new TypeGraph();
        for (String path : pathsToScan) {
            try {
                File f = new File(path);
                if (!f.exists() || !f.getName().endsWith("jar")) continue;
                try (JarFile jar = new JarFile(path);){
                    Enumeration<JarEntry> entriesEnum = jar.entries();
                    while (entriesEnum.hasMoreElements()) {
                        JarEntry jarEntry = entriesEnum.nextElement();
                        if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
                        tg.addNode(jarEntry, jar);
                    }
                }
            }
            catch (IOException ex) {
                LOG.warn("Some error happens when parsing the file {}", (Object)path, (Object)ex);
            }
        }
        Kryo kryo = new Kryo();
        TypeGraph.TypeGraphSerializer tgs = new TypeGraph.TypeGraphSerializer();
        kryo.register(TypeGraph.class, (Serializer)tgs);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(0x1400000);
        Output output = new Output((OutputStream)baos);
        kryo.writeObject(output, (Object)tg);
        output.close();
        preComputeGraph = baos.toByteArray();
        LOG.warn("The size of precomputed type graph is {} KB", (Object)(preComputeGraph.length / 1024));
    }
}

