/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.webapp.asm;

import com.datatorrent.stram.webapp.asm.ASMUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class FastClassIndexReader {
    static final int CLASS = 7;
    static final int FIELD = 9;
    static final int METH = 10;
    static final int IMETH = 11;
    static final int STR = 8;
    static final int INT = 3;
    static final int FLOAT = 4;
    static final int LONG = 5;
    static final int DOUBLE = 6;
    static final int NAME_TYPE = 12;
    static final int UTF8 = 1;
    static final int MTYPE = 16;
    static final int HANDLE = 15;
    static final int INDY = 18;
    private static byte[] b = new byte[65536];
    private static int bSize = 0;
    private int[] items;
    private int header;
    private String name;
    private String superName;
    private String[] interfaces;
    public static final byte[] DEFAULT_CONSTRUCTOR_NAME = new byte[]{0, 6, 60, 105, 110, 105, 116, 62};
    public static final byte[] DEFAULT_CONSTRUCTOR_DESC = new byte[]{0, 3, 40, 41, 86};
    private boolean isInstantiable = false;

    public FastClassIndexReader(InputStream is) throws IOException {
        this.readIntoBuffer(is);
        this.readConstantPool();
        this.readIndex();
    }

    private void readIntoBuffer(InputStream is) throws IOException {
        int n;
        if (is == null) {
            throw new IOException("Class not found");
        }
        bSize = 0;
        while ((n = is.read(b, bSize, b.length - bSize)) != -1) {
            if ((bSize += n) < b.length) continue;
            byte[] c = new byte[b.length << 2];
            System.arraycopy(b, 0, c, 0, b.length);
            b = c;
        }
    }

    private void readConstantPool() {
        if (this.readShort(6) > 52) {
            throw new IllegalArgumentException();
        }
        this.items = new int[this.readUnsignedShort(8)];
        int n = this.items.length;
        int index = 10;
        for (int i = 1; i < n; ++i) {
            int size;
            this.items[i] = index + 1;
            switch (b[index]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i;
                    break;
                }
                case 1: {
                    size = 3 + this.readUnsignedShort(index + 1);
                    break;
                }
                case 15: {
                    size = 4;
                    break;
                }
                default: {
                    size = 3;
                }
            }
            index += size;
        }
        this.header = index;
    }

    private void readIndex() throws UnsupportedEncodingException {
        int j;
        int i;
        int u = this.header;
        int access = this.readUnsignedShort(u);
        this.isInstantiable = ASMUtil.isPublic(access) && !ASMUtil.isAbstract(access);
        this.name = this.readClass(u + 2);
        this.superName = this.readClass(u + 4);
        this.interfaces = new String[this.readUnsignedShort(u + 6)];
        u += 8;
        for (i = 0; i < this.interfaces.length; ++i) {
            this.interfaces[i] = this.readClass(u);
            u += 2;
        }
        if (!this.isInstantiable) {
            return;
        }
        for (i = this.readUnsignedShort(u); i > 0; --i) {
            for (j = this.readUnsignedShort(u + 8); j > 0; --j) {
                u += 6 + this.readInt(u + 12);
            }
            u += 8;
        }
        for (i = this.readUnsignedShort(u += 2); i > 0; --i) {
            if (this.isDefaultConstructor(u + 2)) {
                return;
            }
            for (j = this.readUnsignedShort(u + 8); j > 0; --j) {
                u += 6 + this.readInt(u + 12);
            }
            u += 8;
        }
        this.isInstantiable = false;
    }

    private boolean isDefaultConstructor(int methodIndex) throws UnsupportedEncodingException {
        return this.arrayContains(b, this.items[this.readUnsignedShort(methodIndex + 2)], DEFAULT_CONSTRUCTOR_NAME) && this.arrayContains(b, this.items[this.readUnsignedShort(methodIndex + 4)], DEFAULT_CONSTRUCTOR_DESC) && ASMUtil.isPublic(this.readUnsignedShort(methodIndex));
    }

    private boolean arrayContains(byte[] bb, int i, byte[] subArray) {
        for (int l = 0; l < subArray.length; ++l) {
            if (bb[i + l] == subArray[l]) continue;
            return false;
        }
        return true;
    }

    public int readUnsignedShort(int index) {
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    public short readShort(int index) {
        return (short)((b[index] & 0xFF) << 8 | b[index + 1] & 0xFF);
    }

    public int readInt(int index) {
        return (b[index] & 0xFF) << 24 | (b[index + 1] & 0xFF) << 16 | (b[index + 2] & 0xFF) << 8 | b[index + 3] & 0xFF;
    }

    public String readClass(int index) throws UnsupportedEncodingException {
        return this.readUTF8(this.items[this.readUnsignedShort(index)]);
    }

    public String readUTF8(int index) throws UnsupportedEncodingException {
        int item = this.readUnsignedShort(index);
        if (index == 0 || item == 0) {
            return null;
        }
        index = this.items[item];
        return new String(b, index + 2, this.readUnsignedShort(index), "UTF-8");
    }

    public String getName() {
        return this.name;
    }

    public String getSuperName() {
        return this.superName;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public boolean isInstantiable() {
        return this.isInstantiable;
    }
}

