/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.engine;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.StreamingApplication;
import com.datatorrent.stram.client.StramAppLauncher;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.datatorrent.stram.plan.logical.LogicalPlanConfiguration;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.apex.api.Launcher;
import org.apache.apex.api.YarnAppLauncher;
import org.apache.apex.engine.util.StreamingAppFactory;
import org.apache.bval.jsr303.util.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class YarnAppLauncherImpl
extends YarnAppLauncher<YarnAppHandleImpl> {
    private static final Map<Attribute<?>, String> propMapping = new HashMap();

    public YarnAppHandleImpl launchApp(final StreamingApplication app, Configuration conf, Attribute.AttributeMap launchParameters) throws Launcher.LauncherException {
        if (launchParameters != null) {
            for (Map.Entry entry : launchParameters.entrySet()) {
                String property = propMapping.get(entry.getKey());
                if (property == null) continue;
                this.setConfiguration(conf, property, entry.getValue());
            }
        }
        try {
            String name = app.getClass().getName();
            StramAppLauncher appLauncher = new StramAppLauncher(name, conf);
            appLauncher.loadDependencies();
            StreamingAppFactory appFactory = new StreamingAppFactory(name, app.getClass()){

                @Override
                public LogicalPlan createApp(LogicalPlanConfiguration planConfig) {
                    return super.createApp(app, planConfig);
                }
            };
            ApplicationId appId = appLauncher.launchApp(appFactory);
            return new YarnAppHandleImpl(appId);
        }
        catch (Exception ex) {
            throw new Launcher.LauncherException((Throwable)ex);
        }
    }

    protected void shutdownApp(YarnAppHandleImpl app, Launcher.ShutdownMode shutdownMode) throws Launcher.LauncherException {
        if (shutdownMode == Launcher.ShutdownMode.KILL) {
            YarnClient yarnClient = YarnClient.createYarnClient();
            try {
                ApplicationId applicationId = app.appId;
                ApplicationReport appReport = yarnClient.getApplicationReport(applicationId);
                if (appReport == null) {
                    throw new Launcher.LauncherException("Application " + app.getApplicationId() + " not found");
                }
                yarnClient.killApplication(applicationId);
            }
            catch (IOException | YarnException e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Closeable)yarnClient);
            }
        } else {
            throw new UnsupportedOperationException("Orderly shutdown not supported, try kill instead");
        }
    }

    private void setConfiguration(Configuration conf, String property, Object value) {
        if (value instanceof Integer) {
            conf.setInt(property, ((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            conf.setBoolean(property, ((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            conf.setLong(property, ((Long)value).longValue());
        } else if (value instanceof Float) {
            conf.setFloat(property, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            conf.setDouble(property, ((Double)value).doubleValue());
        } else {
            conf.set(property, value.toString());
        }
    }

    static {
        propMapping.put(YarnAppLauncher.LIB_JARS, "_apex.libjars");
        propMapping.put(YarnAppLauncher.ORIGINAL_APP_ID, "_apex.originalAppId");
        propMapping.put(YarnAppLauncher.QUEUE_NAME, "_apex.queueName");
    }

    public class YarnAppHandleImpl
    implements YarnAppLauncher.YarnAppHandle {
        final ApplicationId appId;

        public YarnAppHandleImpl(ApplicationId appId) {
            this.appId = appId;
        }

        public String getApplicationId() {
            return this.appId.toString();
        }

        public boolean isFinished() {
            YarnClient yarnClient = YarnClient.createYarnClient();
            try {
                ApplicationReport appReport = yarnClient.getApplicationReport(this.appId);
                if (appReport != null && (appReport.getFinalApplicationStatus() == null || appReport.getFinalApplicationStatus() == FinalApplicationStatus.UNDEFINED)) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException | YarnException e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Closeable)yarnClient);
            }
        }

        public void shutdown(Launcher.ShutdownMode shutdownMode) throws Launcher.LauncherException {
            YarnAppLauncherImpl.this.shutdownApp(this, shutdownMode);
        }
    }
}

