/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client;

import org.apache.apex.shaded.ning19.com.ning.http.client.ProxyServer;
import org.apache.apex.shaded.ning19.com.ning.http.client.uri.Uri;
import org.apache.apex.shaded.ning19.com.ning.http.util.AsyncHttpProviderUtils;

public interface ConnectionPoolPartitioning {
    public Object getPartitionKey(Uri var1, ProxyServer var2);

    public static enum PerHostConnectionPoolPartitioning implements ConnectionPoolPartitioning
    {
        INSTANCE;


        @Override
        public Object getPartitionKey(Uri uri, ProxyServer proxyServer) {
            String targetHostBaseUrl = AsyncHttpProviderUtils.getBaseUrl(uri);
            return proxyServer != null ? new ProxyPartitionKey(proxyServer.getUrl(), targetHostBaseUrl) : targetHostBaseUrl;
        }
    }

    public static class ProxyPartitionKey {
        private final String proxyUrl;
        private final String targetHostBaseUrl;

        public ProxyPartitionKey(String proxyUrl, String targetHostBaseUrl) {
            this.proxyUrl = proxyUrl;
            this.targetHostBaseUrl = targetHostBaseUrl;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.proxyUrl == null ? 0 : this.proxyUrl.hashCode());
            result = 31 * result + (this.targetHostBaseUrl == null ? 0 : this.targetHostBaseUrl.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ProxyPartitionKey)) {
                return false;
            }
            ProxyPartitionKey other = (ProxyPartitionKey)obj;
            if (this.proxyUrl == null ? other.proxyUrl != null : !this.proxyUrl.equals(other.proxyUrl)) {
                return false;
            }
            return !(this.targetHostBaseUrl == null ? other.targetHostBaseUrl != null : !this.targetHostBaseUrl.equals(other.targetHostBaseUrl));
        }

        public String toString() {
            return "ProxyPartitionKey(proxyUrl=" + this.proxyUrl + ", targetHostBaseUrl=" + this.targetHostBaseUrl;
        }
    }
}

