/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client.cookie;

import java.util.Collection;
import org.apache.apex.shaded.ning19.com.ning.http.client.cookie.Cookie;
import org.apache.apex.shaded.ning19.com.ning.http.util.StringUtils;

public final class CookieEncoder {
    private CookieEncoder() {
    }

    public static String encode(Collection<Cookie> cookies) {
        StringBuilder sb = StringUtils.stringBuilder();
        for (Cookie cookie : cookies) {
            CookieEncoder.add(sb, cookie.getName(), cookie.getValue(), cookie.isWrap());
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    private static void add(StringBuilder sb, String name, String val, boolean wrap) {
        if (val == null) {
            val = "";
        }
        sb.append(name);
        sb.append('=');
        if (wrap) {
            sb.append('\"').append(val).append('\"');
        } else {
            sb.append(val);
        }
        sb.append(';');
        sb.append(' ');
    }
}

