/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request;

import java.nio.channels.ClosedChannelException;
import org.apache.apex.shaded.ning19.com.ning.http.client.AsyncHandler;
import org.apache.apex.shaded.ning19.com.ning.http.client.AsyncHttpClientConfig;
import org.apache.apex.shaded.ning19.com.ning.http.client.ProgressAsyncHandler;
import org.apache.apex.shaded.ning19.com.ning.http.client.Realm;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.channel.Channels;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.future.NettyResponseFuture;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.future.StackTraceInspector;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.Channel;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ChannelFuture;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ChannelFutureProgressListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressListener
implements ChannelFutureProgressListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressListener.class);
    private final AsyncHttpClientConfig config;
    private final boolean notifyHeaders;
    private final AsyncHandler<?> asyncHandler;
    private final NettyResponseFuture<?> future;

    public ProgressListener(AsyncHttpClientConfig config, AsyncHandler<?> asyncHandler, NettyResponseFuture<?> future, boolean notifyHeaders) {
        this.config = config;
        this.asyncHandler = asyncHandler;
        this.future = future;
        this.notifyHeaders = notifyHeaders;
    }

    private boolean abortOnThrowable(Throwable cause, Channel channel) {
        if (cause != null && this.future.getState() != NettyResponseFuture.STATE.NEW) {
            if (cause instanceof IllegalStateException || cause instanceof ClosedChannelException || StackTraceInspector.recoverOnReadOrWriteException(cause)) {
                LOGGER.debug(cause == null ? "" : cause.getMessage(), cause);
                Channels.silentlyCloseChannel(channel);
            } else {
                this.future.abort(cause);
            }
            return true;
        }
        return false;
    }

    @Override
    public void operationComplete(ChannelFuture cf) {
        if (!this.abortOnThrowable(cf.getCause(), cf.getChannel())) {
            boolean startPublishing;
            this.future.touch();
            Realm realm = this.future.getRequest().getRealm() != null ? this.future.getRequest().getRealm() : this.config.getRealm();
            boolean bl = startPublishing = this.future.isInAuth() || realm == null || realm.getUsePreemptiveAuth();
            if (startPublishing && this.asyncHandler instanceof ProgressAsyncHandler) {
                if (this.notifyHeaders) {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeaderWriteCompleted();
                } else {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteCompleted();
                }
            }
        }
    }

    @Override
    public void operationProgressed(ChannelFuture cf, long amount, long current, long total) {
        this.future.touch();
        if (this.asyncHandler instanceof ProgressAsyncHandler) {
            ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteProgress(amount, current, total);
        }
    }
}

