/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client.spnego;

import java.io.IOException;
import org.apache.apex.shaded.ning19.com.ning.http.client.spnego.SpnegoTokenGenerator;
import org.apache.apex.shaded.ning19.com.ning.http.util.Base64;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpnegoEngine {
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SpnegoTokenGenerator spnegoGenerator;
    public static final SpnegoEngine INSTANCE = new SpnegoEngine();

    public SpnegoEngine(SpnegoTokenGenerator spnegoGenerator) {
        this.spnegoGenerator = spnegoGenerator;
    }

    public SpnegoEngine() {
        this(null);
    }

    public String generateToken(String server) throws Throwable {
        try {
            GSSName serverName;
            GSSManager manager;
            this.log.debug("init {}", (Object)server);
            GSSContext gssContext = null;
            byte[] token = null;
            Oid negotiationOid = null;
            negotiationOid = new Oid(SPNEGO_OID);
            boolean tryKerberos = false;
            try {
                manager = GSSManager.getInstance();
                serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
                gssContext = manager.createContext(serverName.canonicalize(negotiationOid), negotiationOid, null, 0);
                gssContext.requestMutualAuth(true);
                gssContext.requestCredDeleg(true);
            }
            catch (GSSException ex) {
                this.log.error("generateToken", (Throwable)ex);
                if (ex.getMajor() == 2) {
                    this.log.debug("GSSException BAD_MECH, retry with Kerberos MECH");
                    tryKerberos = true;
                }
                throw ex;
            }
            if (tryKerberos) {
                this.log.debug("Using Kerberos MECH {}", (Object)KERBEROS_OID);
                negotiationOid = new Oid(KERBEROS_OID);
                manager = GSSManager.getInstance();
                serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
                gssContext = manager.createContext(serverName.canonicalize(negotiationOid), negotiationOid, null, 0);
                gssContext.requestMutualAuth(true);
                gssContext.requestCredDeleg(true);
            }
            if (token == null) {
                token = new byte[]{};
            }
            if ((token = gssContext.initSecContext(token, 0, token.length)) == null) {
                throw new Exception("GSS security context initialization failed");
            }
            if (this.spnegoGenerator != null && negotiationOid.toString().equals(KERBEROS_OID)) {
                token = this.spnegoGenerator.generateSpnegoDERObject(token);
            }
            gssContext.dispose();
            String tokenstr = new String(Base64.encode(token));
            this.log.debug("Sending response '{}' back to the server", (Object)tokenstr);
            return tokenstr;
        }
        catch (GSSException gsse) {
            this.log.error("generateToken", (Throwable)gsse);
            if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                throw new Exception(gsse.getMessage(), gsse);
            }
            if (gsse.getMajor() == 13) {
                throw new Exception(gsse.getMessage(), gsse);
            }
            if (gsse.getMajor() == 10 || gsse.getMajor() == 19 || gsse.getMajor() == 20) {
                throw new Exception(gsse.getMessage(), gsse);
            }
            throw new Exception(gsse.getMessage());
        }
        catch (IOException ex) {
            throw new Exception(ex.getMessage());
        }
    }
}

