/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.org.jboss.netty.channel.socket.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.SocketAddress;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.apex.shaded.ning19.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.apex.shaded.ning19.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.Channel;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ChannelFactory;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ChannelFuture;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ChannelPipeline;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.Channels;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ExceptionEvent;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.MessageEvent;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.local.DefaultLocalClientChannelFactory;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.local.LocalAddress;
import org.apache.apex.shaded.ning19.org.jboss.netty.logging.InternalLogger;
import org.apache.apex.shaded.ning19.org.jboss.netty.logging.InternalLoggerFactory;

public class HttpTunnelingServlet
extends HttpServlet {
    private static final long serialVersionUID = 4259910275899756070L;
    private static final String ENDPOINT = "endpoint";
    private static final String CONNECT_ATTEMPTS = "connectAttempts";
    private static final String RETRY_DELAY = "retryDelay";
    static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpTunnelingServlet.class);
    private volatile SocketAddress remoteAddress;
    private volatile ChannelFactory channelFactory;
    private volatile long connectAttempts = 1L;
    private volatile long retryDelay;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        String endpoint = config.getInitParameter(ENDPOINT);
        if (endpoint == null) {
            throw new ServletException("init-param 'endpoint' must be specified.");
        }
        try {
            this.remoteAddress = this.parseEndpoint(endpoint.trim());
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Failed to parse an endpoint.", (Throwable)e);
        }
        try {
            this.channelFactory = this.createChannelFactory(this.remoteAddress);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Failed to create a channel factory.", (Throwable)e);
        }
        String temp = config.getInitParameter(CONNECT_ATTEMPTS);
        if (temp != null) {
            try {
                this.connectAttempts = Long.parseLong(temp);
            }
            catch (NumberFormatException e) {
                throw new ServletException("init-param 'connectAttempts' is not a valid number. Actual value: " + temp);
            }
            if (this.connectAttempts < 1L) {
                throw new ServletException("init-param 'connectAttempts' must be >= 1. Actual value: " + this.connectAttempts);
            }
        }
        if ((temp = config.getInitParameter(RETRY_DELAY)) != null) {
            try {
                this.retryDelay = Long.parseLong(temp);
            }
            catch (NumberFormatException e) {
                throw new ServletException("init-param 'retryDelay' is not a valid number. Actual value: " + temp);
            }
            if (this.retryDelay < 0L) {
                throw new ServletException("init-param 'retryDelay' must be >= 0. Actual value: " + this.retryDelay);
            }
        }
    }

    protected SocketAddress parseEndpoint(String endpoint) throws Exception {
        if (endpoint.startsWith("local:")) {
            return new LocalAddress(endpoint.substring(6).trim());
        }
        throw new ServletException("Invalid or unknown endpoint: " + endpoint);
    }

    protected ChannelFactory createChannelFactory(SocketAddress remoteAddress) throws Exception {
        if (remoteAddress instanceof LocalAddress) {
            return new DefaultLocalClientChannelFactory();
        }
        throw new ServletException("Unsupported remote address type: " + remoteAddress.getClass().getName());
    }

    public void destroy() {
        block2: {
            try {
                this.destroyChannelFactory(this.channelFactory);
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to destroy a channel factory.", e);
            }
        }
    }

    protected void destroyChannelFactory(ChannelFactory factory) throws Exception {
        factory.releaseExternalResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ChannelFuture lastWriteFuture;
        block13: {
            if (!"POST".equalsIgnoreCase(req.getMethod())) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Unallowed method: " + req.getMethod());
                }
                res.sendError(405);
                return;
            }
            ChannelPipeline pipeline = Channels.pipeline();
            ServletOutputStream out = res.getOutputStream();
            OutboundConnectionHandler handler = new OutboundConnectionHandler(out);
            pipeline.addLast("handler", handler);
            Channel channel = this.channelFactory.newChannel(pipeline);
            int tries = 0;
            ChannelFuture future = null;
            while ((long)tries < this.connectAttempts && !(future = channel.connect(this.remoteAddress).awaitUninterruptibly()).isSuccess()) {
                ++tries;
                try {
                    Thread.sleep(this.retryDelay);
                }
                catch (InterruptedException e) {}
            }
            if (!future.isSuccess()) {
                if (logger.isWarnEnabled()) {
                    Throwable cause = future.getCause();
                    logger.warn("Endpoint unavailable: " + cause.getMessage(), cause);
                }
                res.sendError(503);
                return;
            }
            lastWriteFuture = null;
            try {
                res.setStatus(200);
                res.setHeader("Content-Type", "application/octet-stream");
                res.setHeader("Content-Transfer-Encoding", "binary");
                out.flush();
                PushbackInputStream in = new PushbackInputStream((InputStream)req.getInputStream());
                while (channel.isConnected()) {
                    ChannelBuffer buffer;
                    try {
                        buffer = HttpTunnelingServlet.read(in);
                    }
                    catch (EOFException e) {
                        break;
                    }
                    if (buffer == null) break;
                    lastWriteFuture = channel.write(buffer);
                }
                Object var14_15 = null;
                if (lastWriteFuture != null) break block13;
                channel.close();
                return;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (lastWriteFuture == null) {
                    channel.close();
                    throw throwable;
                }
                lastWriteFuture.addListener(ChannelFutureListener.CLOSE);
                throw throwable;
            }
        }
        lastWriteFuture.addListener(ChannelFutureListener.CLOSE);
    }

    private static ChannelBuffer read(PushbackInputStream in) throws IOException {
        int readBytes;
        byte[] buf;
        int bytesToRead = in.available();
        if (bytesToRead > 0) {
            buf = new byte[bytesToRead];
            readBytes = in.read(buf);
        } else if (bytesToRead == 0) {
            int b = in.read();
            if (b < 0 || in.available() < 0) {
                return null;
            }
            in.unread(b);
            bytesToRead = in.available();
            buf = new byte[bytesToRead];
            readBytes = in.read(buf);
        } else {
            return null;
        }
        assert (readBytes > 0);
        ChannelBuffer buffer = readBytes == buf.length ? ChannelBuffers.wrappedBuffer(buf) : ChannelBuffers.wrappedBuffer(buf, 0, readBytes);
        return buffer;
    }

    private static final class OutboundConnectionHandler
    extends SimpleChannelUpstreamHandler {
        private final ServletOutputStream out;

        public OutboundConnectionHandler(ServletOutputStream out) {
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
            OutboundConnectionHandler outboundConnectionHandler = this;
            synchronized (outboundConnectionHandler) {
                buffer.readBytes((OutputStream)this.out, buffer.readableBytes());
                this.out.flush();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception while HTTP tunneling", e.getCause());
            }
            e.getChannel().close();
        }
    }
}

