/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.algo;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.lib.util.BaseKeyValueOperator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@OperatorAnnotation(partitionable=true)
public class InvertIndex<K, V>
extends BaseKeyValueOperator<K, V>
implements Operator.Unifier<HashMap<V, ArrayList<K>>> {
    protected HashMap<V, ArrayList<K>> map = new HashMap();
    public final transient DefaultInputPort<HashMap<K, V>> data = new DefaultInputPort<HashMap<K, V>>(){

        public void process(HashMap<K, V> tuple) {
            for (Map.Entry e : tuple.entrySet()) {
                if (e.getValue() == null) continue;
                InvertIndex.this.insert(e.getValue(), InvertIndex.this.cloneKey(e.getKey()));
            }
        }
    };
    public final transient DefaultOutputPort<HashMap<V, ArrayList<K>>> index = new DefaultOutputPort<HashMap<V, ArrayList<K>>>(){

        public Operator.Unifier<HashMap<V, ArrayList<K>>> getUnifier() {
            return new InvertIndex();
        }
    };

    void insert(V val, K key) {
        ArrayList<Object> list = this.map.get(val);
        if (list == null) {
            list = new ArrayList(4);
            this.map.put((ArrayList<K>)this.cloneValue(val), (ArrayList<V>)list);
        }
        list.add(key);
    }

    public void endWindow() {
        for (Map.Entry<V, ArrayList<K>> e : this.map.entrySet()) {
            HashMap<V, ArrayList<K>> tuple = new HashMap<V, ArrayList<K>>(1);
            tuple.put(e.getKey(), e.getValue());
            this.index.emit(tuple);
        }
        this.map.clear();
    }

    public void process(HashMap<V, ArrayList<K>> tuple) {
        for (Map.Entry<V, ArrayList<K>> e : tuple.entrySet()) {
            ArrayList<Object> keys = this.map.containsKey(e.getKey()) ? this.map.remove(e.getKey()) : new ArrayList();
            keys.addAll(e.getValue());
        }
    }
}

