/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.algo;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.OperatorAnnotation;
import java.util.ArrayList;

@OperatorAnnotation(partitionable=true)
public abstract class MergeSort<K>
implements Operator,
Operator.Unifier<ArrayList<K>> {
    private ArrayList<K> mergedList = null;
    public final transient DefaultInputPort<ArrayList<K>> data = new DefaultInputPort<ArrayList<K>>(){

        public void process(ArrayList<K> tuple) {
            MergeSort.this.mergedList = MergeSort.this.processMergeList(MergeSort.this.mergedList, tuple);
        }
    };
    public final transient DefaultOutputPort<ArrayList<K>> sort = new DefaultOutputPort<ArrayList<K>>(){

        public Operator.Unifier<ArrayList<K>> getUnifier() {
            return MergeSort.this.getUnifierInstance();
        }
    };

    public void setup(Context.OperatorContext context) {
    }

    public void teardown() {
    }

    public void beginWindow(long windowId) {
        this.mergedList = null;
    }

    public void endWindow() {
        this.sort.emit(this.mergedList);
        this.mergedList = null;
    }

    protected ArrayList<K> processMergeList(ArrayList<K> list1, ArrayList<K> list2) {
        if (list1 == null) {
            return list2;
        }
        if (list2 == null) {
            return list1;
        }
        ArrayList<K> result = new ArrayList<K>();
        int index1 = 0;
        int index2 = 0;
        while (true) {
            if (index1 == list1.size()) {
                while (index2 < list2.size()) {
                    result.add(list2.get(index2++));
                }
                break;
            }
            if (index2 == list2.size()) {
                while (index1 < list1.size()) {
                    result.add(list1.get(index1++));
                }
                break;
            }
            K val1 = list1.get(index1++);
            K val2 = list2.get(index2++);
            K[] vals = this.compare(val1, val2);
            result.add(vals[0]);
            if (vals[1] == null) continue;
            result.add(vals[1]);
        }
        return result;
    }

    public void process(ArrayList<K> tuple) {
        this.mergedList = this.processMergeList(this.mergedList, tuple);
    }

    public abstract K[] compare(K var1, K var2);

    public abstract Operator.Unifier<ArrayList<K>> getUnifierInstance();
}

