/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Sink;
import com.datatorrent.lib.io.SimpleSinglePortInputOperator;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StoreUtils.class);

    public static <T> void attachOutputPortToInputPort(DefaultOutputPort<T> outputPort, final DefaultInputPort<T> inputPort) {
        outputPort.setSink((Sink)new Sink<Object>(){

            public void put(Object tuple) {
                LOG.debug("processing tuple");
                inputPort.process(tuple);
            }

            public int getCount(boolean reset) {
                return 0;
            }
        });
    }

    public static class BufferingOutputPortFlusher<TUPLE_TYPE>
    implements Runnable {
        private final SimpleSinglePortInputOperator.BufferingOutputPort<TUPLE_TYPE> port;

        public BufferingOutputPortFlusher(SimpleSinglePortInputOperator.BufferingOutputPort<TUPLE_TYPE> port) {
            this.port = (SimpleSinglePortInputOperator.BufferingOutputPort)((Object)Preconditions.checkNotNull(port));
        }

        @Override
        public void run() {
            this.port.flush(Integer.MAX_VALUE);
        }
    }
}

