/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.datastructs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CacheLRUSynchronousFlush<KEY, VALUE> {
    public static final int DEFAULT_FLUSHED_SIZE = 50000;
    private Map<KEY, VALUE> keyToValue = Maps.newHashMap();
    private Long2ObjectSortedMap<Set<KEY>> timeStampToKey = new Long2ObjectAVLTreeMap();
    private Map<KEY, Long> keyToTimeStamp = new HashMap<KEY, Long>();
    private Set<KEY> changed = Sets.newHashSet();
    private int flushedSize = 50000;
    private CacheFlushListener<KEY, VALUE> flushListener;

    public CacheLRUSynchronousFlush(CacheFlushListener<KEY, VALUE> flushListener) {
        this.setFlushListener(flushListener);
    }

    public CacheLRUSynchronousFlush(int flushedSize, CacheFlushListener<KEY, VALUE> flushListener) {
        this.setFlushedSizePri(flushedSize);
        this.setFlushListener(flushListener);
    }

    private void setFlushListener(CacheFlushListener<KEY, VALUE> flushListener) {
        Preconditions.checkNotNull(flushListener);
        this.flushListener = flushListener;
    }

    public int getFlushedSize() {
        return this.flushedSize;
    }

    public void setFlushedSize(int flushedSize) {
        this.setFlushedSizePri(flushedSize);
    }

    private void setFlushedSizePri(int flushedSize) {
        Preconditions.checkArgument((flushedSize > 0 ? 1 : 0) != 0, (Object)"The flushedSize must be positive.");
        this.flushedSize = flushedSize;
    }

    public VALUE put(KEY key, VALUE value) {
        long timeStamp = System.currentTimeMillis();
        return this.put(timeStamp, key, value);
    }

    public VALUE put(long timeStamp, KEY key, VALUE value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        this.changed.add(key);
        Long oldTimeStamp = this.keyToTimeStamp.put(key, timeStamp);
        if (oldTimeStamp == null || oldTimeStamp != timeStamp) {
            Set keys = (Set)this.timeStampToKey.get(timeStamp);
            if (keys == null) {
                keys = Sets.newHashSet();
                this.timeStampToKey.put(timeStamp, (Object)keys);
            }
            keys.add(key);
        }
        if (oldTimeStamp != null) {
            ((Set)this.timeStampToKey.get((Object)oldTimeStamp)).remove(key);
        }
        return this.keyToValue.put(key, value);
    }

    public VALUE get(KEY key) {
        Preconditions.checkNotNull(key);
        return this.keyToValue.get(key);
    }

    public VALUE remove(KEY key) {
        Preconditions.checkNotNull(key);
        Long timeStamp = this.keyToTimeStamp.get(key);
        if (timeStamp != null) {
            this.keyToTimeStamp.remove(key);
            Set keys = (Set)this.timeStampToKey.get((Object)timeStamp);
            keys.remove(key);
        }
        this.changed.remove(key);
        return this.keyToValue.remove(key);
    }

    public void removeExcess() {
        int currentSize = this.keyToValue.size();
        while (currentSize > this.flushedSize) {
            long firstKey = this.timeStampToKey.firstLongKey();
            Set keys = (Set)this.timeStampToKey.get(firstKey);
            Iterator keyIterator = keys.iterator();
            while (keyIterator.hasNext() && currentSize > this.flushedSize) {
                Object key = keyIterator.next();
                VALUE value = this.keyToValue.remove(key);
                if (value == null) continue;
                --currentSize;
                this.changed.remove(key);
                this.keyToTimeStamp.remove(key);
                this.flushListener.flush(key, value);
            }
            if (!keys.isEmpty()) continue;
            this.timeStampToKey.remove(firstKey);
        }
    }

    public void flushChanges() {
        for (KEY key : this.changed) {
            VALUE value = this.keyToValue.get(key);
            this.flushListener.flush(key, value);
        }
        this.changed.clear();
    }

    public void removeExcessAndFlushChanges() {
        this.removeExcess();
        this.flushChanges();
    }

    public static interface CacheFlushListener<KEY, VALUE> {
        public void flush(KEY var1, VALUE var2);
    }
}

