/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.datastructs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionalTable<DATA> {
    private static final Logger logger = LoggerFactory.getLogger(DimensionalTable.class);
    protected final Map<String, Integer> dimensionNameToIndex = Maps.newHashMap();
    protected final List<DATA> dataColumn = Lists.newArrayList();
    protected final List<List<Object>> dimensionColumns = Lists.newArrayList();
    protected final Map<List<Object>, DATA> dimensionKeysToData = Maps.newHashMap();

    private DimensionalTable() {
    }

    public DimensionalTable(List<String> headerNames) {
        this.setHeaderNames(headerNames);
        this.initialize();
    }

    private void initialize() {
        for (int columnIndex = 0; columnIndex < this.dimensionNameToIndex.size(); ++columnIndex) {
            this.dimensionColumns.add(Lists.newArrayList());
        }
    }

    private void setHeaderNames(List<String> headerNames) {
        Preconditions.checkNotNull(headerNames);
        Preconditions.checkArgument((!headerNames.isEmpty() ? 1 : 0) != 0, (Object)"headerNames");
        for (String headerName : headerNames) {
            Preconditions.checkNotNull((Object)headerName);
        }
        HashSet headerNameSet = Sets.newHashSet(headerNames);
        Preconditions.checkArgument((headerNameSet.size() == headerNames.size() ? 1 : 0) != 0, (Object)("The provided list of header names has duplicate names: " + headerNames));
        for (int index = 0; index < headerNames.size(); ++index) {
            this.dimensionNameToIndex.put(headerNames.get(index), index);
        }
    }

    public void appendRow(DATA data, Object ... keys) {
        Preconditions.checkNotNull(data);
        Preconditions.checkNotNull((Object)keys);
        Preconditions.checkArgument((keys.length == this.dimensionNameToIndex.size() ? 1 : 0) != 0, (Object)"All the dimension keys should be specified.");
        ArrayList keysList = Lists.newArrayList();
        for (Object key : keys) {
            keysList.add(key);
        }
        DATA prev = this.dimensionKeysToData.put(keysList, data);
        if (prev != null) {
            return;
        }
        this.dataColumn.add(data);
        for (int index = 0; index < keys.length; ++index) {
            Object key = keys[index];
            this.dimensionColumns.get(index).add(key);
        }
    }

    public void appendRow(DATA data, Map<String, ?> keys) {
        Preconditions.checkNotNull(data);
        Preconditions.checkNotNull(keys);
        Object[] keysArray = new Object[keys.size()];
        for (Map.Entry<String, ?> entry : keys.entrySet()) {
            String keyName = entry.getKey();
            Object value = entry.getValue();
            Preconditions.checkNotNull((Object)keyName);
            Integer index = this.dimensionNameToIndex.get(keyName);
            keysArray[index.intValue()] = value;
        }
        this.appendRow(data, keysArray);
    }

    public DATA getDataPoint(List<?> keys) {
        Preconditions.checkNotNull(keys);
        Preconditions.checkArgument((keys.size() == this.dimensionNameToIndex.size() ? 1 : 0) != 0, (Object)"All the keys must be specified.");
        return this.dimensionKeysToData.get(keys);
    }

    public DATA getDataPoint(Map<String, ?> keys) {
        Preconditions.checkNotNull(keys);
        Preconditions.checkArgument((keys.size() == this.dimensionNameToIndex.size() ? 1 : 0) != 0, (Object)"All the keys must be specified.");
        ArrayList keysList = Lists.newArrayList();
        for (int index = 0; index < this.dimensionNameToIndex.size(); ++index) {
            keysList.add(null);
        }
        for (Map.Entry<String, ?> entry : keys.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Integer index = this.dimensionNameToIndex.get(key);
            keysList.set(index, value);
        }
        return this.getDataPoint(keysList);
    }

    public List<DATA> getDataPoints(Map<String, ?> keys) {
        Preconditions.checkNotNull(keys);
        Preconditions.checkArgument((boolean)this.dimensionNameToIndex.keySet().containsAll(keys.keySet()), (Object)"The given keys contain names which are not valid keys.");
        ArrayList indices = Lists.newArrayList();
        ArrayList keyColumns = Lists.newArrayList();
        HashMap indexToKey = Maps.newHashMap();
        for (Map.Entry<String, ?> entry : keys.entrySet()) {
            String dimensionName = entry.getKey();
            Object value = entry.getValue();
            Integer index = this.dimensionNameToIndex.get(dimensionName);
            indices.add(index);
            indexToKey.put(index, value);
        }
        Collections.sort(indices);
        ArrayList tempKeys = Lists.newArrayList();
        for (Integer index : indices) {
            tempKeys.add(indexToKey.get(index));
            keyColumns.add(this.dimensionColumns.get(index));
        }
        int numRows = ((List)keyColumns.get(0)).size();
        ArrayList results = Lists.newArrayList();
        for (int rowIndex = 0; rowIndex < numRows; ++rowIndex) {
            boolean allEqual = true;
            for (int columnIndex = 0; columnIndex < tempKeys.size(); ++columnIndex) {
                Object key = tempKeys.get(columnIndex);
                Object keyColumn = ((List)keyColumns.get(columnIndex)).get(rowIndex);
                if (!(key == null && keyColumn != null || key != null && keyColumn == null) && (key == null || keyColumn.equals(key))) continue;
                allEqual = false;
                break;
            }
            if (!allEqual) continue;
            results.add(this.dataColumn.get(rowIndex));
        }
        return results;
    }

    public List<DATA> getAllDataPoints() {
        return Lists.newArrayList(this.dataColumn);
    }

    public int size() {
        return this.dataColumn.size();
    }
}

