/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.gpo;

import com.datatorrent.lib.appdata.schemas.Fields;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;

public class GPOMutable
implements Serializable {
    private static final long serialVersionUID = 201503231207L;
    private boolean[] fieldsBoolean;
    private char[] fieldsCharacter;
    private byte[] fieldsByte;
    private short[] fieldsShort;
    private int[] fieldsInteger;
    private long[] fieldsLong;
    private float[] fieldsFloat;
    private double[] fieldsDouble;
    private String[] fieldsString;
    private Object[] fieldsObject;
    private transient FieldsDescriptor fieldDescriptor;

    private GPOMutable() {
    }

    public GPOMutable(GPOMutable gpo) {
        this(gpo.getFieldDescriptor());
        Object[] oldFieldsObject;
        String[] oldFieldsString;
        double[] oldFieldsDouble;
        float[] oldFieldsFloat;
        long[] oldFieldsLong;
        int[] oldFieldsInteger;
        short[] oldFieldsShort;
        byte[] oldFieldsByte;
        char[] oldFieldsChar;
        this.initialize();
        boolean[] oldFieldsBoolean = gpo.getFieldsBoolean();
        if (oldFieldsBoolean != null) {
            System.arraycopy(oldFieldsBoolean, 0, this.fieldsBoolean, 0, this.fieldsBoolean.length);
        }
        if ((oldFieldsChar = gpo.getFieldsCharacter()) != null) {
            System.arraycopy(oldFieldsChar, 0, this.fieldsCharacter, 0, this.fieldsCharacter.length);
        }
        if ((oldFieldsByte = gpo.getFieldsByte()) != null) {
            System.arraycopy(oldFieldsByte, 0, this.fieldsByte, 0, this.fieldsByte.length);
        }
        if ((oldFieldsShort = gpo.getFieldsShort()) != null) {
            System.arraycopy(oldFieldsShort, 0, this.fieldsShort, 0, this.fieldsShort.length);
        }
        if ((oldFieldsInteger = gpo.getFieldsInteger()) != null) {
            System.arraycopy(oldFieldsInteger, 0, this.fieldsInteger, 0, this.fieldsInteger.length);
        }
        if ((oldFieldsLong = gpo.getFieldsLong()) != null) {
            System.arraycopy(oldFieldsLong, 0, this.fieldsLong, 0, this.fieldsLong.length);
        }
        if ((oldFieldsFloat = gpo.getFieldsFloat()) != null) {
            System.arraycopy(oldFieldsFloat, 0, this.fieldsFloat, 0, this.fieldsFloat.length);
        }
        if ((oldFieldsDouble = gpo.getFieldsDouble()) != null) {
            System.arraycopy(oldFieldsDouble, 0, this.fieldsDouble, 0, this.fieldsDouble.length);
        }
        if ((oldFieldsString = gpo.getFieldsString()) != null) {
            System.arraycopy(oldFieldsString, 0, this.fieldsString, 0, this.fieldsString.length);
        }
        if ((oldFieldsObject = gpo.getFieldsObject()) != null) {
            System.arraycopy(oldFieldsObject, 0, this.fieldsObject, 0, this.fieldsObject.length);
        }
    }

    public GPOMutable(GPOMutable gpo, Fields subsetFields) {
        this(gpo.getFieldDescriptor().getSubset(subsetFields));
        this.initialize();
        for (String field : this.getFieldDescriptor().getFields().getFields()) {
            this.setFieldGeneric(field, gpo.getField(field));
        }
    }

    public GPOMutable(FieldsDescriptor fieldDescriptor) {
        this.setFieldDescriptor(fieldDescriptor);
        this.initialize();
    }

    private void initialize() {
        block12: for (Type type : this.fieldDescriptor.getTypeToFields().keySet()) {
            int size = this.fieldDescriptor.getTypeToSize().get((Object)type);
            switch (type) {
                case BOOLEAN: {
                    this.fieldsBoolean = new boolean[size];
                    continue block12;
                }
                case CHAR: {
                    this.fieldsCharacter = new char[size];
                    continue block12;
                }
                case STRING: {
                    this.fieldsString = new String[size];
                    continue block12;
                }
                case BYTE: {
                    this.fieldsByte = new byte[size];
                    continue block12;
                }
                case SHORT: {
                    this.fieldsShort = new short[size];
                    continue block12;
                }
                case INTEGER: {
                    this.fieldsInteger = new int[size];
                    continue block12;
                }
                case LONG: {
                    this.fieldsLong = new long[size];
                    continue block12;
                }
                case FLOAT: {
                    this.fieldsFloat = new float[size];
                    continue block12;
                }
                case DOUBLE: {
                    this.fieldsDouble = new double[size];
                    continue block12;
                }
                case OBJECT: {
                    this.fieldsObject = new Object[size];
                    continue block12;
                }
            }
            throw new UnsupportedOperationException("The type " + type + " is not supported.");
        }
    }

    public boolean[] getFieldsBoolean() {
        return this.fieldsBoolean;
    }

    public char[] getFieldsCharacter() {
        return this.fieldsCharacter;
    }

    public byte[] getFieldsByte() {
        return this.fieldsByte;
    }

    public short[] getFieldsShort() {
        return this.fieldsShort;
    }

    public int[] getFieldsInteger() {
        return this.fieldsInteger;
    }

    public long[] getFieldsLong() {
        return this.fieldsLong;
    }

    public float[] getFieldsFloat() {
        return this.fieldsFloat;
    }

    public double[] getFieldsDouble() {
        return this.fieldsDouble;
    }

    public String[] getFieldsString() {
        return this.fieldsString;
    }

    public Object[] getFieldsObject() {
        return this.fieldsObject;
    }

    public final void setFieldDescriptor(FieldsDescriptor fieldDescriptor) {
        this.fieldDescriptor = (FieldsDescriptor)Preconditions.checkNotNull((Object)fieldDescriptor);
    }

    public final FieldsDescriptor getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    public final void setFieldGeneric(String field, Object val) {
        Type type = this.fieldDescriptor.getType(field);
        if (type == null) {
            throw new IllegalArgumentException(field + " is not a valid field of this object.");
        }
        int index = this.fieldDescriptor.getTypeToFieldToIndex().get(type).get((Object)field);
        switch (type) {
            case BOOLEAN: {
                this.fieldsBoolean[index] = (Boolean)val;
                break;
            }
            case CHAR: {
                this.fieldsCharacter[index] = ((Character)val).charValue();
                break;
            }
            case STRING: {
                this.fieldsString[index] = (String)val;
                break;
            }
            case BYTE: {
                this.fieldsByte[index] = (Byte)val;
                break;
            }
            case SHORT: {
                this.fieldsShort[index] = (Short)val;
                break;
            }
            case INTEGER: {
                this.fieldsInteger[index] = (Integer)val;
                break;
            }
            case LONG: {
                this.fieldsLong[index] = (Long)val;
                break;
            }
            case FLOAT: {
                this.fieldsFloat[index] = ((Float)val).floatValue();
                break;
            }
            case DOUBLE: {
                this.fieldsDouble[index] = (Double)val;
                break;
            }
            case OBJECT: {
                this.fieldsObject[index] = val;
                break;
            }
            default: {
                throw new UnsupportedOperationException("The type " + type + " is not supported.");
            }
        }
    }

    public Object getField(String field) {
        Type type = this.fieldDescriptor.getType(field);
        if (type == null) {
            throw new IllegalArgumentException(field + " is not a valid field of this object.");
        }
        int index = this.fieldDescriptor.getTypeToFieldToIndex().get(type).get((Object)field);
        switch (type) {
            case BOOLEAN: {
                return this.fieldsBoolean[index];
            }
            case CHAR: {
                return Character.valueOf(this.fieldsCharacter[index]);
            }
            case STRING: {
                return this.fieldsString[index];
            }
            case BYTE: {
                return this.fieldsByte[index];
            }
            case SHORT: {
                return this.fieldsShort[index];
            }
            case INTEGER: {
                return this.fieldsInteger[index];
            }
            case LONG: {
                return this.fieldsLong[index];
            }
            case FLOAT: {
                return Float.valueOf(this.fieldsFloat[index]);
            }
            case DOUBLE: {
                return this.fieldsDouble[index];
            }
        }
        throw new UnsupportedOperationException("The type " + type + " is not supported.");
    }

    public void setField(String field, boolean val) {
        this.throwInvalidField(field, Type.BOOLEAN);
        this.fieldsBoolean[this.fieldDescriptor.getTypeToFieldToIndex().get((Object)Type.BOOLEAN).get((Object)field).intValue()] = val;
    }

    public boolean getFieldBool(String field) {
        this.throwInvalidField(field, Type.BOOLEAN);
        return this.fieldsBoolean[this.fieldDescriptor.getTypeToFieldToIndex().get(Type.BOOLEAN).get((Object)field)];
    }

    public void setFieldObject(String field, Object val) {
        this.throwInvalidField(field, Type.OBJECT);
        this.fieldsObject[this.fieldDescriptor.getTypeToFieldToIndex().get((Object)Type.OBJECT).get((Object)field).intValue()] = val;
    }

    public Object getFieldObject(String field) {
        this.throwInvalidField(field, Type.OBJECT);
        return this.fieldsObject[this.fieldDescriptor.getTypeToFieldToIndex().get(Type.OBJECT).get((Object)field)];
    }

    public void setField(String field, char val) {
        this.throwInvalidField(field, Type.CHAR);
        this.fieldsCharacter[this.fieldDescriptor.getTypeToFieldToIndex().get((Object)Type.CHAR).get((Object)field).intValue()] = val;
    }

    public char getFieldChar(String field) {
        this.throwInvalidField(field, Type.CHAR);
        return this.fieldsCharacter[this.fieldDescriptor.getTypeToFieldToIndex().get(Type.CHAR).get((Object)field)];
    }

    public void setField(String field, byte val) {
        this.throwInvalidField(field, Type.BYTE);
        this.fieldsByte[this.fieldDescriptor.getTypeToFieldToIndex().get((Object)Type.BYTE).get((Object)field).intValue()] = val;
    }

    public byte getFieldByte(String field) {
        this.throwInvalidField(field, Type.BYTE);
        return this.fieldsByte[this.fieldDescriptor.getTypeToFieldToIndex().get(Type.BYTE).get((Object)field)];
    }

    public void setField(String field, String val) {
        this.throwInvalidField(field, Type.STRING);
        this.fieldsString[this.fieldDescriptor.getTypeToFieldToIndex().get((Object)Type.STRING).get((Object)field).intValue()] = val;
    }

    public String getFieldString(String field) {
        this.throwInvalidField(field, Type.STRING);
        return this.fieldsString[this.fieldDescriptor.getTypeToFieldToIndex().get(Type.STRING).get((Object)field)];
    }

    public void setField(String field, short val) {
        this.throwInvalidField(field, Type.SHORT);
        this.fieldsShort[this.fieldDescriptor.getTypeToFieldToIndex().get((Object)Type.SHORT).get((Object)field).intValue()] = val;
    }

    public short getFieldShort(String field) {
        this.throwInvalidField(field, Type.SHORT);
        return this.fieldsShort[this.fieldDescriptor.getTypeToFieldToIndex().get(Type.SHORT).get((Object)field)];
    }

    public void setField(String field, int val) {
        this.throwInvalidField(field, Type.INTEGER);
        this.fieldsInteger[this.fieldDescriptor.getTypeToFieldToIndex().get((Object)Type.INTEGER).get((Object)field).intValue()] = val;
    }

    public int getFieldInt(String field) {
        this.throwInvalidField(field, Type.INTEGER);
        return this.fieldsInteger[this.fieldDescriptor.getTypeToFieldToIndex().get(Type.INTEGER).get((Object)field)];
    }

    public void setField(String field, long val) {
        this.throwInvalidField(field, Type.LONG);
        this.fieldsLong[this.fieldDescriptor.getTypeToFieldToIndex().get((Object)Type.LONG).get((Object)field).intValue()] = val;
    }

    public long getFieldLong(String field) {
        this.throwInvalidField(field, Type.LONG);
        return this.fieldsLong[this.fieldDescriptor.getTypeToFieldToIndex().get(Type.LONG).get((Object)field)];
    }

    public void setField(String field, float val) {
        this.throwInvalidField(field, Type.FLOAT);
        this.fieldsFloat[this.fieldDescriptor.getTypeToFieldToIndex().get((Object)Type.FLOAT).get((Object)field).intValue()] = val;
    }

    public float getFieldFloat(String field) {
        this.throwInvalidField(field, Type.FLOAT);
        return this.fieldsFloat[this.fieldDescriptor.getTypeToFieldToIndex().get(Type.FLOAT).get((Object)field)];
    }

    public void setField(String field, double val) {
        this.throwInvalidField(field, Type.DOUBLE);
        this.fieldsDouble[this.fieldDescriptor.getTypeToFieldToIndex().get((Object)Type.DOUBLE).get((Object)field).intValue()] = val;
    }

    public double getFieldDouble(String field) {
        this.throwInvalidField(field, Type.DOUBLE);
        return this.fieldsDouble[this.fieldDescriptor.getTypeToFieldToIndex().get(Type.DOUBLE).get((Object)field)];
    }

    private void throwInvalidField(String field, Type type) {
        Type fieldType = this.fieldDescriptor.getType(field);
        if (fieldType == null || !fieldType.equals(type)) {
            throw new IllegalArgumentException(field + " is not a valid field of type " + type + " on this object.");
        }
    }

    public void applyObjectPayloadFix() {
        if (this.fieldDescriptor.getSerdePayloadFix() != null) {
            this.fieldDescriptor.getSerdePayloadFix().fix(this.fieldsObject);
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Arrays.hashCode(this.fieldsBoolean);
        hash = 23 * hash + Arrays.hashCode(this.fieldsCharacter);
        hash = 23 * hash + Arrays.hashCode(this.fieldsByte);
        hash = 23 * hash + Arrays.hashCode(this.fieldsShort);
        hash = 23 * hash + Arrays.hashCode(this.fieldsInteger);
        hash = 23 * hash + Arrays.hashCode(this.fieldsLong);
        hash = 23 * hash + Arrays.hashCode(this.fieldsFloat);
        hash = 23 * hash + Arrays.hashCode(this.fieldsDouble);
        hash = 23 * hash + Arrays.deepHashCode(this.fieldsString);
        hash = 23 * hash + (this.fieldDescriptor != null ? this.fieldDescriptor.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GPOMutable)) {
            return false;
        }
        GPOMutable other = (GPOMutable)obj;
        if (!Arrays.equals(this.fieldsBoolean, other.fieldsBoolean)) {
            return false;
        }
        if (!Arrays.equals(this.fieldsCharacter, other.fieldsCharacter)) {
            return false;
        }
        if (!Arrays.equals(this.fieldsByte, other.fieldsByte)) {
            return false;
        }
        if (!Arrays.equals(this.fieldsShort, other.fieldsShort)) {
            return false;
        }
        if (!Arrays.equals(this.fieldsInteger, other.fieldsInteger)) {
            return false;
        }
        if (!Arrays.equals(this.fieldsLong, other.fieldsLong)) {
            return false;
        }
        if (!Arrays.equals(this.fieldsFloat, other.fieldsFloat)) {
            return false;
        }
        if (!Arrays.equals(this.fieldsDouble, other.fieldsDouble)) {
            return false;
        }
        if (!Arrays.deepEquals(this.fieldsString, other.fieldsString)) {
            return false;
        }
        if (!Arrays.deepEquals(this.fieldsObject, other.fieldsObject)) {
            return false;
        }
        return this.fieldDescriptor == other.fieldDescriptor || this.fieldDescriptor != null && this.fieldDescriptor.equals(other.fieldDescriptor);
    }

    public String toString() {
        return "GPOMutable{fieldsBoolean=" + Arrays.toString(this.fieldsBoolean) + ", fieldsCharacter=" + Arrays.toString(this.fieldsCharacter) + ", fieldsByte=" + Arrays.toString(this.fieldsByte) + ", fieldsShort=" + Arrays.toString(this.fieldsShort) + ", fieldsInteger=" + Arrays.toString(this.fieldsInteger) + ", fieldsLong=" + Arrays.toString(this.fieldsLong) + ", fieldsFloat=" + Arrays.toString(this.fieldsFloat) + ", fieldsDouble=" + Arrays.toString(this.fieldsDouble) + ", fieldsString=" + Arrays.toString(this.fieldsString) + ", fieldDescriptor=" + this.fieldDescriptor + '}';
    }
}

