/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.gpo;

import com.datatorrent.lib.appdata.gpo.GPOGetters;
import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.gpo.GPOUtils;
import com.datatorrent.lib.appdata.schemas.ResultFormatter;
import com.datatorrent.lib.appdata.schemas.Type;
import com.datatorrent.lib.util.PojoUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

abstract class GPOType {
    public static final GPOType[] GPO_TYPE_ARRAY = new GPOType[Type.values().length];

    GPOType() {
    }

    public abstract void setFieldFromJSON(GPOMutable var1, String var2, JSONArray var3, int var4);

    public abstract void serializeJSONObject(JSONObject var1, GPOMutable var2, String var3, ResultFormatter var4) throws JSONException;

    public abstract void serialize(GPOMutable var1, String var2, byte[] var3, MutableInt var4);

    public abstract void deserialize(GPOMutable var1, String var2, byte[] var3, MutableInt var4);

    public abstract void buildGPOGetters(GPOGetters var1, List<String> var2, Map<String, String> var3, Class<?> var4);

    public abstract byte[] serialize(Object var1);

    public abstract Object deserialize(byte[] var1, MutableInt var2);

    static {
        Type[] types = Type.values();
        block12: for (int index = 0; index < types.length; ++index) {
            Type type = types[index];
            switch (type) {
                case BOOLEAN: {
                    GPOType.GPO_TYPE_ARRAY[index] = new BooleanT();
                    continue block12;
                }
                case CHAR: {
                    GPOType.GPO_TYPE_ARRAY[index] = new CharT();
                    continue block12;
                }
                case STRING: {
                    GPOType.GPO_TYPE_ARRAY[index] = new StringT();
                    continue block12;
                }
                case OBJECT: {
                    GPOType.GPO_TYPE_ARRAY[index] = new ObjectT();
                    continue block12;
                }
                case BYTE: {
                    GPOType.GPO_TYPE_ARRAY[index] = new ByteT();
                    continue block12;
                }
                case SHORT: {
                    GPOType.GPO_TYPE_ARRAY[index] = new ShortT();
                    continue block12;
                }
                case INTEGER: {
                    GPOType.GPO_TYPE_ARRAY[index] = new IntegerT();
                    continue block12;
                }
                case LONG: {
                    GPOType.GPO_TYPE_ARRAY[index] = new LongT();
                    continue block12;
                }
                case FLOAT: {
                    GPOType.GPO_TYPE_ARRAY[index] = new FloatT();
                    continue block12;
                }
                case DOUBLE: {
                    GPOType.GPO_TYPE_ARRAY[index] = new DoubleT();
                    continue block12;
                }
                default: {
                    throw new UnsupportedOperationException("Type " + type);
                }
            }
        }
    }

    public static class DoubleT
    extends GPOType {
        public static final DoubleT INSTANCE = new DoubleT();

        private DoubleT() {
        }

        @Override
        public void setFieldFromJSON(GPOMutable gpo, String field, JSONArray jo, int index) {
            Double val;
            try {
                val = jo.getDouble(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid double value.", ex);
            }
            gpo.setFieldGeneric(field, val);
        }

        @Override
        public void serializeJSONObject(JSONObject jo, GPOMutable gpo, String field, ResultFormatter resultFormatter) throws JSONException {
            jo.put(field, (Object)resultFormatter.format(gpo.getFieldDouble(field)));
        }

        @Override
        public void serialize(GPOMutable gpo, String field, byte[] sbytes, MutableInt offset) {
            GPOUtils.serializeDouble(gpo.getFieldDouble(field), sbytes, offset);
        }

        @Override
        public void deserialize(GPOMutable gpo, String field, byte[] serializedGPO, MutableInt offset) {
            double val = GPOUtils.deserializeDouble(serializedGPO, offset);
            gpo.setField(field, val);
        }

        @Override
        public void buildGPOGetters(GPOGetters gpoGetters, List<String> fields, Map<String, String> fieldToGetter, Class<?> clazz) {
            gpoGetters.gettersDouble = (PojoUtils.GetterDouble[])GPOUtils.createGetters(fields, fieldToGetter, clazz, Double.TYPE, PojoUtils.GetterDouble.class);
        }

        @Override
        public byte[] serialize(Object object) {
            return GPOUtils.serializeDouble((Double)object);
        }

        @Override
        public Object deserialize(byte[] object, MutableInt offset) {
            return GPOUtils.deserializeDouble(object, offset);
        }
    }

    public static class FloatT
    extends GPOType {
        public static final FloatT INSTANCE = new FloatT();

        private FloatT() {
        }

        @Override
        public void setFieldFromJSON(GPOMutable gpo, String field, JSONArray jo, int index) {
            Float val;
            try {
                val = Float.valueOf((float)jo.getDouble(index));
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid double value.", ex);
            }
            gpo.setFieldGeneric(field, val);
        }

        @Override
        public void serializeJSONObject(JSONObject jo, GPOMutable gpo, String field, ResultFormatter resultFormatter) throws JSONException {
            jo.put(field, (Object)resultFormatter.format(gpo.getFieldFloat(field)));
        }

        @Override
        public void serialize(GPOMutable gpo, String field, byte[] sbytes, MutableInt offset) {
            GPOUtils.serializeFloat(gpo.getFieldFloat(field), sbytes, offset);
        }

        @Override
        public void deserialize(GPOMutable gpo, String field, byte[] serializedGPO, MutableInt offset) {
            float val = GPOUtils.deserializeFloat(serializedGPO, offset);
            gpo.setField(field, val);
        }

        @Override
        public void buildGPOGetters(GPOGetters gpoGetters, List<String> fields, Map<String, String> fieldToGetter, Class<?> clazz) {
            gpoGetters.gettersFloat = (PojoUtils.GetterFloat[])GPOUtils.createGetters(fields, fieldToGetter, clazz, Float.TYPE, PojoUtils.GetterFloat.class);
        }

        @Override
        public byte[] serialize(Object object) {
            return GPOUtils.serializeFloat(((Float)object).floatValue());
        }

        @Override
        public Object deserialize(byte[] object, MutableInt offset) {
            return Float.valueOf(GPOUtils.deserializeFloat(object, offset));
        }
    }

    public static class LongT
    extends GPOType {
        public static final LongT INSTANCE = new LongT();

        private LongT() {
        }

        @Override
        public void setFieldFromJSON(GPOMutable gpo, String field, JSONArray jo, int index) {
            long val;
            try {
                val = jo.getLong(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid long value.", ex);
            }
            gpo.setField(field, val);
        }

        @Override
        public void serializeJSONObject(JSONObject jo, GPOMutable gpo, String field, ResultFormatter resultFormatter) throws JSONException {
            jo.put(field, (Object)resultFormatter.format(gpo.getFieldLong(field)));
        }

        @Override
        public void serialize(GPOMutable gpo, String field, byte[] sbytes, MutableInt offset) {
            GPOUtils.serializeLong(gpo.getFieldLong(field), sbytes, offset);
        }

        @Override
        public void deserialize(GPOMutable gpo, String field, byte[] serializedGPO, MutableInt offset) {
            long val = GPOUtils.deserializeLong(serializedGPO, offset);
            gpo.setField(field, val);
        }

        @Override
        public void buildGPOGetters(GPOGetters gpoGetters, List<String> fields, Map<String, String> fieldToGetter, Class<?> clazz) {
            gpoGetters.gettersLong = (PojoUtils.GetterLong[])GPOUtils.createGetters(fields, fieldToGetter, clazz, Long.TYPE, PojoUtils.GetterLong.class);
        }

        @Override
        public byte[] serialize(Object object) {
            return GPOUtils.serializeLong((Long)object);
        }

        @Override
        public Object deserialize(byte[] object, MutableInt offset) {
            return GPOUtils.deserializeLong(object, offset);
        }
    }

    public static class IntegerT
    extends GPOType {
        public static final IntegerT INSTANCE = new IntegerT();

        private IntegerT() {
        }

        @Override
        public void setFieldFromJSON(GPOMutable gpo, String field, JSONArray jo, int index) {
            int val;
            try {
                val = jo.getInt(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid int value.", ex);
            }
            gpo.setField(field, val);
        }

        @Override
        public void serializeJSONObject(JSONObject jo, GPOMutable gpo, String field, ResultFormatter resultFormatter) throws JSONException {
            jo.put(field, (Object)resultFormatter.format(gpo.getFieldInt(field)));
        }

        @Override
        public void serialize(GPOMutable gpo, String field, byte[] sbytes, MutableInt offset) {
            GPOUtils.serializeInt(gpo.getFieldInt(field), sbytes, offset);
        }

        @Override
        public void deserialize(GPOMutable gpo, String field, byte[] serializedGPO, MutableInt offset) {
            int val = GPOUtils.deserializeInt(serializedGPO, offset);
            gpo.setField(field, val);
        }

        @Override
        public void buildGPOGetters(GPOGetters gpoGetters, List<String> fields, Map<String, String> fieldToGetter, Class<?> clazz) {
            gpoGetters.gettersInteger = (PojoUtils.GetterInt[])GPOUtils.createGetters(fields, fieldToGetter, clazz, Integer.TYPE, PojoUtils.GetterInt.class);
        }

        @Override
        public byte[] serialize(Object object) {
            return GPOUtils.serializeInt((Integer)object);
        }

        @Override
        public Object deserialize(byte[] object, MutableInt offset) {
            return GPOUtils.deserializeInt(object, offset);
        }
    }

    public static class ShortT
    extends GPOType {
        public static final ShortT INSTANCE = new ShortT();

        private ShortT() {
        }

        @Override
        public void setFieldFromJSON(GPOMutable gpo, String field, JSONArray jo, int index) {
            int val;
            try {
                val = jo.getInt(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid short value.", ex);
            }
            if (val < Short.MIN_VALUE) {
                throw new IllegalArgumentException("The key " + field + " has a value " + val + " which is too small to fit into a short.");
            }
            if (val > Short.MAX_VALUE) {
                throw new IllegalArgumentException("The key " + field + " has a value " + val + " which is too large to fit into a short.");
            }
            gpo.setField(field, (short)val);
        }

        @Override
        public void serializeJSONObject(JSONObject jo, GPOMutable gpo, String field, ResultFormatter resultFormatter) throws JSONException {
            jo.put(field, (Object)resultFormatter.format(gpo.getFieldShort(field)));
        }

        @Override
        public void serialize(GPOMutable gpo, String field, byte[] sbytes, MutableInt offset) {
            GPOUtils.serializeShort(gpo.getFieldShort(field), sbytes, offset);
        }

        @Override
        public void deserialize(GPOMutable gpo, String field, byte[] serializedGPO, MutableInt offset) {
            short val = GPOUtils.deserializeShort(serializedGPO, offset);
            gpo.setField(field, val);
        }

        @Override
        public void buildGPOGetters(GPOGetters gpoGetters, List<String> fields, Map<String, String> fieldToGetter, Class<?> clazz) {
            gpoGetters.gettersShort = (PojoUtils.GetterShort[])GPOUtils.createGetters(fields, fieldToGetter, clazz, Short.TYPE, PojoUtils.GetterShort.class);
        }

        @Override
        public byte[] serialize(Object object) {
            return GPOUtils.serializeShort((Short)object);
        }

        @Override
        public Object deserialize(byte[] object, MutableInt offset) {
            return GPOUtils.deserializeShort(object, offset);
        }
    }

    public static class ByteT
    extends GPOType {
        public static final ByteT INSTANCE = new ByteT();

        private ByteT() {
        }

        @Override
        public void setFieldFromJSON(GPOMutable gpo, String field, JSONArray jo, int index) {
            int val;
            try {
                val = jo.getInt(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid byte value.", ex);
            }
            if (val < -128) {
                throw new IllegalArgumentException("The key " + field + " has a value " + val + " which is too small to fit into a byte.");
            }
            if (val > 127) {
                throw new IllegalArgumentException("The key " + field + " has a value " + val + " which is too larg to fit into a byte.");
            }
            gpo.setField(field, (byte)val);
        }

        @Override
        public void serializeJSONObject(JSONObject jo, GPOMutable gpo, String field, ResultFormatter resultFormatter) throws JSONException {
            jo.put(field, (Object)resultFormatter.format(gpo.getFieldByte(field)));
        }

        @Override
        public void serialize(GPOMutable gpo, String field, byte[] sbytes, MutableInt offset) {
            GPOUtils.serializeByte(gpo.getFieldByte(field), sbytes, offset);
        }

        @Override
        public void deserialize(GPOMutable gpo, String field, byte[] serializedGPO, MutableInt offset) {
            byte val = GPOUtils.deserializeByte(serializedGPO, offset);
            gpo.setField(field, val);
        }

        @Override
        public void buildGPOGetters(GPOGetters gpoGetters, List<String> fields, Map<String, String> fieldToGetter, Class<?> clazz) {
            gpoGetters.gettersByte = (PojoUtils.GetterByte[])GPOUtils.createGetters(fields, fieldToGetter, clazz, Byte.TYPE, PojoUtils.GetterByte.class);
        }

        @Override
        public byte[] serialize(Object object) {
            return GPOUtils.serializeByte((Byte)object);
        }

        @Override
        public Object deserialize(byte[] object, MutableInt offset) {
            return GPOUtils.deserializeByte(object, offset);
        }
    }

    public static class ObjectT
    extends GPOType {
        public static final ObjectT INSTANCE = new ObjectT();

        private ObjectT() {
        }

        @Override
        public void setFieldFromJSON(GPOMutable gpo, String field, JSONArray jo, int index) {
            throw new UnsupportedOperationException("Type " + Type.OBJECT);
        }

        @Override
        public void serializeJSONObject(JSONObject jo, GPOMutable gpo, String field, ResultFormatter resultFormatter) throws JSONException {
            throw new UnsupportedOperationException("Type " + Type.OBJECT);
        }

        @Override
        public void serialize(GPOMutable gpo, String field, byte[] sbytes, MutableInt offset) {
            throw new UnsupportedOperationException("Type " + Type.OBJECT);
        }

        @Override
        public void deserialize(GPOMutable gpo, String Field2, byte[] serializedGPO, MutableInt offset) {
            throw new UnsupportedOperationException("Type " + Type.OBJECT);
        }

        @Override
        public void buildGPOGetters(GPOGetters gpoGetters, List<String> fields, Map<String, String> fieldToGetter, Class<?> clazz) {
            gpoGetters.gettersObject = GPOUtils.createGettersObject(fields, fieldToGetter, clazz);
        }

        @Override
        public byte[] serialize(Object object) {
            throw new UnsupportedOperationException("This operation is not supported for objects.");
        }

        @Override
        public Object deserialize(byte[] object, MutableInt offset) {
            throw new UnsupportedOperationException("This operation is not supported for objects.");
        }
    }

    public static class StringT
    extends GPOType {
        public static final StringT INSTANCE = new StringT();

        private StringT() {
        }

        @Override
        public void setFieldFromJSON(GPOMutable gpo, String field, JSONArray jo, int index) {
            String val;
            try {
                val = jo.getString(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid string value.", ex);
            }
            gpo.setField(field, val);
        }

        @Override
        public void serializeJSONObject(JSONObject jo, GPOMutable gpo, String field, ResultFormatter resultFormatter) throws JSONException {
            jo.put(field, (Object)gpo.getFieldString(field));
        }

        @Override
        public void serialize(GPOMutable gpo, String field, byte[] sbytes, MutableInt offset) {
            GPOUtils.serializeString(gpo.getFieldString(field), sbytes, offset);
        }

        @Override
        public void deserialize(GPOMutable gpo, String field, byte[] serializedGPO, MutableInt offset) {
            String val = GPOUtils.deserializeString(serializedGPO, offset);
            gpo.setField(field, val);
        }

        @Override
        public void buildGPOGetters(GPOGetters gpoGetters, List<String> fields, Map<String, String> fieldToGetter, Class<?> clazz) {
            gpoGetters.gettersString = GPOUtils.createGettersString(fields, fieldToGetter, clazz);
        }

        @Override
        public byte[] serialize(Object object) {
            return GPOUtils.serializeString((String)object);
        }

        @Override
        public Object deserialize(byte[] object, MutableInt offset) {
            return GPOUtils.deserializeString(object, offset);
        }
    }

    public static class CharT
    extends GPOType {
        public static final CharT INSTANCE = new CharT();

        private CharT() {
        }

        @Override
        public void setFieldFromJSON(GPOMutable gpo, String field, JSONArray jo, int index) {
            long val;
            try {
                val = jo.getLong(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid long value.", ex);
            }
            gpo.setField(field, val);
        }

        @Override
        public void serializeJSONObject(JSONObject jo, GPOMutable gpo, String field, ResultFormatter resultFormatter) throws JSONException {
            jo.put(field, (Object)Character.valueOf(gpo.getFieldChar(field)).toString());
        }

        @Override
        public void serialize(GPOMutable gpo, String field, byte[] sbytes, MutableInt offset) {
            GPOUtils.serializeChar(gpo.getFieldChar(field), sbytes, offset);
        }

        @Override
        public void deserialize(GPOMutable gpo, String field, byte[] serializedGPO, MutableInt offset) {
            char val = GPOUtils.deserializeChar(serializedGPO, offset);
            gpo.setField(field, val);
        }

        @Override
        public void buildGPOGetters(GPOGetters gpoGetters, List<String> fields, Map<String, String> fieldToGetter, Class<?> clazz) {
            gpoGetters.gettersChar = (PojoUtils.GetterChar[])GPOUtils.createGetters(fields, fieldToGetter, clazz, Character.TYPE, PojoUtils.GetterChar.class);
        }

        @Override
        public byte[] serialize(Object object) {
            return GPOUtils.serializeChar(((Character)object).charValue());
        }

        @Override
        public Object deserialize(byte[] object, MutableInt offset) {
            return Character.valueOf(GPOUtils.deserializeChar(object, offset));
        }
    }

    public static class BooleanT
    extends GPOType {
        public static final BooleanT INSTANCE = new BooleanT();

        private BooleanT() {
        }

        @Override
        public void setFieldFromJSON(GPOMutable gpo, String field, JSONArray jo, int index) {
            Boolean val;
            try {
                val = jo.getBoolean(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid bool value.", ex);
            }
            gpo.setFieldGeneric(field, val);
        }

        @Override
        public void serializeJSONObject(JSONObject jo, GPOMutable gpo, String field, ResultFormatter resultFormatter) throws JSONException {
            jo.put(field, gpo.getFieldBool(field));
        }

        @Override
        public void serialize(GPOMutable gpo, String field, byte[] sbytes, MutableInt offset) {
            GPOUtils.serializeBoolean(gpo.getFieldBool(field), sbytes, offset);
        }

        @Override
        public void deserialize(GPOMutable gpo, String field, byte[] serializedGPO, MutableInt offset) {
            boolean val = GPOUtils.deserializeBoolean(serializedGPO, offset);
            gpo.setField(field, val);
        }

        @Override
        public void buildGPOGetters(GPOGetters gpoGetters, List<String> fields, Map<String, String> fieldToGetter, Class<?> clazz) {
            gpoGetters.gettersBoolean = (PojoUtils.GetterBoolean[])GPOUtils.createGetters(fields, fieldToGetter, clazz, Boolean.TYPE, PojoUtils.GetterBoolean.class);
        }

        @Override
        public byte[] serialize(Object object) {
            return GPOUtils.serializeBoolean((Boolean)object);
        }

        @Override
        public Object deserialize(byte[] object, MutableInt offset) {
            return GPOUtils.deserializeBoolean(object, offset);
        }
    }
}

