/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.gpo;

import com.datatorrent.lib.appdata.gpo.GPOByteArrayList;
import com.datatorrent.lib.appdata.gpo.GPOGetters;
import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.gpo.GPOType;
import com.datatorrent.lib.appdata.gpo.Serde;
import com.datatorrent.lib.appdata.schemas.Fields;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.ResultFormatter;
import com.datatorrent.lib.appdata.schemas.Type;
import com.datatorrent.lib.util.PojoUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class GPOUtils {
    private GPOUtils() {
    }

    public static Map<String, Type> buildTypeMap(JSONObject jo) throws JSONException {
        HashMap fieldToType = Maps.newHashMap();
        Iterator keys = jo.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = jo.getString(key);
            Type type = Type.getTypeEx(val);
            fieldToType.put(key, type);
        }
        return fieldToType;
    }

    public static GPOMutable deserialize(FieldsDescriptor fieldsDescriptor, JSONObject dpou) {
        GPOMutable gpo = new GPOMutable(fieldsDescriptor);
        Iterator itr = dpou.keys();
        while (itr.hasNext()) {
            String field = (String)itr.next();
            GPOUtils.setFieldFromJSON(gpo, field, dpou);
        }
        return gpo;
    }

    public static Map<String, Set<Object>> deserializeToMap(FieldsDescriptor fieldsDescriptor, JSONObject dpou) {
        HashMap keyToValues = Maps.newHashMap();
        for (String key : fieldsDescriptor.getFields().getFields()) {
            HashSet keyValues;
            Object keyValue;
            if (!dpou.has(key)) {
                throw new IllegalArgumentException("The given key " + key + " is not contained in the given JSON");
            }
            try {
                keyValue = dpou.get(key);
            }
            catch (JSONException ex) {
                throw new IllegalStateException("This should never happen", ex);
            }
            if (keyValue instanceof JSONArray) {
                JSONArray ja = (JSONArray)keyValue;
                keyValues = Sets.newHashSetWithExpectedSize((int)ja.length());
                Type type = fieldsDescriptor.getType(key);
                for (int index = 0; index < ja.length(); ++index) {
                    keyValues.add(GPOUtils.getFieldFromJSON(type, ja, index));
                }
            } else {
                if (keyValue instanceof JSONObject) {
                    throw new UnsupportedOperationException("Cannot extract objects from JSONObjects");
                }
                keyValues = Sets.newHashSetWithExpectedSize((int)1);
                keyValues.add(GPOUtils.getFieldFromJSON(fieldsDescriptor, key, dpou));
            }
            keyToValues.put(key, keyValues);
        }
        return keyToValues;
    }

    public static void setFieldFromJSON(GPOMutable gpo, Type type, String field, JSONArray jo, int index) {
        GPOType gpoType = GPOType.GPO_TYPE_ARRAY[type.ordinal()];
        gpoType.setFieldFromJSON(gpo, field, jo, index);
    }

    public static void setFieldFromJSON(GPOMutable gpo, String field, JSONObject jo) {
        Object val = GPOUtils.getFieldFromJSON(gpo.getFieldDescriptor(), field, jo);
        gpo.setFieldGeneric(field, val);
    }

    public static Object getFieldFromJSON(FieldsDescriptor fd, String field, JSONObject jo) {
        Type type = fd.getType(field);
        int intVal = 0;
        if (GPOUtils.numericTypeIntOrSmaller(type)) {
            try {
                intVal = jo.getInt(field);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid " + type + " value.", ex);
            }
            if (type != Type.INTEGER && !GPOUtils.insideRange(type, intVal)) {
                throw new IllegalArgumentException("The key " + field + " has a value " + intVal + " which is out of range for a " + type + ".");
            }
        }
        if (type == Type.BOOLEAN) {
            try {
                return jo.getBoolean(field);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid bool value.", ex);
            }
        }
        if (type == Type.BYTE) {
            return (byte)intVal;
        }
        if (type == Type.SHORT) {
            return (short)intVal;
        }
        if (type == Type.INTEGER) {
            return intVal;
        }
        if (type == Type.LONG) {
            try {
                return jo.getLong(field);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid long value.", ex);
            }
        }
        if (type == Type.CHAR) {
            String val;
            try {
                val = jo.getString(field);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid character value.", ex);
            }
            if (val.length() != 1) {
                throw new IllegalArgumentException("The key " + field + " has a value " + val + " that is not one character long.");
            }
            return Character.valueOf(val.charAt(0));
        }
        if (type == Type.STRING) {
            try {
                return jo.getString(field);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid string value.", ex);
            }
        }
        if (type == Type.DOUBLE) {
            try {
                return jo.getDouble(field);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid double value.", ex);
            }
        }
        if (type == Type.FLOAT) {
            try {
                return Float.valueOf((float)jo.getDouble(field));
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The key " + field + " does not have a valid double value.", ex);
            }
        }
        throw new UnsupportedOperationException("The type " + type + " is not supported.");
    }

    public static Object getFieldFromJSON(Type type, JSONArray ja, int index) {
        int intVal = 0;
        if (GPOUtils.numericTypeIntOrSmaller(type)) {
            try {
                intVal = ja.getInt(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The index " + index + " does not have a valid " + type + " value.", ex);
            }
            if (type != Type.INTEGER && !GPOUtils.insideRange(type, intVal)) {
                throw new IllegalArgumentException("The index " + index + " has a value " + intVal + " which is out of range for a " + type + ".");
            }
        }
        if (type == Type.BOOLEAN) {
            try {
                return ja.getBoolean(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The index " + index + " does not have a valid bool value.", ex);
            }
        }
        if (type == Type.BYTE) {
            return (byte)intVal;
        }
        if (type == Type.SHORT) {
            return (short)intVal;
        }
        if (type == Type.INTEGER) {
            return intVal;
        }
        if (type == Type.LONG) {
            try {
                return ja.getLong(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The index " + index + " does not have a valid long value.", ex);
            }
        }
        if (type == Type.CHAR) {
            String val;
            try {
                val = ja.getString(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The index " + index + " does not have a valid character value.", ex);
            }
            if (val.length() != 1) {
                throw new IllegalArgumentException("The index " + index + " has a value " + val + " that is not one character long.");
            }
            return Character.valueOf(val.charAt(0));
        }
        if (type == Type.STRING) {
            try {
                return ja.getString(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The index " + index + " does not have a valid string value.", ex);
            }
        }
        if (type == Type.DOUBLE) {
            try {
                return ja.getDouble(index);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The index " + index + " does not have a valid double value.", ex);
            }
        }
        if (type == Type.FLOAT) {
            try {
                return Float.valueOf((float)ja.getDouble(index));
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("The index " + index + " does not have a valid double value.", ex);
            }
        }
        throw new UnsupportedOperationException("The type " + type + " is not supported.");
    }

    public static JSONObject serializeJSONObject(GPOMutable gpo, Fields fields, ResultFormatter resultFormatter) throws JSONException {
        JSONObject jo = new JSONObject();
        FieldsDescriptor fd = gpo.getFieldDescriptor();
        for (String field : fields.getFields()) {
            Type fieldType = fd.getType(field);
            GPOType gpoType = GPOType.GPO_TYPE_ARRAY[fieldType.ordinal()];
            gpoType.serializeJSONObject(jo, gpo, field, resultFormatter);
        }
        return jo;
    }

    public static JSONObject serializeJSONObject(GPOMutable gpo, ResultFormatter resultFormatter) throws JSONException {
        return GPOUtils.serializeJSONObject(gpo, gpo.getFieldDescriptor().getFields(), resultFormatter);
    }

    public static int serializedLength(GPOMutable gpo) {
        int arrayLength = 0;
        FieldsDescriptor fd = gpo.getFieldDescriptor();
        List<Type> types = fd.getTypesList();
        block4: for (int typeIndex = 0; typeIndex < types.size(); ++typeIndex) {
            Type type = types.get(typeIndex);
            switch (type) {
                case STRING: {
                    for (String val : gpo.getFieldsString()) {
                        arrayLength += Type.INTEGER.getByteSize();
                        arrayLength += val.getBytes().length;
                    }
                    continue block4;
                }
                case OBJECT: {
                    continue block4;
                }
                default: {
                    arrayLength += fd.getTypeToFields().get(type).size() * type.getByteSize();
                }
            }
        }
        return arrayLength;
    }

    public static byte[] serialize(GPOMutable gpo, GPOByteArrayList byteArrayList) {
        String[] fieldsString;
        double[] fieldsDouble;
        float[] fieldsFloat;
        long[] fieldsLong;
        int[] fieldsInteger;
        short[] fieldsShort;
        byte[] fieldsByte;
        char[] fieldsCharacter;
        int slength = GPOUtils.serializedLength(gpo);
        byte[] sbytes = new byte[slength];
        MutableInt offset = new MutableInt(0);
        boolean[] fieldsBoolean = gpo.getFieldsBoolean();
        if (fieldsBoolean != null) {
            for (int index = 0; index < fieldsBoolean.length; ++index) {
                GPOUtils.serializeBoolean(fieldsBoolean[index], sbytes, offset);
            }
        }
        if ((fieldsCharacter = gpo.getFieldsCharacter()) != null) {
            for (int index = 0; index < fieldsCharacter.length; ++index) {
                GPOUtils.serializeChar(fieldsCharacter[index], sbytes, offset);
            }
        }
        if ((fieldsByte = gpo.getFieldsByte()) != null) {
            for (int index = 0; index < fieldsByte.length; ++index) {
                GPOUtils.serializeByte(fieldsByte[index], sbytes, offset);
            }
        }
        if ((fieldsShort = gpo.getFieldsShort()) != null) {
            for (int index = 0; index < fieldsShort.length; ++index) {
                GPOUtils.serializeShort(fieldsShort[index], sbytes, offset);
            }
        }
        if ((fieldsInteger = gpo.getFieldsInteger()) != null) {
            for (int index = 0; index < fieldsInteger.length; ++index) {
                GPOUtils.serializeInt(fieldsInteger[index], sbytes, offset);
            }
        }
        if ((fieldsLong = gpo.getFieldsLong()) != null) {
            for (int index = 0; index < fieldsLong.length; ++index) {
                GPOUtils.serializeLong(fieldsLong[index], sbytes, offset);
            }
        }
        if ((fieldsFloat = gpo.getFieldsFloat()) != null) {
            for (int index = 0; index < fieldsFloat.length; ++index) {
                GPOUtils.serializeFloat(fieldsFloat[index], sbytes, offset);
            }
        }
        if ((fieldsDouble = gpo.getFieldsDouble()) != null) {
            for (int index = 0; index < fieldsDouble.length; ++index) {
                GPOUtils.serializeDouble(fieldsDouble[index], sbytes, offset);
            }
        }
        if ((fieldsString = gpo.getFieldsString()) != null) {
            for (int index = 0; index < fieldsString.length; ++index) {
                GPOUtils.serializeString(fieldsString[index], sbytes, offset);
            }
        }
        if (sbytes.length > 0) {
            byteArrayList.add(sbytes);
        }
        Object[] fieldsObject = gpo.getFieldsObject();
        Serde[] serdes = gpo.getFieldDescriptor().getSerdes();
        if (fieldsObject != null) {
            for (int index = 0; index < fieldsObject.length; ++index) {
                byteArrayList.add(serdes[index].serializeObject(fieldsObject[index]));
            }
        }
        byte[] bytes = byteArrayList.toByteArray();
        byteArrayList.clear();
        return bytes;
    }

    public static byte[] serialize(GPOMutable gpo, Fields excludedFields) {
        int slength = GPOUtils.serializedLength(gpo);
        byte[] sbytes = new byte[slength];
        MutableInt offset = new MutableInt(0);
        Set<String> fields = gpo.getFieldDescriptor().getFields().getFields();
        Set<String> exFieldsSet = excludedFields.getFields();
        for (String field : fields) {
            if (exFieldsSet.contains(field)) continue;
            Type type = gpo.getFieldDescriptor().getType(field);
            GPOType gpoType = GPOType.GPO_TYPE_ARRAY[type.ordinal()];
            gpoType.serialize(gpo, field, sbytes, offset);
        }
        return sbytes;
    }

    public static GPOMutable deserialize(FieldsDescriptor fd, byte[] serializedGPO, MutableInt offset) {
        String[] fieldsString;
        double[] fieldsDouble;
        float[] fieldsFloat;
        long[] fieldsLong;
        int[] fieldsInteger;
        short[] fieldsShort;
        byte[] fieldsByte;
        char[] fieldsCharacter;
        GPOMutable gpo = new GPOMutable(fd);
        boolean[] fieldsBoolean = gpo.getFieldsBoolean();
        if (fieldsBoolean != null) {
            for (int index = 0; index < fieldsBoolean.length; ++index) {
                fieldsBoolean[index] = GPOUtils.deserializeBoolean(serializedGPO, offset);
            }
        }
        if ((fieldsCharacter = gpo.getFieldsCharacter()) != null) {
            for (int index = 0; index < fieldsCharacter.length; ++index) {
                fieldsCharacter[index] = GPOUtils.deserializeChar(serializedGPO, offset);
            }
        }
        if ((fieldsByte = gpo.getFieldsByte()) != null) {
            for (int index = 0; index < fieldsByte.length; ++index) {
                fieldsByte[index] = GPOUtils.deserializeByte(serializedGPO, offset);
            }
        }
        if ((fieldsShort = gpo.getFieldsShort()) != null) {
            for (int index = 0; index < fieldsShort.length; ++index) {
                fieldsShort[index] = GPOUtils.deserializeShort(serializedGPO, offset);
            }
        }
        if ((fieldsInteger = gpo.getFieldsInteger()) != null) {
            for (int index = 0; index < fieldsInteger.length; ++index) {
                fieldsInteger[index] = GPOUtils.deserializeInt(serializedGPO, offset);
            }
        }
        if ((fieldsLong = gpo.getFieldsLong()) != null) {
            for (int index = 0; index < fieldsLong.length; ++index) {
                fieldsLong[index] = GPOUtils.deserializeLong(serializedGPO, offset);
            }
        }
        if ((fieldsFloat = gpo.getFieldsFloat()) != null) {
            for (int index = 0; index < fieldsFloat.length; ++index) {
                fieldsFloat[index] = GPOUtils.deserializeFloat(serializedGPO, offset);
            }
        }
        if ((fieldsDouble = gpo.getFieldsDouble()) != null) {
            for (int index = 0; index < fieldsDouble.length; ++index) {
                fieldsDouble[index] = GPOUtils.deserializeDouble(serializedGPO, offset);
            }
        }
        if ((fieldsString = gpo.getFieldsString()) != null) {
            for (int index = 0; index < fieldsString.length; ++index) {
                fieldsString[index] = GPOUtils.deserializeString(serializedGPO, offset);
            }
        }
        Object[] fieldsObject = gpo.getFieldsObject();
        Serde[] serdes = fd.getSerdes();
        if (fieldsObject != null) {
            for (int index = 0; index < fieldsObject.length; ++index) {
                fieldsObject[index] = serdes[index].deserializeObject(serializedGPO, offset);
            }
        }
        return gpo;
    }

    public static GPOMutable deserialize(FieldsDescriptor fieldsDescriptor, Fields excludedFields, byte[] serializedGPO, int offset) {
        GPOMutable gpo = new GPOMutable(fieldsDescriptor);
        MutableInt offsetM = new MutableInt(offset);
        Set<String> exFieldsSet = excludedFields.getFields();
        for (String field : fieldsDescriptor.getFields().getFields()) {
            if (exFieldsSet.contains(field)) continue;
            Type type = fieldsDescriptor.getType(field);
            GPOType gpoType = GPOType.GPO_TYPE_ARRAY[type.ordinal()];
            gpoType.deserialize(gpo, field, serializedGPO, offsetM);
        }
        return gpo;
    }

    public static String deserializeString(byte[] buffer, MutableInt offset) {
        int length = GPOUtils.deserializeInt(buffer, offset);
        String val = new String(buffer, offset.intValue(), length);
        offset.add(length);
        return val;
    }

    public static void serializeString(String val, byte[] buffer, MutableInt offset) {
        byte[] stringBytes = val.getBytes();
        int length = stringBytes.length;
        GPOUtils.serializeInt(length, buffer, offset);
        for (int index = 0; index < length; ++index) {
            buffer[offset.intValue() + index] = stringBytes[index];
        }
        offset.add(length);
    }

    public static byte[] serializeString(String val) {
        byte[] stringBytes = val.getBytes();
        byte[] length = GPOUtils.serializeInt(stringBytes.length);
        byte[] serialized = new byte[stringBytes.length + length.length];
        System.arraycopy(length, 0, serialized, 0, length.length);
        System.arraycopy(stringBytes, 0, serialized, length.length, stringBytes.length);
        return serialized;
    }

    public static long deserializeLong(byte[] buffer, MutableInt offset) {
        int offsetInt = offset.intValue();
        long val = ((long)buffer[0 + offsetInt] & 0xFFL) << 56 | ((long)buffer[1 + offsetInt] & 0xFFL) << 48 | ((long)buffer[2 + offsetInt] & 0xFFL) << 40 | ((long)buffer[3 + offsetInt] & 0xFFL) << 32 | ((long)buffer[4 + offsetInt] & 0xFFL) << 24 | ((long)buffer[5 + offsetInt] & 0xFFL) << 16 | ((long)buffer[6 + offsetInt] & 0xFFL) << 8 | (long)buffer[7 + offsetInt] & 0xFFL;
        offset.add(Type.LONG.getByteSize());
        return val;
    }

    public static void serializeLong(long val, byte[] buffer, MutableInt offset) {
        int offsetInt = offset.intValue();
        buffer[0 + offsetInt] = (byte)(val >> 56 & 0xFFL);
        buffer[1 + offsetInt] = (byte)(val >> 48 & 0xFFL);
        buffer[2 + offsetInt] = (byte)(val >> 40 & 0xFFL);
        buffer[3 + offsetInt] = (byte)(val >> 32 & 0xFFL);
        buffer[4 + offsetInt] = (byte)(val >> 24 & 0xFFL);
        buffer[5 + offsetInt] = (byte)(val >> 16 & 0xFFL);
        buffer[6 + offsetInt] = (byte)(val >> 8 & 0xFFL);
        buffer[7 + offsetInt] = (byte)(val & 0xFFL);
        offset.add(Type.LONG.getByteSize());
    }

    public static byte[] serializeLong(long val) {
        byte[] buffer = new byte[Type.LONG.getByteSize()];
        buffer[0] = (byte)(val >> 56 & 0xFFL);
        buffer[1] = (byte)(val >> 48 & 0xFFL);
        buffer[2] = (byte)(val >> 40 & 0xFFL);
        buffer[3] = (byte)(val >> 32 & 0xFFL);
        buffer[4] = (byte)(val >> 24 & 0xFFL);
        buffer[5] = (byte)(val >> 16 & 0xFFL);
        buffer[6] = (byte)(val >> 8 & 0xFFL);
        buffer[7] = (byte)(val & 0xFFL);
        return buffer;
    }

    public static long deserializeLong(byte[] buffer) {
        Preconditions.checkArgument((buffer.length == Type.LONG.getByteSize() ? 1 : 0) != 0);
        return GPOUtils.deserializeLong(buffer, new MutableInt(0));
    }

    public static double deserializeDouble(byte[] buffer, MutableInt offset) {
        int offsetInt = offset.intValue();
        long val = ((long)buffer[0 + offsetInt] & 0xFFL) << 56 | ((long)buffer[1 + offsetInt] & 0xFFL) << 48 | ((long)buffer[2 + offsetInt] & 0xFFL) << 40 | ((long)buffer[3 + offsetInt] & 0xFFL) << 32 | ((long)buffer[4 + offsetInt] & 0xFFL) << 24 | ((long)buffer[5 + offsetInt] & 0xFFL) << 16 | ((long)buffer[6 + offsetInt] & 0xFFL) << 8 | (long)buffer[7 + offsetInt] & 0xFFL;
        offset.add(Type.DOUBLE.getByteSize());
        return Double.longBitsToDouble(val);
    }

    public static void serializeDouble(double valD, byte[] buffer, MutableInt offset) {
        long val = Double.doubleToLongBits(valD);
        int offsetInt = offset.intValue();
        buffer[0 + offsetInt] = (byte)(val >> 56 & 0xFFL);
        buffer[1 + offsetInt] = (byte)(val >> 48 & 0xFFL);
        buffer[2 + offsetInt] = (byte)(val >> 40 & 0xFFL);
        buffer[3 + offsetInt] = (byte)(val >> 32 & 0xFFL);
        buffer[4 + offsetInt] = (byte)(val >> 24 & 0xFFL);
        buffer[5 + offsetInt] = (byte)(val >> 16 & 0xFFL);
        buffer[6 + offsetInt] = (byte)(val >> 8 & 0xFFL);
        buffer[7 + offsetInt] = (byte)(val & 0xFFL);
        offset.add(Type.DOUBLE.getByteSize());
    }

    public static byte[] serializeDouble(double valD) {
        byte[] buffer = new byte[Type.DOUBLE.getByteSize()];
        long val = Double.doubleToLongBits(valD);
        buffer[0] = (byte)(val >> 56 & 0xFFL);
        buffer[1] = (byte)(val >> 48 & 0xFFL);
        buffer[2] = (byte)(val >> 40 & 0xFFL);
        buffer[3] = (byte)(val >> 32 & 0xFFL);
        buffer[4] = (byte)(val >> 24 & 0xFFL);
        buffer[5] = (byte)(val >> 16 & 0xFFL);
        buffer[6] = (byte)(val >> 8 & 0xFFL);
        buffer[7] = (byte)(val & 0xFFL);
        return buffer;
    }

    public static int deserializeInt(byte[] buffer, MutableInt offset) {
        int offsetInt = offset.intValue();
        int val = (buffer[0 + offsetInt] & 0xFF) << 24 | (buffer[1 + offsetInt] & 0xFF) << 16 | (buffer[2 + offsetInt] & 0xFF) << 8 | buffer[3 + offsetInt] & 0xFF;
        offset.add(Type.INTEGER.getByteSize());
        return val;
    }

    public static int deserializeInt(byte[] buffer) {
        Preconditions.checkArgument((buffer.length == Type.INTEGER.getByteSize() ? 1 : 0) != 0);
        return GPOUtils.deserializeInt(buffer, new MutableInt(0));
    }

    public static void serializeInt(int val, byte[] buffer, MutableInt offset) {
        int offsetInt = offset.intValue();
        buffer[0 + offsetInt] = (byte)(val >> 24 & 0xFF);
        buffer[1 + offsetInt] = (byte)(val >> 16 & 0xFF);
        buffer[2 + offsetInt] = (byte)(val >> 8 & 0xFF);
        buffer[3 + offsetInt] = (byte)(val & 0xFF);
        offset.add(Type.INTEGER.getByteSize());
    }

    public static byte[] serializeInt(int val) {
        byte[] buffer = new byte[Type.INTEGER.getByteSize()];
        buffer[0] = (byte)(val >> 24 & 0xFF);
        buffer[1] = (byte)(val >> 16 & 0xFF);
        buffer[2] = (byte)(val >> 8 & 0xFF);
        buffer[3] = (byte)(val & 0xFF);
        return buffer;
    }

    public static float deserializeFloat(byte[] buffer, MutableInt offset) {
        int offsetInt = offset.intValue();
        int val = (buffer[0 + offsetInt] & 0xFF) << 24 | (buffer[1 + offsetInt] & 0xFF) << 16 | (buffer[2 + offsetInt] & 0xFF) << 8 | buffer[3 + offsetInt] & 0xFF;
        offset.add(Type.FLOAT.getByteSize());
        return Float.intBitsToFloat(val);
    }

    public static void serializeFloat(float valf, byte[] buffer, MutableInt offset) {
        int offsetInt = offset.intValue();
        int val = Float.floatToIntBits(valf);
        buffer[0 + offsetInt] = (byte)(val >> 24 & 0xFF);
        buffer[1 + offsetInt] = (byte)(val >> 16 & 0xFF);
        buffer[2 + offsetInt] = (byte)(val >> 8 & 0xFF);
        buffer[3 + offsetInt] = (byte)(val & 0xFF);
        offset.add(Type.FLOAT.getByteSize());
    }

    public static byte[] serializeFloat(float valf) {
        byte[] buffer = new byte[Type.FLOAT.getByteSize()];
        int val = Float.floatToIntBits(valf);
        buffer[0] = (byte)(val >> 24 & 0xFF);
        buffer[1] = (byte)(val >> 16 & 0xFF);
        buffer[2] = (byte)(val >> 8 & 0xFF);
        buffer[3] = (byte)(val & 0xFF);
        return buffer;
    }

    public static short deserializeShort(byte[] buffer, MutableInt offset) {
        int offsetInt = offset.intValue();
        short val = (short)((buffer[0 + offsetInt] & 0xFF) << 8 | buffer[1 + offsetInt] & 0xFF);
        offset.add(Type.SHORT.getByteSize());
        return val;
    }

    public static void serializeShort(short val, byte[] buffer, MutableInt offset) {
        int offsetInt = offset.intValue();
        buffer[0 + offsetInt] = (byte)(val >> 8 & 0xFF);
        buffer[1 + offsetInt] = (byte)(val & 0xFF);
        offset.add(Type.SHORT.getByteSize());
    }

    public static byte[] serializeShort(short val) {
        byte[] buffer = new byte[Type.SHORT.getByteSize()];
        buffer[0] = (byte)(val >> 8 & 0xFF);
        buffer[1] = (byte)(val & 0xFF);
        return buffer;
    }

    public static byte deserializeByte(byte[] buffer, MutableInt offset) {
        byte val = buffer[offset.intValue()];
        offset.add(Type.BYTE.getByteSize());
        return val;
    }

    public static void serializeByte(byte val, byte[] buffer, MutableInt offset) {
        buffer[offset.intValue()] = val;
        offset.add(Type.BYTE.getByteSize());
    }

    public static byte[] serializeByte(byte val) {
        return new byte[]{val};
    }

    public static boolean deserializeBoolean(byte[] buffer, MutableInt offset) {
        boolean val = buffer[offset.intValue()] != 0;
        offset.add(Type.BOOLEAN.getByteSize());
        return val;
    }

    public static void serializeBoolean(boolean val, byte[] buffer, MutableInt offset) {
        buffer[offset.intValue()] = (byte)(val ? 1 : 0);
        offset.add(Type.BOOLEAN.getByteSize());
    }

    public static byte[] serializeBoolean(boolean val) {
        return new byte[]{(byte)(val ? 1 : 0)};
    }

    public static char deserializeChar(byte[] buffer, MutableInt offset) {
        int offsetInt = offset.intValue();
        char val = (char)((buffer[0 + offsetInt] & 0xFF) << 8 | buffer[1 + offsetInt] & 0xFF);
        offset.add(Type.CHAR.getByteSize());
        return val;
    }

    public static void serializeChar(char val, byte[] buffer, MutableInt offset) {
        int offsetInt = offset.intValue();
        buffer[0 + offsetInt] = (byte)(val >> 8 & 0xFF);
        buffer[1 + offsetInt] = (byte)(val & 0xFF);
        offset.add(Type.CHAR.getByteSize());
    }

    public static byte[] serializeChar(char val) {
        byte[] buffer = new byte[Type.CHAR.getByteSize()];
        buffer[0] = (byte)(val >> 8 & 0xFF);
        buffer[1] = (byte)(val & 0xFF);
        return buffer;
    }

    public static <T> T[] createGetters(List<String> fields, Map<String, String> valueToExpression, Class<?> clazz, Class<?> getterClazz, Class<?> getterMethodClazz) {
        Object[] getters = (Object[])Array.newInstance(getterMethodClazz, fields.size());
        for (int getterIndex = 0; getterIndex < fields.size(); ++getterIndex) {
            String field = fields.get(getterIndex);
            getters[getterIndex] = PojoUtils.constructGetter(clazz, valueToExpression.get(field), getterClazz);
        }
        return getters;
    }

    public static PojoUtils.Getter<Object, String>[] createGettersString(List<String> fields, Map<String, String> valueToExpression, Class<?> clazz) {
        PojoUtils.Getter[] getters = new PojoUtils.Getter[fields.size()];
        for (int getterIndex = 0; getterIndex < fields.size(); ++getterIndex) {
            String field = fields.get(getterIndex);
            getters[getterIndex] = PojoUtils.createGetter(clazz, valueToExpression.get(field), String.class);
        }
        return getters;
    }

    public static PojoUtils.Getter<Object, Object>[] createGettersObject(List<String> fields, Map<String, String> valueToExpression, Class<?> clazz) {
        PojoUtils.Getter[] getters = new PojoUtils.Getter[fields.size()];
        for (int getterIndex = 0; getterIndex < fields.size(); ++getterIndex) {
            String field = fields.get(getterIndex);
            getters[getterIndex] = PojoUtils.createGetter(clazz, valueToExpression.get(field), Object.class);
        }
        return getters;
    }

    public static GPOGetters buildGPOGetters(Map<String, String> fieldToGetter, FieldsDescriptor fieldsDescriptor, Class<?> clazz) {
        GPOGetters gpoGetters = new GPOGetters();
        Map<Type, List<String>> typeToFields = fieldsDescriptor.getTypeToFields();
        for (Map.Entry<Type, List<String>> entry : typeToFields.entrySet()) {
            Type inputType = entry.getKey();
            GPOType gpoType = GPOType.GPO_TYPE_ARRAY[inputType.ordinal()];
            List<String> fields = entry.getValue();
            gpoType.buildGPOGetters(gpoGetters, fields, fieldToGetter, clazz);
        }
        return gpoGetters;
    }

    public static void copyPOJOToGPO(GPOMutable mutable, GPOGetters getters, Object object) {
        int index;
        boolean[] tempBools = mutable.getFieldsBoolean();
        PojoUtils.GetterBoolean<Object>[] tempGetterBools = getters.gettersBoolean;
        if (tempBools != null) {
            for (index = 0; index < tempBools.length; ++index) {
                tempBools[index] = tempGetterBools[index].get(object);
            }
        }
        byte[] tempBytes = mutable.getFieldsByte();
        PojoUtils.GetterByte<Object>[] tempGetterByte = getters.gettersByte;
        if (tempBytes != null) {
            for (index = 0; index < tempBytes.length; ++index) {
                tempBytes[index] = tempGetterByte[index].get(object);
            }
        }
        char[] tempChar = mutable.getFieldsCharacter();
        PojoUtils.GetterChar<Object>[] tempGetterChar = getters.gettersChar;
        if (tempChar != null) {
            for (index = 0; index < tempChar.length; ++index) {
                tempChar[index] = tempGetterChar[index].get(object);
            }
        }
        double[] tempDouble = mutable.getFieldsDouble();
        PojoUtils.GetterDouble<Object>[] tempGetterDouble = getters.gettersDouble;
        if (tempDouble != null) {
            for (index = 0; index < tempDouble.length; ++index) {
                tempDouble[index] = tempGetterDouble[index].get(object);
            }
        }
        float[] tempFloat = mutable.getFieldsFloat();
        PojoUtils.GetterFloat<Object>[] tempGetterFloat = getters.gettersFloat;
        if (tempFloat != null) {
            for (index = 0; index < tempFloat.length; ++index) {
                tempFloat[index] = tempGetterFloat[index].get(object);
            }
        }
        int[] tempInt = mutable.getFieldsInteger();
        PojoUtils.GetterInt<Object>[] tempGetterInt = getters.gettersInteger;
        if (tempInt != null) {
            for (index = 0; index < tempInt.length; ++index) {
                tempInt[index] = tempGetterInt[index].get(object);
            }
        }
        long[] tempLong = mutable.getFieldsLong();
        PojoUtils.GetterLong<Object>[] tempGetterLong = getters.gettersLong;
        if (tempLong != null) {
            for (index = 0; index < tempLong.length; ++index) {
                tempLong[index] = tempGetterLong[index].get(object);
            }
        }
        short[] tempShort = mutable.getFieldsShort();
        PojoUtils.GetterShort<Object>[] tempGetterShort = getters.gettersShort;
        if (tempShort != null) {
            for (index = 0; index < tempShort.length; ++index) {
                tempShort[index] = tempGetterShort[index].get(object);
            }
        }
        String[] tempString = mutable.getFieldsString();
        PojoUtils.Getter<Object, String>[] tempGetterString = getters.gettersString;
        if (tempString != null) {
            for (index = 0; index < tempString.length; ++index) {
                tempString[index] = tempGetterString[index].get(object);
            }
        }
    }

    public static void indirectCopy(GPOMutable dest, GPOMutable src, IndexSubset indexSubset) {
        int index;
        String[] destString = dest.getFieldsString();
        String[] srcString = src.getFieldsString();
        int[] srcIndex = indexSubset.fieldsStringIndexSubset;
        if (destString != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                destString[index] = srcString[srcIndex[index]];
            }
        }
        boolean[] destBoolean = dest.getFieldsBoolean();
        boolean[] srcBoolean = src.getFieldsBoolean();
        srcIndex = indexSubset.fieldsBooleanIndexSubset;
        if (destBoolean != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                destBoolean[index] = srcBoolean[srcIndex[index]];
            }
        }
        char[] destChar = dest.getFieldsCharacter();
        char[] srcChar = src.getFieldsCharacter();
        srcIndex = indexSubset.fieldsBooleanIndexSubset;
        if (destChar != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                destChar[index] = srcChar[srcIndex[index]];
            }
        }
        byte[] destByte = dest.getFieldsByte();
        byte[] srcByte = src.getFieldsByte();
        srcIndex = indexSubset.fieldsByteIndexSubset;
        if (destByte != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                destByte[index] = srcByte[srcIndex[index]];
            }
        }
        short[] destShort = dest.getFieldsShort();
        short[] srcShort = src.getFieldsShort();
        srcIndex = indexSubset.fieldsShortIndexSubset;
        if (destShort != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                destShort[index] = srcShort[srcIndex[index]];
            }
        }
        int[] destInteger = dest.getFieldsInteger();
        int[] srcInteger = src.getFieldsInteger();
        srcIndex = indexSubset.fieldsIntegerIndexSubset;
        if (destInteger != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                destInteger[index] = srcInteger[srcIndex[index]];
            }
        }
        long[] destLong = dest.getFieldsLong();
        long[] srcLong = src.getFieldsLong();
        srcIndex = indexSubset.fieldsLongIndexSubset;
        if (destLong != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                destLong[index] = srcLong[srcIndex[index]];
            }
        }
        float[] destFloat = dest.getFieldsFloat();
        float[] srcFloat = src.getFieldsFloat();
        srcIndex = indexSubset.fieldsFloatIndexSubset;
        if (destFloat != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                destFloat[index] = srcFloat[srcIndex[index]];
            }
        }
        double[] destDouble = dest.getFieldsDouble();
        double[] srcDouble = src.getFieldsDouble();
        srcIndex = indexSubset.fieldsDoubleIndexSubset;
        if (destDouble != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                destDouble[index] = srcDouble[srcIndex[index]];
            }
        }
        Object[] destObject = dest.getFieldsObject();
        Object[] srcObject = src.getFieldsObject();
        srcIndex = indexSubset.fieldsObjectIndexSubset;
        if (destObject != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                destObject[index] = srcObject[srcIndex[index]];
            }
        }
    }

    public static int hashcode(GPOMutable gpo) {
        Object[] objectArray;
        double[] doubleArray;
        float[] floatArray;
        long[] longArray;
        int[] integerArray;
        short[] shortArray;
        byte[] byteArray;
        char[] charArray;
        boolean[] booleanArray;
        int index;
        int hashCode = 0;
        String[] stringArray = gpo.getFieldsString();
        if (stringArray != null) {
            for (index = 0; index < stringArray.length; ++index) {
                hashCode ^= stringArray[index].hashCode();
            }
        }
        if ((booleanArray = gpo.getFieldsBoolean()) != null) {
            for (index = 0; index < booleanArray.length; ++index) {
                hashCode ^= booleanArray[index] ? 1 : 0;
            }
        }
        if ((charArray = gpo.getFieldsCharacter()) != null) {
            for (index = 0; index < charArray.length; ++index) {
                hashCode ^= Character.getNumericValue(charArray[index]);
            }
        }
        if ((byteArray = gpo.getFieldsByte()) != null) {
            for (index = 0; index < byteArray.length; ++index) {
                hashCode ^= byteArray[index];
            }
        }
        if ((shortArray = gpo.getFieldsShort()) != null) {
            for (index = 0; index < shortArray.length; ++index) {
                hashCode ^= shortArray[index];
            }
        }
        if ((integerArray = gpo.getFieldsInteger()) != null) {
            for (index = 0; index < integerArray.length; ++index) {
                hashCode ^= integerArray[index];
            }
        }
        if ((longArray = gpo.getFieldsLong()) != null) {
            for (index = 0; index < longArray.length; ++index) {
                hashCode = (int)((long)hashCode ^ longArray[index]);
            }
        }
        if ((floatArray = gpo.getFieldsFloat()) != null) {
            for (index = 0; index < floatArray.length; ++index) {
                hashCode ^= Float.floatToIntBits(floatArray[index]);
            }
        }
        if ((doubleArray = gpo.getFieldsDouble()) != null) {
            for (index = 0; index < doubleArray.length; ++index) {
                hashCode = (int)((long)hashCode ^ Double.doubleToLongBits(doubleArray[index]));
            }
        }
        if ((objectArray = gpo.getFieldsObject()) != null) {
            for (index = 0; index < objectArray.length; ++index) {
                hashCode ^= objectArray[index].hashCode();
            }
        }
        return hashCode;
    }

    public static int indirectHashcode(GPOMutable gpo, IndexSubset indexSubset) {
        int elementHash;
        long element;
        int index;
        int hashCode = 7;
        int hashMultiplier = 23;
        String[] stringArray = gpo.getFieldsString();
        int[] srcIndex = indexSubset.fieldsStringIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                hashCode = 23 * hashCode + stringArray[srcIndex[index]].hashCode();
            }
        }
        boolean[] booleanArray = gpo.getFieldsBoolean();
        srcIndex = indexSubset.fieldsBooleanIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                hashCode = 23 * hashCode + (booleanArray[srcIndex[index]] ? 1 : 0);
            }
        }
        char[] charArray = gpo.getFieldsCharacter();
        srcIndex = indexSubset.fieldsCharacterIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                hashCode = 23 * hashCode + Character.getNumericValue(charArray[srcIndex[index]]);
            }
        }
        byte[] byteArray = gpo.getFieldsByte();
        srcIndex = indexSubset.fieldsByteIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                hashCode = 23 * hashCode + byteArray[srcIndex[index]];
            }
        }
        short[] shortArray = gpo.getFieldsShort();
        srcIndex = indexSubset.fieldsShortIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                hashCode = 23 * hashCode + shortArray[srcIndex[index]];
            }
        }
        int[] integerArray = gpo.getFieldsInteger();
        srcIndex = indexSubset.fieldsIntegerIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                hashCode = 23 * hashCode + integerArray[srcIndex[index]];
            }
        }
        long[] longArray = gpo.getFieldsLong();
        srcIndex = indexSubset.fieldsLongIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                element = longArray[srcIndex[index]];
                elementHash = (int)(element ^ element >>> 32);
                hashCode = 23 * hashCode + elementHash;
            }
        }
        float[] floatArray = gpo.getFieldsFloat();
        srcIndex = indexSubset.fieldsFloatIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                hashCode = 23 * hashCode + Float.floatToIntBits(floatArray[srcIndex[index]]);
            }
        }
        double[] doubleArray = gpo.getFieldsDouble();
        srcIndex = indexSubset.fieldsDoubleIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                element = Double.doubleToLongBits(doubleArray[srcIndex[index]]);
                elementHash = (int)(element ^ element >>> 32);
                hashCode = 23 * hashCode + elementHash;
            }
        }
        Object[] objectArray = gpo.getFieldsObject();
        srcIndex = indexSubset.fieldsObjectIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1) continue;
                hashCode = 23 * hashCode + objectArray[srcIndex[index]].hashCode();
            }
        }
        return hashCode;
    }

    public static boolean equals(GPOMutable dest, GPOMutable src) {
        int index;
        String[] destString = dest.getFieldsString();
        String[] srcString = src.getFieldsString();
        if (destString != null) {
            for (index = 0; index < srcString.length; ++index) {
                if (destString[index].equals(srcString[index])) continue;
                return false;
            }
        }
        boolean[] destBoolean = dest.getFieldsBoolean();
        boolean[] srcBoolean = src.getFieldsBoolean();
        if (destBoolean != null) {
            for (index = 0; index < srcBoolean.length; ++index) {
                if (destBoolean[index] == srcBoolean[index]) continue;
                return false;
            }
        }
        char[] destChar = dest.getFieldsCharacter();
        char[] srcChar = src.getFieldsCharacter();
        if (destChar != null) {
            for (index = 0; index < srcChar.length; ++index) {
                if (destChar[index] == srcChar[index]) continue;
                return false;
            }
        }
        byte[] destByte = dest.getFieldsByte();
        byte[] srcByte = src.getFieldsByte();
        if (destByte != null) {
            for (index = 0; index < srcByte.length; ++index) {
                if (destByte[index] == srcByte[index]) continue;
                return false;
            }
        }
        short[] destShort = dest.getFieldsShort();
        short[] srcShort = src.getFieldsShort();
        if (destShort != null) {
            for (index = 0; index < srcShort.length; ++index) {
                if (destShort[index] == srcShort[index]) continue;
                return false;
            }
        }
        int[] destInteger = dest.getFieldsInteger();
        int[] srcInteger = src.getFieldsInteger();
        if (destInteger != null) {
            for (index = 0; index < srcInteger.length; ++index) {
                if (destInteger[index] == srcInteger[index]) continue;
                return false;
            }
        }
        long[] destLong = dest.getFieldsLong();
        long[] srcLong = src.getFieldsLong();
        if (destLong != null) {
            for (index = 0; index < srcLong.length; ++index) {
                if (destLong[index] == srcLong[index]) continue;
                return false;
            }
        }
        float[] destFloat = dest.getFieldsFloat();
        float[] srcFloat = src.getFieldsFloat();
        if (destFloat != null) {
            for (index = 0; index < srcFloat.length; ++index) {
                if (destFloat[index] == srcFloat[index]) continue;
                return false;
            }
        }
        double[] destDouble = dest.getFieldsDouble();
        double[] srcDouble = src.getFieldsDouble();
        if (destDouble != null) {
            for (index = 0; index < srcDouble.length; ++index) {
                if (destDouble[index] == srcDouble[index]) continue;
                return false;
            }
        }
        Object[] destObject = dest.getFieldsObject();
        Object[] srcObject = src.getFieldsObject();
        if (destObject != null) {
            for (index = 0; index < srcObject.length; ++index) {
                if (destObject[index].equals(srcObject[index])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean subsetEquals(GPOMutable dest, GPOMutable src, IndexSubset indexSubset) {
        int index;
        String[] destString = dest.getFieldsString();
        String[] srcString = src.getFieldsString();
        int[] srcIndex = indexSubset.fieldsStringIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destString[srcIndex[index]].equals(srcString[srcIndex[index]])) continue;
                return false;
            }
        }
        boolean[] destBoolean = dest.getFieldsBoolean();
        boolean[] srcBoolean = src.getFieldsBoolean();
        srcIndex = indexSubset.fieldsBooleanIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destBoolean[srcIndex[index]] == srcBoolean[srcIndex[index]]) continue;
                return false;
            }
        }
        char[] destChar = dest.getFieldsCharacter();
        char[] srcChar = src.getFieldsCharacter();
        srcIndex = indexSubset.fieldsBooleanIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destChar[srcIndex[index]] == srcChar[srcIndex[index]]) continue;
                return false;
            }
        }
        byte[] destByte = dest.getFieldsByte();
        byte[] srcByte = src.getFieldsByte();
        srcIndex = indexSubset.fieldsByteIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destByte[srcIndex[index]] == srcByte[srcIndex[index]]) continue;
                return false;
            }
        }
        short[] destShort = dest.getFieldsShort();
        short[] srcShort = src.getFieldsShort();
        srcIndex = indexSubset.fieldsShortIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destShort[srcIndex[index]] == srcShort[srcIndex[index]]) continue;
                return false;
            }
        }
        int[] destInteger = dest.getFieldsInteger();
        int[] srcInteger = src.getFieldsInteger();
        srcIndex = indexSubset.fieldsIntegerIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destInteger[srcIndex[index]] == srcInteger[srcIndex[index]]) continue;
                return false;
            }
        }
        long[] destLong = dest.getFieldsLong();
        long[] srcLong = src.getFieldsLong();
        srcIndex = indexSubset.fieldsLongIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destLong[srcIndex[index]] == srcLong[srcIndex[index]]) continue;
                return false;
            }
        }
        float[] destFloat = dest.getFieldsFloat();
        float[] srcFloat = src.getFieldsFloat();
        srcIndex = indexSubset.fieldsFloatIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destFloat[srcIndex[index]] == srcFloat[srcIndex[index]]) continue;
                return false;
            }
        }
        double[] destDouble = dest.getFieldsDouble();
        double[] srcDouble = src.getFieldsDouble();
        srcIndex = indexSubset.fieldsDoubleIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destDouble[srcIndex[index]] == srcDouble[srcIndex[index]]) continue;
                return false;
            }
        }
        Object[] destObject = dest.getFieldsObject();
        Object[] srcObject = src.getFieldsObject();
        srcIndex = indexSubset.fieldsObjectIndexSubset;
        if (srcIndex != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destObject[srcIndex[index]].equals(srcObject[srcIndex[index]])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean indirectEquals(GPOMutable dest, GPOMutable src, IndexSubset indexSubset) {
        int index;
        String[] destString = dest.getFieldsString();
        String[] srcString = src.getFieldsString();
        int[] srcIndex = indexSubset.fieldsStringIndexSubset;
        if (destString != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destString[index].equals(srcString[srcIndex[index]])) continue;
                return false;
            }
        }
        boolean[] destBoolean = dest.getFieldsBoolean();
        boolean[] srcBoolean = src.getFieldsBoolean();
        srcIndex = indexSubset.fieldsBooleanIndexSubset;
        if (destBoolean != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destBoolean[index] == srcBoolean[srcIndex[index]]) continue;
                return false;
            }
        }
        char[] destChar = dest.getFieldsCharacter();
        char[] srcChar = src.getFieldsCharacter();
        srcIndex = indexSubset.fieldsBooleanIndexSubset;
        if (destChar != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destChar[index] == srcChar[srcIndex[index]]) continue;
                return false;
            }
        }
        byte[] destByte = dest.getFieldsByte();
        byte[] srcByte = src.getFieldsByte();
        srcIndex = indexSubset.fieldsByteIndexSubset;
        if (destByte != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destByte[index] == srcByte[srcIndex[index]]) continue;
                return false;
            }
        }
        short[] destShort = dest.getFieldsShort();
        short[] srcShort = src.getFieldsShort();
        srcIndex = indexSubset.fieldsShortIndexSubset;
        if (destShort != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destShort[index] == srcShort[srcIndex[index]]) continue;
                return false;
            }
        }
        int[] destInteger = dest.getFieldsInteger();
        int[] srcInteger = src.getFieldsInteger();
        srcIndex = indexSubset.fieldsIntegerIndexSubset;
        if (destInteger != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destInteger[index] == srcInteger[srcIndex[index]]) continue;
                return false;
            }
        }
        long[] destLong = dest.getFieldsLong();
        long[] srcLong = src.getFieldsLong();
        srcIndex = indexSubset.fieldsLongIndexSubset;
        if (destLong != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destLong[index] == srcLong[srcIndex[index]]) continue;
                return false;
            }
        }
        float[] destFloat = dest.getFieldsFloat();
        float[] srcFloat = src.getFieldsFloat();
        srcIndex = indexSubset.fieldsFloatIndexSubset;
        if (destFloat != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destFloat[index] == srcFloat[srcIndex[index]]) continue;
                return false;
            }
        }
        double[] destDouble = dest.getFieldsDouble();
        double[] srcDouble = src.getFieldsDouble();
        srcIndex = indexSubset.fieldsDoubleIndexSubset;
        if (destDouble != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destDouble[index] == srcDouble[srcIndex[index]]) continue;
                return false;
            }
        }
        Object[] destObject = dest.getFieldsObject();
        Object[] srcObject = src.getFieldsObject();
        srcIndex = indexSubset.fieldsObjectIndexSubset;
        if (destObject != null) {
            for (index = 0; index < srcIndex.length; ++index) {
                if (srcIndex[index] == -1 || destObject[index].equals(srcObject[srcIndex[index]])) continue;
                return false;
            }
        }
        return true;
    }

    public static void zeroFillNumeric(GPOMutable value) {
        if (value.getFieldsByte() != null) {
            Arrays.fill(value.getFieldsByte(), (byte)0);
        }
        if (value.getFieldsShort() != null) {
            Arrays.fill(value.getFieldsShort(), (short)0);
        }
        if (value.getFieldsInteger() != null) {
            Arrays.fill(value.getFieldsInteger(), 0);
        }
        if (value.getFieldsLong() != null) {
            Arrays.fill(value.getFieldsLong(), 0L);
        }
        if (value.getFieldsFloat() != null) {
            Arrays.fill(value.getFieldsFloat(), 0.0f);
        }
        if (value.getFieldsDouble() != null) {
            Arrays.fill(value.getFieldsDouble(), 0.0);
        }
    }

    public static IndexSubset computeSubIndices(FieldsDescriptor child, FieldsDescriptor parent) {
        IndexSubset indexSubset = new IndexSubset();
        block11: for (Map.Entry<Type, List<String>> entry : child.getTypeToFields().entrySet()) {
            int[] indices;
            Type type = entry.getKey();
            List<String> childFields = entry.getValue();
            List<String> parentFields = parent.getTypeToFields().get(type);
            int size = child.getTypeToSize().get((Object)type);
            if (child.getTypeToFields().get(type) != null && child.getCompressedTypes().contains(type)) {
                indices = new int[1];
            } else {
                indices = new int[size];
                for (int index = 0; index < size; ++index) {
                    indices[index] = parentFields == null ? -1 : parentFields.indexOf(childFields.get(index));
                }
            }
            switch (type) {
                case BOOLEAN: {
                    indexSubset.fieldsBooleanIndexSubset = indices;
                    continue block11;
                }
                case CHAR: {
                    indexSubset.fieldsCharacterIndexSubset = indices;
                    continue block11;
                }
                case STRING: {
                    indexSubset.fieldsStringIndexSubset = indices;
                    continue block11;
                }
                case BYTE: {
                    indexSubset.fieldsByteIndexSubset = indices;
                    continue block11;
                }
                case SHORT: {
                    indexSubset.fieldsShortIndexSubset = indices;
                    continue block11;
                }
                case INTEGER: {
                    indexSubset.fieldsIntegerIndexSubset = indices;
                    continue block11;
                }
                case LONG: {
                    indexSubset.fieldsLongIndexSubset = indices;
                    continue block11;
                }
                case FLOAT: {
                    indexSubset.fieldsFloatIndexSubset = indices;
                    continue block11;
                }
                case DOUBLE: {
                    indexSubset.fieldsDoubleIndexSubset = indices;
                    continue block11;
                }
            }
            throw new UnsupportedOperationException("Type " + type);
        }
        return indexSubset;
    }

    public static Map<String, Object> getDestringedData(FieldsDescriptor fd, Map<String, String> stringMap) {
        HashMap fieldToData = Maps.newHashMap();
        Map<String, Type> fieldToType = fd.getFieldToType();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            Object objValue;
            String valueString = entry.getValue();
            Type valueType = fieldToType.get(entry.getKey());
            switch (valueType) {
                case BOOLEAN: {
                    objValue = Boolean.valueOf(valueString);
                    break;
                }
                case BYTE: {
                    objValue = Byte.valueOf(valueString);
                    break;
                }
                case SHORT: {
                    objValue = Short.valueOf(valueString);
                    break;
                }
                case INTEGER: {
                    objValue = Integer.valueOf(valueString);
                    break;
                }
                case LONG: {
                    objValue = Long.valueOf(valueString);
                    break;
                }
                case FLOAT: {
                    objValue = Float.valueOf(valueString);
                    break;
                }
                case DOUBLE: {
                    objValue = Double.valueOf(valueString);
                    break;
                }
                case STRING: {
                    objValue = valueString;
                    break;
                }
                case OBJECT: {
                    throw new UnsupportedOperationException("The given type " + entry.getValue() + " is unsupported.");
                }
                default: {
                    throw new UnsupportedOperationException("The given type " + entry.getValue() + " is unsupported.");
                }
            }
            fieldToData.put(entry.getKey(), objValue);
        }
        return fieldToData;
    }

    public static Map<String, Object> convertToMapIntersection(GPOMutable gpo, Fields fields) {
        HashMap values = Maps.newHashMap();
        for (String field : fields.getFields()) {
            if (!gpo.getFieldDescriptor().getFields().getFields().contains(field)) continue;
            Object valueObj = gpo.getField(field);
            values.put(field, valueObj);
        }
        return values;
    }

    public static boolean insideRange(Type type, int val) {
        switch (type) {
            case BYTE: {
                return val >= -128 && val <= 127;
            }
            case SHORT: {
                return val >= Short.MIN_VALUE && val <= Short.MAX_VALUE;
            }
        }
        throw new UnsupportedOperationException("This operation is not supported for the type " + type);
    }

    public static boolean numericTypeIntOrSmaller(Type type) {
        return type == Type.BYTE || type == Type.SHORT || type == Type.INTEGER;
    }

    public static class IndexSubset
    implements Serializable {
        private static final long serialVersionUID = 201506251015L;
        public int[] fieldsBooleanIndexSubset;
        public int[] fieldsCharacterIndexSubset;
        public int[] fieldsByteIndexSubset;
        public int[] fieldsShortIndexSubset;
        public int[] fieldsIntegerIndexSubset;
        public int[] fieldsLongIndexSubset;
        public int[] fieldsFloatIndexSubset;
        public int[] fieldsDoubleIndexSubset;
        public int[] fieldsStringIndexSubset;
        public int[] fieldsObjectIndexSubset;

        public String toString() {
            return "IndexSubset{fieldsBooleanIndexSubset=" + this.fieldsBooleanIndexSubset + ", fieldsCharacterIndexSubset=" + this.fieldsCharacterIndexSubset + ", fieldsByteIndexSubset=" + this.fieldsByteIndexSubset + ", fieldsShortIndexSubset=" + this.fieldsShortIndexSubset + ", fieldsIntegerIndexSubset=" + this.fieldsIntegerIndexSubset + ", fieldsLongIndexSubset=" + this.fieldsLongIndexSubset + ", fieldsFloatIndexSubset=" + this.fieldsFloatIndexSubset + ", fieldsDoubleIndexSubset=" + this.fieldsDoubleIndexSubset + ", fieldsStringIndexSubset=" + this.fieldsStringIndexSubset + '}';
        }
    }
}

