/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.gpo;

import com.datatorrent.lib.appdata.gpo.GPOByteArrayList;
import com.datatorrent.lib.appdata.gpo.GPOUtils;
import com.datatorrent.lib.appdata.gpo.Serde;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;

public class SerdeFieldsDescriptor
implements Serde {
    public static final SerdeFieldsDescriptor INSTANCE = new SerdeFieldsDescriptor();
    private GPOByteArrayList bal = new GPOByteArrayList();

    private SerdeFieldsDescriptor() {
    }

    @Override
    public synchronized byte[] serializeObject(Object object) {
        FieldsDescriptor fd = (FieldsDescriptor)object;
        for (Map.Entry<String, Type> entry : fd.getFieldToType().entrySet()) {
            this.bal.add(GPOUtils.serializeInt(entry.getValue().ordinal()));
            this.bal.add(GPOUtils.serializeString(entry.getKey()));
        }
        byte[] serializedBytes = this.bal.toByteArray();
        this.bal.clear();
        this.bal.add(GPOUtils.serializeInt(serializedBytes.length));
        this.bal.add(serializedBytes);
        serializedBytes = this.bal.toByteArray();
        this.bal.clear();
        return serializedBytes;
    }

    @Override
    public synchronized Object deserializeObject(byte[] object, MutableInt offset) {
        HashMap fieldToType = Maps.newHashMap();
        int length = GPOUtils.deserializeInt(object, offset);
        int startIndex = offset.intValue();
        while (startIndex + length > offset.intValue()) {
            Type type = Type.values()[GPOUtils.deserializeInt(object, offset)];
            String value = GPOUtils.deserializeString(object, offset);
            fieldToType.put(value, type);
        }
        return new FieldsDescriptor(fieldToType);
    }
}

