/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.gpo;

import com.datatorrent.lib.appdata.gpo.GPOByteArrayList;
import com.datatorrent.lib.appdata.gpo.GPOType;
import com.datatorrent.lib.appdata.gpo.GPOUtils;
import com.datatorrent.lib.appdata.gpo.Serde;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;

public class SerdeListPrimitive
implements Serde {
    public static final SerdeListPrimitive INSTANCE = new SerdeListPrimitive();
    private final GPOByteArrayList bytes = new GPOByteArrayList();

    private SerdeListPrimitive() {
    }

    @Override
    public synchronized byte[] serializeObject(Object object) {
        List primitives = (List)object;
        for (int index = 0; index < primitives.size(); ++index) {
            Object primitive = primitives.get(index);
            Type type = Type.CLASS_TO_TYPE.get(primitive.getClass());
            if (type == null || type == Type.OBJECT) {
                throw new IllegalArgumentException("Cannot serialize objects of class " + primitive.getClass());
            }
            this.bytes.add(GPOUtils.serializeInt(type.ordinal()));
            GPOType gpoType = GPOType.GPO_TYPE_ARRAY[type.ordinal()];
            this.bytes.add(gpoType.serialize(primitive));
        }
        byte[] serializedBytes = this.bytes.toByteArray();
        this.bytes.clear();
        this.bytes.add(GPOUtils.serializeInt(serializedBytes.length));
        this.bytes.add(serializedBytes);
        serializedBytes = this.bytes.toByteArray();
        this.bytes.clear();
        return serializedBytes;
    }

    @Override
    public synchronized Object deserializeObject(byte[] object, MutableInt offset) {
        int length = GPOUtils.deserializeInt(object, offset);
        int startIndex = offset.intValue();
        ArrayList listPrimitives = Lists.newArrayList();
        while (startIndex + length > offset.intValue()) {
            int typeOrdinal = GPOUtils.deserializeInt(object, offset);
            GPOType gpoType = GPOType.GPO_TYPE_ARRAY[typeOrdinal];
            Object primitive = gpoType.deserialize(object, offset);
            listPrimitives.add(primitive);
        }
        return listPrimitives;
    }
}

