/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.gpo;

import com.datatorrent.lib.appdata.gpo.GPOByteArrayList;
import com.datatorrent.lib.appdata.gpo.GPOUtils;
import com.datatorrent.lib.appdata.gpo.Serde;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerdeListString
implements Serde {
    public static final SerdeListString INSTANCE = new SerdeListString();
    private final GPOByteArrayList bytes = new GPOByteArrayList();
    private static final Logger LOG = LoggerFactory.getLogger(SerdeListString.class);

    private SerdeListString() {
    }

    @Override
    public synchronized Object deserializeObject(byte[] object, MutableInt offset) {
        int length = GPOUtils.deserializeInt(object, offset);
        int startIndex = offset.intValue();
        ArrayList strings = Lists.newArrayList();
        while (startIndex + length > offset.intValue()) {
            String value = GPOUtils.deserializeString(object, offset);
            strings.add(value);
        }
        return strings;
    }

    @Override
    public synchronized byte[] serializeObject(Object object) {
        List strings = (List)object;
        for (int index = 0; index < strings.size(); ++index) {
            String string = (String)strings.get(index);
            byte[] stringBytes = string.getBytes();
            byte[] lengthBytes = GPOUtils.serializeInt(stringBytes.length);
            this.bytes.add(lengthBytes);
            this.bytes.add(stringBytes);
        }
        byte[] byteArray = this.bytes.toByteArray();
        this.bytes.clear();
        this.bytes.add(GPOUtils.serializeInt(byteArray.length));
        this.bytes.add(byteArray);
        byteArray = this.bytes.toByteArray();
        this.bytes.clear();
        return byteArray;
    }
}

