/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.gpo;

import com.datatorrent.lib.appdata.gpo.GPOByteArrayList;
import com.datatorrent.lib.appdata.gpo.GPOType;
import com.datatorrent.lib.appdata.gpo.GPOUtils;
import com.datatorrent.lib.appdata.gpo.Serde;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;

public class SerdeMapPrimitive
implements Serde {
    public static final SerdeMapPrimitive INSTANCE = new SerdeMapPrimitive();
    private final GPOByteArrayList bytes = new GPOByteArrayList();

    private SerdeMapPrimitive() {
    }

    @Override
    public synchronized byte[] serializeObject(Object object) {
        Map primitiveMap = (Map)object;
        for (Map.Entry entry : primitiveMap.entrySet()) {
            this.serializePrimitive(entry.getKey(), this.bytes);
            this.serializePrimitive(entry.getValue(), this.bytes);
        }
        byte[] serializedBytes = this.bytes.toByteArray();
        this.bytes.clear();
        this.bytes.add(GPOUtils.serializeInt(serializedBytes.length));
        this.bytes.add(serializedBytes);
        serializedBytes = this.bytes.toByteArray();
        this.bytes.clear();
        return serializedBytes;
    }

    protected void serializePrimitive(Object object, GPOByteArrayList bytes) {
        Type type = Type.CLASS_TO_TYPE.get(object.getClass());
        if (type == null || type == Type.OBJECT) {
            throw new IllegalArgumentException("Cannot serialize objects of class " + object.getClass());
        }
        bytes.add(GPOUtils.serializeInt(type.ordinal()));
        GPOType gpoType = GPOType.GPO_TYPE_ARRAY[type.ordinal()];
        bytes.add(gpoType.serialize(object));
    }

    @Override
    public synchronized Object deserializeObject(byte[] objectBytes, MutableInt offset) {
        int length = GPOUtils.deserializeInt(objectBytes, offset);
        int startIndex = offset.intValue();
        HashMap primitiveMap = Maps.newHashMap();
        while (startIndex + length > offset.intValue()) {
            int typeOrdinal = GPOUtils.deserializeInt(objectBytes, offset);
            GPOType gpoType = GPOType.GPO_TYPE_ARRAY[typeOrdinal];
            Object key = gpoType.deserialize(objectBytes, offset);
            typeOrdinal = GPOUtils.deserializeInt(objectBytes, offset);
            gpoType = GPOType.GPO_TYPE_ARRAY[typeOrdinal];
            Object value = gpoType.deserialize(objectBytes, offset);
            primitiveMap.put(key, value);
        }
        return primitiveMap;
    }
}

