/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.query;

import com.datatorrent.lib.appdata.query.QueryBundle;
import com.datatorrent.lib.appdata.query.QueueList;
import com.datatorrent.lib.appdata.query.WindowEndQueueManager;
import com.datatorrent.lib.appdata.schemas.QRBase;
import com.datatorrent.lib.appdata.schemas.Query;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableLong;

public class AppDataWindowEndQueueManager<QUERY extends Query, META_QUERY>
extends WindowEndQueueManager<QUERY, META_QUERY> {
    private final Map<String, QueueList.QueueListNode<QueryBundle<QUERY, META_QUERY, MutableLong>>> queryIDToNode = Maps.newHashMap();

    @Override
    public boolean enqueue(QUERY query, META_QUERY metaQuery, MutableLong context) {
        if (context != null) {
            ((QRBase)query).setCountdown(context.getValue());
        }
        if (((QRBase)query).isOneTime()) {
            return super.enqueue(query, metaQuery, new MutableLong(1L));
        }
        return super.enqueue(query, metaQuery, new MutableLong(((QRBase)query).getCountdown()));
    }

    @Override
    public void addedNode(QueueList.QueueListNode<QueryBundle<QUERY, META_QUERY, MutableLong>> queryQueueable) {
        this.queryIDToNode.put(((Query)queryQueueable.getPayload().getQuery()).getId(), queryQueueable);
    }

    @Override
    public void removedNode(QueueList.QueueListNode<QueryBundle<QUERY, META_QUERY, MutableLong>> queryQueueable) {
        this.queryIDToNode.remove(((Query)queryQueueable.getPayload().getQuery()).getId());
    }

    @Override
    public boolean addingFilter(QueryBundle<QUERY, META_QUERY, MutableLong> queryBundle) {
        QueueList.QueueListNode<QueryBundle<QUERY, META_QUERY, MutableLong>> queryNode = this.queryIDToNode.get(((Query)queryBundle.getQuery()).getId());
        if (queryNode == null) {
            return true;
        }
        queryNode.setPayload(queryBundle);
        return false;
    }
}

