/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.query;

import com.datatorrent.api.Component;
import com.datatorrent.api.Context;
import com.datatorrent.lib.appdata.query.QueryBundle;
import com.datatorrent.lib.appdata.query.QueryExecutor;
import com.datatorrent.lib.appdata.query.QueueManager;
import com.datatorrent.lib.appdata.query.SimpleQueueManager;
import com.google.common.base.Preconditions;

public class QueryManagerSynchronous<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT>
implements Component<Context.OperatorContext> {
    private QueryExecutor<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT> queryExecutor;
    private QueueManager<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT> queryQueueManager;

    private QueryManagerSynchronous(QueryExecutor<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT> queryComputer) {
        this.setQueryExecutor(queryComputer);
        this.queryQueueManager = new SimpleQueueManager();
    }

    private QueryManagerSynchronous(QueryExecutor<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT> queryComputer, QueueManager<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT> queryQueueManager) {
        this.setQueryExecutor(queryComputer);
        this.setQueryQueueManager(queryQueueManager);
    }

    private void setQueryExecutor(QueryExecutor<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT> queryExecutor) {
        this.queryExecutor = (QueryExecutor)Preconditions.checkNotNull(queryExecutor);
    }

    private void setQueryQueueManager(QueueManager<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT> queryQueueManager) {
        this.queryQueueManager = (QueueManager)Preconditions.checkNotNull(queryQueueManager);
    }

    public boolean enqueue(QUERY_TYPE query, META_QUERY metaQuery, QUEUE_CONTEXT queueContext) {
        return this.queryQueueManager.enqueue(query, metaQuery, queueContext);
    }

    public RESULT process() {
        QueryBundle<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT> queryBundle;
        RESULT result = null;
        do {
            if ((queryBundle = this.queryQueueManager.dequeue()) != null) continue;
            return null;
        } while ((result = (RESULT)this.queryExecutor.executeQuery(queryBundle.getQuery(), queryBundle.getMetaQuery(), queryBundle.getQueueContext())) == null);
        return result;
    }

    public void setup(Context.OperatorContext context) {
        this.queryQueueManager.setup((Context)context);
    }

    public void beginWindow(long windowId) {
        this.queryQueueManager.beginWindow(windowId);
    }

    public void endWindow() {
        this.queryQueueManager.endWindow();
    }

    public void teardown() {
        this.queryQueueManager.teardown();
    }

    public static <QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT> QueryManagerSynchronous<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT> newInstance(QueryExecutor<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT> queryExecutor) {
        return new QueryManagerSynchronous<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT>(queryExecutor);
    }

    public static <QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT> QueryManagerSynchronous<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT> newInstance(QueryExecutor<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT> queryExecutor, QueueManager<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT> queryQueueManager) {
        return new QueryManagerSynchronous<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT, RESULT>(queryExecutor, queryQueueManager);
    }
}

