/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.query;

import com.google.common.base.Preconditions;

public class QueueList<T> {
    private int size = 0;
    private QueueListNode<T> head;
    private QueueListNode<T> tail;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(QueueListNode<T> node) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkNotNull(node);
            ++this.size;
            if (this.head == null) {
                this.head = node;
                this.tail = node;
                node.setNext(null);
                node.setPrev(null);
                return;
            }
            this.tail.setNext(node);
            node.setPrev(this.tail);
            node.setNext(null);
            this.tail = node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueListNode<T> getHead() {
        Object object = this.lock;
        synchronized (object) {
            return this.head;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(QueueListNode<T> node) {
        Object object = this.lock;
        synchronized (object) {
            --this.size;
            if (this.head == node) {
                if (this.tail == node) {
                    this.head = null;
                    this.tail = null;
                } else {
                    this.head = node.getNext();
                    this.head.setPrev(null);
                }
            } else if (this.tail == node) {
                this.tail = node.getPrev();
                this.tail.setNext(null);
            } else {
                node.getPrev().setNext(node.getNext());
                node.getNext().setPrev(node.getPrev());
            }
        }
    }

    public int getSize() {
        return this.size;
    }

    public static class QueueListNode<T> {
        private QueueListNode<T> prev;
        private QueueListNode<T> next;
        private T payload;

        public QueueListNode() {
        }

        public QueueListNode(T payload) {
            this.payload = payload;
        }

        public QueueListNode<T> getPrev() {
            return this.prev;
        }

        public void setPrev(QueueListNode<T> prev) {
            this.prev = prev;
        }

        public QueueListNode<T> getNext() {
            return this.next;
        }

        public void setNext(QueueListNode<T> next) {
            this.next = next;
        }

        public T getPayload() {
            return this.payload;
        }

        public void setPayload(T payload) {
            this.payload = payload;
        }

        public String toString() {
            return "QueueListNode{payload=" + this.payload + '}';
        }
    }
}

