/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.query;

import com.datatorrent.api.Context;
import com.datatorrent.lib.appdata.QueueUtils;
import com.datatorrent.lib.appdata.query.QueryBundle;
import com.datatorrent.lib.appdata.query.QueueManager;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class SimpleQueueManager<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT>
implements QueueManager<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT> {
    private LinkedList<QueryBundle<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT>> queue = new LinkedList();
    private final Semaphore semaphore = new Semaphore(0);
    private final QueueUtils.ConditionBarrier conditionBarrier = new QueueUtils.ConditionBarrier();

    @Override
    public boolean enqueue(QUERY_TYPE query, META_QUERY metaQuery, QUEUE_CONTEXT queueContext) {
        this.conditionBarrier.gate();
        QueryBundle<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT> qq = new QueryBundle<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT>(query, metaQuery, queueContext);
        if (this.queue.offer(qq)) {
            this.semaphore.release();
            return true;
        }
        return false;
    }

    @Override
    public QueryBundle<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT> dequeue() {
        return this.queue.poll();
    }

    @Override
    public QueryBundle<QUERY_TYPE, META_QUERY, QUEUE_CONTEXT> dequeueBlock() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        return this.queue.poll();
    }

    public void setup(Context.OperatorContext context) {
    }

    @Override
    public void beginWindow(long windowId) {
    }

    @Override
    public void endWindow() {
    }

    public void teardown() {
    }

    @Override
    public int getNumLeft() {
        return this.queue.size();
    }

    @Override
    public void haltEnqueue() {
        this.conditionBarrier.lock();
    }

    @Override
    public void resumeEnqueue() {
        this.conditionBarrier.unlock();
    }
}

