/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.query.serde;

import com.datatorrent.lib.appdata.query.serde.CustomMessageDeserializer;
import com.datatorrent.lib.appdata.schemas.DataQuerySnapshot;
import com.datatorrent.lib.appdata.schemas.Fields;
import com.datatorrent.lib.appdata.schemas.Message;
import com.datatorrent.lib.appdata.schemas.SchemaUtils;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataQuerySnapshotDeserializer
implements CustomMessageDeserializer {
    public static final Set<Fields> FIRST_LEVEL_FIELD_COMBINATIONS;
    public static final Set<Fields> DATA_FIELD_COMBINATIONS;
    private static final Logger LOG;

    @Override
    public Message deserialize(String json, Class<? extends Message> clazz, Object context) throws IOException {
        try {
            return this.deserializeHelper(json, context);
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
    }

    private Message deserializeHelper(String json, Object context) throws Exception {
        JSONObject jo = new JSONObject(json);
        if (!SchemaUtils.checkValidKeys(jo, FIRST_LEVEL_FIELD_COMBINATIONS)) {
            throw new IOException("Invalid keys");
        }
        String id = jo.getString("id");
        String type = jo.getString("type");
        if (!type.equals("dataQuery")) {
            LOG.error("Found type {} in the query json, but expected type {}.", (Object)type, (Object)"dataQuery");
            return null;
        }
        long countdown = -1L;
        boolean hasCountdown = jo.has("countdown");
        if (hasCountdown) {
            countdown = jo.getLong("countdown");
        }
        Map<String, String> schemaKeys = null;
        HashSet fieldsSet = Sets.newHashSet();
        if (jo.has("data")) {
            JSONObject data = jo.getJSONObject("data");
            if (!SchemaUtils.checkValidKeys(data, DATA_FIELD_COMBINATIONS)) {
                LOG.error("Error validating {} field", (Object)"data");
                throw new IOException("Invalid keys");
            }
            if (data.has("schemaKeys")) {
                schemaKeys = SchemaUtils.extractMap(data.getJSONObject("schemaKeys"));
            }
            if (data.has("fields")) {
                JSONArray jArray = data.getJSONArray("fields");
                for (int index = 0; index < jArray.length(); ++index) {
                    String field = jArray.getString(index);
                    if (fieldsSet.add(field)) continue;
                    LOG.error("The field {} was listed more than once, this is an invalid query.", (Object)field);
                }
            }
        }
        Fields fields = new Fields(fieldsSet);
        if (!hasCountdown) {
            return new DataQuerySnapshot(id, fields, schemaKeys);
        }
        return new DataQuerySnapshot(id, fields, countdown, schemaKeys);
    }

    static {
        HashSet firstLevelFieldCombinations = Sets.newHashSet();
        firstLevelFieldCombinations.add(new Fields(Sets.newHashSet((Object[])new String[]{"id", "type", "countdown", "data", "incompleteResultOK"})));
        firstLevelFieldCombinations.add(new Fields(Sets.newHashSet((Object[])new String[]{"id", "type", "data", "incompleteResultOK"})));
        firstLevelFieldCombinations.add(new Fields(Sets.newHashSet((Object[])new String[]{"id", "type", "countdown", "data"})));
        firstLevelFieldCombinations.add(new Fields(Sets.newHashSet((Object[])new String[]{"id", "type", "data"})));
        firstLevelFieldCombinations.add(new Fields(Sets.newHashSet((Object[])new String[]{"id", "type"})));
        FIRST_LEVEL_FIELD_COMBINATIONS = firstLevelFieldCombinations;
        HashSet dataFieldCombinations = Sets.newHashSet();
        dataFieldCombinations.add(new Fields(Sets.newHashSet((Object[])new String[]{"schemaKeys", "fields"})));
        dataFieldCombinations.add(new Fields(Sets.newHashSet((Object[])new String[]{"schemaKeys"})));
        dataFieldCombinations.add(new Fields(Sets.newHashSet((Object[])new String[]{"fields"})));
        DATA_FIELD_COMBINATIONS = dataFieldCombinations;
        LOG = LoggerFactory.getLogger(DataQuerySnapshotDeserializer.class);
    }
}

