/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.query.serde;

import com.datatorrent.lib.appdata.query.serde.CustomMessageValidator;
import com.datatorrent.lib.appdata.schemas.DataQuerySnapshot;
import com.datatorrent.lib.appdata.schemas.Fields;
import com.datatorrent.lib.appdata.schemas.Message;
import com.datatorrent.lib.appdata.schemas.SchemaRegistry;
import com.datatorrent.lib.appdata.schemas.SnapshotSchema;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataQuerySnapshotValidator
implements CustomMessageValidator {
    private static final Logger LOG = LoggerFactory.getLogger(DataQuerySnapshotValidator.class);

    @Override
    public boolean validate(Message query, Object context) {
        DataQuerySnapshot gdqt = (DataQuerySnapshot)query;
        SnapshotSchema schema = (SnapshotSchema)((SchemaRegistry)context).getSchema(gdqt.getSchemaKeys());
        Set<String> fields = schema.getValuesDescriptor().getFields().getFields();
        if (!fields.containsAll(gdqt.getFields().getFields())) {
            LOG.error("Some of the fields in the query {} are not one of the valid fields {}.", fields, gdqt.getFields().getFields());
            return false;
        }
        if (gdqt.getFields().getFields().isEmpty()) {
            gdqt.setFieldsVal(new Fields(fields));
        }
        return true;
    }
}

