/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.query.serde;

import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.gpo.GPOUtils;
import com.datatorrent.lib.appdata.query.serde.CustomMessageSerializer;
import com.datatorrent.lib.appdata.schemas.DataQuerySnapshot;
import com.datatorrent.lib.appdata.schemas.DataResultSnapshot;
import com.datatorrent.lib.appdata.schemas.Message;
import com.datatorrent.lib.appdata.schemas.ResultFormatter;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataResultSnapshotSerializer
implements CustomMessageSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(DataResultSnapshotSerializer.class);

    @Override
    public String serialize(Message result, ResultFormatter resultFormatter) {
        try {
            return this.serializeHelper(result, resultFormatter);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String serializeHelper(Message result, ResultFormatter resultFormatter) throws Exception {
        DataResultSnapshot gResult = (DataResultSnapshot)result;
        JSONObject jo = new JSONObject();
        jo.put("id", (Object)gResult.getId());
        jo.put("type", (Object)gResult.getType());
        JSONArray ja = new JSONArray();
        for (GPOMutable value : gResult.getValues()) {
            JSONObject dataValue = GPOUtils.serializeJSONObject(value, ((DataQuerySnapshot)gResult.getQuery()).getFields(), resultFormatter);
            ja.put((Object)dataValue);
        }
        jo.put("data", (Object)ja);
        if (!gResult.isOneTime()) {
            jo.put("countdown", gResult.getCountdown());
        }
        return jo.toString();
    }
}

