/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.query.serde;

import com.datatorrent.lib.appdata.query.serde.CustomMessageDeserializer;
import com.datatorrent.lib.appdata.query.serde.CustomMessageValidator;
import com.datatorrent.lib.appdata.query.serde.MessageDeserializerInfo;
import com.datatorrent.lib.appdata.query.serde.MessageType;
import com.datatorrent.lib.appdata.query.serde.MessageValidatorInfo;
import com.datatorrent.lib.appdata.schemas.Message;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDeserializerFactory {
    private final Map<String, Class<? extends Message>> typeToClass = Maps.newHashMap();
    private final Map<String, CustomMessageDeserializer> typeToCustomQueryBuilder = Maps.newHashMap();
    private final Map<String, CustomMessageValidator> typeToCustomQueryValidator = Maps.newHashMap();
    private final Map<Class<? extends Message>, Object> deserializationContext = Maps.newHashMap();
    private static final Logger LOG = LoggerFactory.getLogger(MessageDeserializerFactory.class);

    public MessageDeserializerFactory(Class<? extends Message> ... schemas) {
        this.setClasses(schemas);
    }

    public void setContext(Class<? extends Message> clazz, Object context) {
        this.deserializationContext.put(clazz, context);
    }

    private void setClasses(Class<? extends Message>[] schemas) {
        Preconditions.checkArgument((schemas.length != 0 ? 1 : 0) != 0, (Object)"No schemas provided.");
        HashSet clazzes = Sets.newHashSet();
        for (Class<? extends Message> schema : schemas) {
            Preconditions.checkNotNull(schema, (Object)"Provided schema cannot be null");
            Preconditions.checkArgument((!clazzes.contains(schema) ? 1 : 0) != 0, (String)"Schema %s was passed twice.", (Object[])new Object[]{schema});
            clazzes.add(schema);
            Annotation[] ans = schema.getAnnotations();
            String schemaType = null;
            Class<? extends CustomMessageDeserializer> cqd = null;
            Class<? extends CustomMessageValidator> cqv = null;
            for (Annotation an : ans) {
                if (an instanceof MessageType) {
                    if (schemaType != null) {
                        throw new IllegalArgumentException("Cannot specify the " + MessageType.class + " annotation twice on the class: " + schema);
                    }
                    schemaType = ((MessageType)an).type();
                    LOG.debug("Detected schemaType for {} is {}", schema, (Object)schemaType);
                    continue;
                }
                if (an instanceof MessageDeserializerInfo) {
                    if (cqd != null) {
                        throw new IllegalArgumentException("Cannot specify the " + MessageDeserializerInfo.class + " annotation twice on the class: " + schema);
                    }
                    cqd = ((MessageDeserializerInfo)an).clazz();
                    continue;
                }
                if (!(an instanceof MessageValidatorInfo)) continue;
                if (cqv != null) {
                    throw new IllegalArgumentException("Cannot specify the " + MessageValidatorInfo.class + " annotation twice on the class: ");
                }
                cqv = ((MessageValidatorInfo)an).clazz();
            }
            if (schemaType == null) {
                throw new IllegalArgumentException("No " + MessageType.class + " annotation found on class: " + schema);
            }
            if (cqd == null) {
                throw new IllegalArgumentException("No " + MessageDeserializerInfo.class + " annotation found on class: " + schema);
            }
            if (cqv == null) {
                throw new IllegalArgumentException("No " + MessageValidatorInfo.class + " annotation found on class: " + schema);
            }
            Class<? extends Message> prevSchema = this.typeToClass.put(schemaType, schema);
            LOG.debug("prevSchema {}:", prevSchema);
            if (prevSchema != null) {
                throw new IllegalArgumentException("Cannot have the " + schemaType + " schemaType defined on multiple classes: " + schema + ", " + prevSchema);
            }
            try {
                CustomMessageDeserializer cqdI = cqd.newInstance();
                CustomMessageValidator cqvI = cqv.newInstance();
                this.typeToCustomQueryBuilder.put(schemaType, cqdI);
                this.typeToCustomQueryValidator.put(schemaType, cqvI);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public Message deserialize(String json) throws IOException {
        String type;
        try {
            JSONObject jsonObject = new JSONObject(json);
            type = jsonObject.getString("type");
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        CustomMessageDeserializer cqb = this.typeToCustomQueryBuilder.get(type);
        if (cqb == null) {
            throw new IOException("The query type " + type + " does not have a corresponding deserializer.");
        }
        CustomMessageValidator cqv = this.typeToCustomQueryValidator.get(type);
        Object context = this.deserializationContext.get(this.typeToClass.get(type));
        Message data = cqb.deserialize(json, this.typeToClass.get(type), context);
        LOG.debug("{}", (Object)data);
        if (data == null || cqv == null || !cqv.validate(data, context)) {
            return null;
        }
        data.setType(type);
        return data;
    }
}

