/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.query.serde;

import com.datatorrent.lib.appdata.query.serde.CustomMessageSerializer;
import com.datatorrent.lib.appdata.query.serde.MessageSerializerInfo;
import com.datatorrent.lib.appdata.query.serde.MessageType;
import com.datatorrent.lib.appdata.schemas.Result;
import com.datatorrent.lib.appdata.schemas.ResultFormatter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSerializerFactory {
    private final Map<Class<? extends Result>, CustomMessageSerializer> clazzToCustomResultBuilder = Maps.newHashMap();
    private final Map<Class<? extends Result>, String> clazzToType = Maps.newHashMap();
    private ResultFormatter resultFormatter = new ResultFormatter();
    private static final Logger LOG = LoggerFactory.getLogger(MessageSerializerFactory.class);

    public MessageSerializerFactory(ResultFormatter resultFormatter) {
        this.setResultFormatter(resultFormatter);
    }

    private void setResultFormatter(ResultFormatter resultFormatter) {
        this.resultFormatter = (ResultFormatter)Preconditions.checkNotNull((Object)resultFormatter);
    }

    public ResultFormatter getResultFormatter() {
        return this.resultFormatter;
    }

    public String serialize(Result result) {
        CustomMessageSerializer mcrs = this.clazzToCustomResultBuilder.get(result.getClass());
        Class<?> schema = result.getClass();
        if (mcrs == null) {
            Annotation[] ans = schema.getAnnotations();
            Class<? extends CustomMessageSerializer> crs = null;
            String type = null;
            for (Annotation an : ans) {
                if (an instanceof MessageSerializerInfo) {
                    if (crs != null) {
                        throw new UnsupportedOperationException("Cannot specify the " + MessageSerializerInfo.class + " annotation twice on the class: " + schema);
                    }
                    crs = ((MessageSerializerInfo)an).clazz();
                    continue;
                }
                if (!(an instanceof MessageType)) continue;
                if (type != null) {
                    throw new UnsupportedOperationException("Cannot specify the " + MessageType.class + " annotation twice on the class: " + schema);
                }
                type = ((MessageType)an).type();
            }
            if (crs == null) {
                throw new UnsupportedOperationException("No " + MessageSerializerInfo.class + " annotation found on class: " + schema);
            }
            if (type == null) {
                throw new UnsupportedOperationException("No " + MessageType.class + " annotation found on class " + schema);
            }
            try {
                mcrs = (CustomMessageSerializer)crs.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            this.clazzToCustomResultBuilder.put(schema, mcrs);
            this.clazzToType.put(schema, type);
        }
        result.setType(this.clazzToType.get(schema));
        return mcrs.serialize(result, this.resultFormatter);
    }
}

