/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.query.serde;

import com.datatorrent.lib.appdata.query.serde.CustomMessageDeserializer;
import com.datatorrent.lib.appdata.schemas.Message;
import com.datatorrent.lib.appdata.schemas.SchemaQuery;
import com.datatorrent.lib.appdata.schemas.SchemaUtils;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaQueryDeserializer
implements CustomMessageDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaQueryDeserializer.class);

    @Override
    public Message deserialize(String json, Class<? extends Message> message, Object context) throws IOException {
        try {
            return this.deserializeHelper(json, message, context);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Message deserializeHelper(String json, Class<? extends Message> message, Object context) throws Exception {
        JSONObject schemaJO = new JSONObject(json);
        String type = schemaJO.getString("type");
        if (!type.equals("schemaQuery")) {
            LOG.error("The given type {} is invalid.", (Object)type);
            return null;
        }
        String id = schemaJO.getString("id");
        Map<String, String> contextKeysMap = null;
        Map<String, String> schemaKeysMap = null;
        if (schemaJO.has("context")) {
            JSONObject schemaKeys;
            JSONObject keys;
            JSONObject contextJO = schemaJO.getJSONObject("context");
            if (contextJO.length() == 0) {
                LOG.error("The context cannot be empty");
                return null;
            }
            if (contextJO.has("keys") && (contextKeysMap = SchemaUtils.extractMap(keys = contextJO.getJSONObject("keys"))).isEmpty()) {
                contextKeysMap = null;
            }
            if (contextJO.has("schemaKeys") && (schemaKeysMap = SchemaUtils.extractMap(schemaKeys = contextJO.getJSONObject("schemaKeys"))).isEmpty()) {
                schemaKeysMap = null;
            }
        }
        SchemaQuery sq = new SchemaQuery(id, schemaKeysMap, contextKeysMap);
        return sq;
    }
}

