/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.schemas.TimeBucket;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomTimeBucket
implements Serializable,
Comparable<CustomTimeBucket> {
    private static final long serialVersionUID = 201509221545L;
    public static final String TIME_BUCKET_NAME_REGEX = "(\\d+)([a-zA-Z]+)";
    public static final Pattern TIME_BUCKET_NAME_PATTERN = Pattern.compile("(\\d+)([a-zA-Z]+)");
    private TimeBucket timeBucket;
    private long count;
    private String text;
    private long numMillis;

    private CustomTimeBucket() {
    }

    public CustomTimeBucket(String timeBucketText) {
        if (timeBucketText.equals(TimeBucket.ALL.getText())) {
            this.initialize(TimeBucket.ALL, 0L);
        } else {
            Matcher matcher = TIME_BUCKET_NAME_PATTERN.matcher(timeBucketText);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("The given text for the variable time bucket " + timeBucketText + " does not match the regex for a variable time bucket " + TIME_BUCKET_NAME_REGEX);
            }
            String amountString = matcher.group(1);
            long amount = Long.parseLong(amountString);
            String suffix = matcher.group(2);
            TimeBucket timeBucket = TimeBucket.getTimeBucketForSuffixEx(suffix);
            this.initialize(timeBucket, amount);
        }
    }

    public CustomTimeBucket(TimeBucket timeBucket, long count) {
        this.initialize(timeBucket, count);
    }

    public CustomTimeBucket(TimeBucket timeBucket) {
        if (timeBucket == TimeBucket.ALL) {
            this.initialize(timeBucket, 0L);
        } else {
            this.initialize(timeBucket, 1L);
        }
    }

    private void initialize(TimeBucket timeBucket, long count) {
        this.timeBucket = (TimeBucket)((Object)Preconditions.checkNotNull((Object)((Object)timeBucket)));
        this.count = count;
        if (timeBucket != TimeBucket.ALL) {
            Preconditions.checkArgument((count > 0L ? 1 : 0) != 0, (Object)"The TimeBucket cannot be ALL.");
        } else {
            Preconditions.checkArgument((count == 0L ? 1 : 0) != 0, (Object)"The count must be zero for the all TimeBucket.");
        }
        if (timeBucket != TimeBucket.ALL) {
            this.text = count + timeBucket.getSuffix();
            this.numMillis = timeBucket.getTimeUnit().toMillis(1L) * count;
        } else {
            this.text = TimeBucket.ALL.getText();
        }
    }

    public boolean isUnit() {
        return this.count == 1L;
    }

    public TimeBucket getTimeBucket() {
        return this.timeBucket;
    }

    public long getCount() {
        return this.count;
    }

    public long getNumMillis() {
        return this.numMillis;
    }

    public long toMillis(long multCount) {
        return this.numMillis * multCount;
    }

    public long roundDown(long timestamp) {
        if (this.timeBucket == TimeBucket.ALL) {
            return 0L;
        }
        return timestamp / this.numMillis * this.numMillis;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        if (this.timeBucket == TimeBucket.ALL) {
            return TimeBucket.ALL.getText();
        }
        return this.count + this.timeBucket.getSuffix();
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode((Object)this.timeBucket);
        hash = 97 * hash + (int)(this.count ^ this.count >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomTimeBucket other = (CustomTimeBucket)obj;
        if (this.timeBucket != other.timeBucket) {
            return false;
        }
        return this.count == other.count;
    }

    @Override
    public int compareTo(CustomTimeBucket other) {
        if (this.numMillis < other.numMillis) {
            return -1;
        }
        if (this.numMillis == other.numMillis) {
            return 0;
        }
        return 1;
    }
}

