/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.schemas.CustomTimeBucket;
import com.datatorrent.lib.appdata.schemas.Fields;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.SchemaUtils;
import com.datatorrent.lib.appdata.schemas.TimeBucket;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.apex.malhar.lib.dimensions.CustomTimeBucketRegistry;
import org.apache.apex.malhar.lib.dimensions.DimensionsDescriptor;
import org.apache.apex.malhar.lib.dimensions.aggregator.AbstractCompositeAggregator;
import org.apache.apex.malhar.lib.dimensions.aggregator.AbstractTopBottomAggregator;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorRegistry;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorUtils;
import org.apache.apex.malhar.lib.dimensions.aggregator.CompositeAggregator;
import org.apache.apex.malhar.lib.dimensions.aggregator.CompositeAggregatorFactory;
import org.apache.apex.malhar.lib.dimensions.aggregator.DefaultCompositeAggregatorFactory;
import org.apache.apex.malhar.lib.dimensions.aggregator.IncrementalAggregator;
import org.apache.apex.malhar.lib.dimensions.aggregator.OTFAggregator;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionalConfigurationSchema {
    public static final int STARTING_TIMEBUCKET_ID = 256;
    public static final String ADDITIONAL_VALUE_SEPERATOR = ":";
    public static final int ADDITIONAL_VALUE_NUM_COMPONENTS = 2;
    public static final int ADDITIONAL_VALUE_VALUE_INDEX = 0;
    public static final int ADDITIONAL_VALUE_AGGREGATOR_INDEX = 1;
    public static final String FIELD_KEYS = "keys";
    public static final String FIELD_KEYS_NAME = "name";
    public static final String FIELD_KEYS_TYPE = "type";
    public static final String FIELD_KEYS_EXPRESSION = "expression";
    public static final String FIELD_KEYS_ENUMVALUES = "enumValues";
    public static final List<Fields> VALID_KEY_FIELDS = ImmutableList.of((Object)new Fields(Sets.newHashSet((Object[])new String[]{"name", "type", "enumValues"})), (Object)new Fields(Sets.newHashSet((Object[])new String[]{"name", "type"})));
    public static final String FIELD_TIME_BUCKETS = "timeBuckets";
    public static final String FIELD_VALUES = "values";
    public static final String FIELD_VALUES_NAME = "name";
    public static final String FIELD_VALUES_TYPE = "type";
    public static final String FIELD_VALUES_EXPRESSION = "expression";
    public static final String FIELD_VALUES_AGGREGATIONS = "aggregators";
    private static final String FIELD_TAGS = "tags";
    public static final String FIELD_VALUES_AGGREGATOR = "aggregator";
    public static final String PROPERTY_NAME_EMBEDED_AGGREGATOR = "embededAggregator";
    public static final String PROPERTY_NAME_COUNT = "count";
    public static final String PROPERTY_NAME_SUB_COMBINATIONS = "subCombinations";
    public static final String FIELD_DIMENSIONS = "dimensions";
    public static final String FIELD_DIMENSIONS_ALL_COMBINATIONS = "ALL_COMBINATIONS";
    public static final String FIELD_DIMENSIONS_COMBINATIONS = "combination";
    public static final String FIELD_DIMENSIONS_ADDITIONAL_VALUES = "additionalValues";
    public static final String FIELD_DIMENSIONS_TIME_BUCKETS = "timeBuckets";
    private FieldsDescriptor keyDescriptor;
    private FieldsDescriptor keyDescriptorWithTime;
    private FieldsDescriptor inputValuesDescriptor;
    private Map<String, List<Object>> keysToEnumValuesList;
    private List<FieldsDescriptor> dimensionsDescriptorIDToKeyDescriptor;
    private List<DimensionsDescriptor> dimensionsDescriptorIDToDimensionsDescriptor;
    private List<Map<String, Set<String>>> dimensionsDescriptorIDToValueToAggregator;
    private List<Map<String, Set<String>>> dimensionsDescriptorIDToValueToOTFAggregator;
    private List<Map<String, Set<String>>> dimensionsDescriptorIDToValueToCompositeAggregator;
    private List<Map<String, FieldsDescriptor>> dimensionsDescriptorIDToAggregatorToAggregateDescriptor;
    private List<Map<String, FieldsDescriptor>> dimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor;
    private List<Map<String, FieldsDescriptor>> dimensionsDescriptorIDToCompositeAggregatorToAggregateDescriptor;
    private Map<DimensionsDescriptor, Integer> dimensionsDescriptorToID;
    private List<Int2ObjectMap<FieldsDescriptor>> dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor;
    private List<Int2ObjectMap<FieldsDescriptor>> dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor;
    private List<IntArrayList> dimensionsDescriptorIDToIncrementalAggregatorIDs;
    private List<IntArrayList> dimensionsDescriptorIDToCompositeAggregatorIDs;
    private List<Map<String, Set<String>>> dimensionsDescriptorIDToFieldToAggregatorAdditionalValues;
    private List<Fields> dimensionsDescriptorIDToKeys;
    private String keysString;
    private String bucketsString;
    private AggregatorRegistry aggregatorRegistry;
    private List<TimeBucket> timeBuckets;
    private List<CustomTimeBucket> customTimeBuckets;
    private Map<String, Map<String, Type>> schemaAllValueToAggregatorToType;
    private Map<String, List<String>> keyToTags;
    private Map<String, List<String>> valueToTags;
    private List<String> tags;
    protected Map<String, Map<String, String>> aggregatorToProperty;
    protected List<CustomTimeBucket> customTimeBucketsCombination;
    private CustomTimeBucketRegistry customTimeBucketRegistry;
    protected CompositeAggregatorFactory compositeAggregatorFactory = DefaultCompositeAggregatorFactory.defaultInst;
    protected static final String[] COMPOSITE_AGGREGATORS = new String[]{"TOPN", "BOTTOMN"};
    protected static final Map<String, Set<String>> aggregatorToPropertiesMap = Maps.newHashMap();
    private Map<String, String> keyToExpression = Maps.newHashMap();
    private Map<String, String> valueToExpression = Maps.newHashMap();
    private static final Logger LOG;

    private DimensionalConfigurationSchema() {
    }

    public DimensionalConfigurationSchema(List<Key> keys, List<Value> values, List<TimeBucket> timeBuckets, List<DimensionsCombination> dimensionsCombinations, AggregatorRegistry aggregatorRegistry) {
        this.setAggregatorRegistry(aggregatorRegistry);
        this.initialize(keys, values, timeBuckets, dimensionsCombinations);
    }

    public DimensionalConfigurationSchema(String json, AggregatorRegistry aggregatorRegistry) {
        this.setAggregatorRegistry(aggregatorRegistry);
        try {
            this.initialize(json);
        }
        catch (JSONException ex) {
            LOG.error("{}", (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private void setAggregatorRegistry(AggregatorRegistry aggregatorRegistry) {
        this.aggregatorRegistry = (AggregatorRegistry)Preconditions.checkNotNull((Object)aggregatorRegistry);
    }

    public AggregatorRegistry getAggregatorRegistry() {
        return this.aggregatorRegistry;
    }

    private List<Map<String, FieldsDescriptor>> computeAggregatorToAggregateDescriptor(List<Map<String, Set<String>>> ddIDToValueToAggregator) {
        ArrayList tempDdIDToAggregatorToAggregateDescriptor = Lists.newArrayList();
        for (int ddID = 0; ddID < ddIDToValueToAggregator.size(); ++ddID) {
            Map<String, Set<String>> valueToAggregator = ddIDToValueToAggregator.get(ddID);
            HashMap aggregatorToValues = Maps.newHashMap();
            for (Map.Entry<String, Set<String>> entry : valueToAggregator.entrySet()) {
                String value = entry.getKey();
                for (String aggregator : entry.getValue()) {
                    Set values = (Set)aggregatorToValues.get(aggregator);
                    if (values == null) {
                        values = Sets.newHashSet();
                        aggregatorToValues.put(aggregator, values);
                    }
                    values.add(value);
                }
            }
            HashMap aggregatorToValuesDescriptor = Maps.newHashMap();
            for (Map.Entry entry : aggregatorToValues.entrySet()) {
                String aggregatorName = (String)entry.getKey();
                if (this.isCompositeAggregator(aggregatorName)) {
                    aggregatorToValuesDescriptor.put(aggregatorName, AggregatorUtils.getOutputFieldsDescriptor(this.inputValuesDescriptor.getSubset(new Fields((Collection)entry.getValue())), this.getCompositeAggregatorByName(aggregatorName)));
                    continue;
                }
                aggregatorToValuesDescriptor.put(aggregatorName, this.inputValuesDescriptor.getSubset(new Fields((Collection)entry.getValue())));
            }
            tempDdIDToAggregatorToAggregateDescriptor.add(aggregatorToValuesDescriptor);
        }
        return tempDdIDToAggregatorToAggregateDescriptor;
    }

    private void initialize(List<Key> keys, List<Value> values, List<TimeBucket> timeBuckets, List<DimensionsCombination> dimensionsCombinations) {
        Set<Object> ddAggregatorSet;
        Set aggName;
        String valueName;
        this.tags = Lists.newArrayList();
        this.keyToTags = Maps.newHashMap();
        for (Key key : keys) {
            this.keyToTags.put(key.getName(), new ArrayList());
        }
        this.valueToTags = Maps.newHashMap();
        for (Value value : values) {
            this.valueToTags.put(value.getName(), new ArrayList());
        }
        this.timeBuckets = timeBuckets;
        this.customTimeBuckets = new ArrayList<CustomTimeBucket>();
        this.customTimeBucketRegistry = new CustomTimeBucketRegistry(256);
        for (TimeBucket timeBucket : timeBuckets) {
            CustomTimeBucket customTimeBucket = new CustomTimeBucket(timeBucket);
            this.customTimeBuckets.add(customTimeBucket);
            this.customTimeBucketRegistry.register(customTimeBucket, timeBucket.ordinal());
        }
        HashMap valueFieldToType = Maps.newHashMap();
        for (Value value : values) {
            valueFieldToType.put(value.getName(), value.getType());
        }
        this.inputValuesDescriptor = new FieldsDescriptor(valueFieldToType);
        HashMap keyFieldToType = Maps.newHashMap();
        this.keysToEnumValuesList = Maps.newHashMap();
        for (Key key : keys) {
            keyFieldToType.put(key.getName(), key.getType());
            this.keysToEnumValuesList.put(key.getName(), key.getEnumValues());
        }
        this.keyDescriptor = new FieldsDescriptor(keyFieldToType);
        HashMap fieldToTypeWithTime = Maps.newHashMap((Map)keyFieldToType);
        this.keyDescriptorWithTime = this.keyDescriptorWithTime(fieldToTypeWithTime, this.customTimeBuckets);
        this.schemaAllValueToAggregatorToType = Maps.newHashMap();
        HashMap specificValueToAggregator = Maps.newHashMap();
        HashMap specificValueToOTFAggregator = Maps.newHashMap();
        HashMap allSpecificValueToAggregator = Maps.newHashMap();
        for (Value value : values) {
            String string = value.getName();
            Set<String> aggregators = value.getAggregators();
            HashSet hashSet = Sets.newHashSet();
            HashSet allAggregatorSet = Sets.newHashSet();
            HashSet otfAggregators = Sets.newHashSet();
            for (String aggregatorName : aggregators) {
                if (this.aggregatorRegistry.isIncrementalAggregator(aggregatorName)) {
                    hashSet.add(aggregatorName);
                    allAggregatorSet.add(aggregatorName);
                    continue;
                }
                otfAggregators.add(aggregatorName);
                List<String> aggregatorNames = this.aggregatorRegistry.getOTFAggregatorToIncrementalAggregators().get(aggregatorName);
                hashSet.addAll(aggregatorNames);
                allAggregatorSet.addAll(aggregatorNames);
                allAggregatorSet.add(aggregatorName);
            }
            specificValueToOTFAggregator.put(string, otfAggregators);
            specificValueToAggregator.put(string, hashSet);
            allSpecificValueToAggregator.put(string, allAggregatorSet);
        }
        for (Map.Entry entry : allSpecificValueToAggregator.entrySet()) {
            String string = (String)entry.getKey();
            Type inputType = this.inputValuesDescriptor.getType(string);
            Set set = (Set)entry.getValue();
            HashMap aggregatorToType = Maps.newHashMap();
            for (String aggregatorName : set) {
                if (this.aggregatorRegistry.isIncrementalAggregator(aggregatorName)) {
                    IncrementalAggregator aggregator = this.aggregatorRegistry.getNameToIncrementalAggregator().get(aggregatorName);
                    aggregatorToType.put(aggregatorName, aggregator.getOutputType(inputType));
                    continue;
                }
                OTFAggregator otfAggregator = this.aggregatorRegistry.getNameToOTFAggregators().get(aggregatorName);
                aggregatorToType.put(aggregatorName, otfAggregator.getOutputType());
            }
            this.schemaAllValueToAggregatorToType.put(string, aggregatorToType);
        }
        this.dimensionsDescriptorIDToDimensionsDescriptor = Lists.newArrayList();
        this.dimensionsDescriptorIDToKeyDescriptor = Lists.newArrayList();
        this.dimensionsDescriptorToID = Maps.newHashMap();
        this.dimensionsDescriptorIDToValueToAggregator = Lists.newArrayList();
        this.dimensionsDescriptorIDToValueToOTFAggregator = Lists.newArrayList();
        int ddID = 0;
        for (DimensionsCombination dimensionsCombination : dimensionsCombinations) {
            for (TimeBucket timeBucket : timeBuckets) {
                DimensionsDescriptor dd = new DimensionsDescriptor(timeBucket, dimensionsCombination.getFields());
                this.dimensionsDescriptorIDToDimensionsDescriptor.add(dd);
                this.dimensionsDescriptorIDToKeyDescriptor.add(dd.createFieldsDescriptor(this.keyDescriptor));
                this.dimensionsDescriptorToID.put(dd, ddID);
                HashMap valueToAggregator = Maps.newHashMap();
                HashMap valueToOTFAggregator = Maps.newHashMap();
                Map<String, Set<String>> tempValueToAggregator = dimensionsCombination.getValueToAggregators();
                for (Map.Entry<String, Set<String>> entry : tempValueToAggregator.entrySet()) {
                    String value = entry.getKey();
                    HashSet staticAggregatorNames = Sets.newHashSet();
                    HashSet otfAggregatorNames = Sets.newHashSet();
                    Set<String> aggregatorNames = entry.getValue();
                    for (String aggregatorName : aggregatorNames) {
                        if (!this.aggregatorRegistry.isAggregator(aggregatorName)) {
                            throw new UnsupportedOperationException("The aggregator " + aggregatorName + " is not valid.");
                        }
                        if (this.aggregatorRegistry.isIncrementalAggregator(aggregatorName)) {
                            staticAggregatorNames.add(aggregatorName);
                            continue;
                        }
                        staticAggregatorNames.addAll((Collection)this.aggregatorRegistry.getOTFAggregatorToIncrementalAggregators().get(aggregatorName));
                        otfAggregatorNames.add(aggregatorName);
                    }
                    valueToAggregator.put(value, staticAggregatorNames);
                    valueToOTFAggregator.put(value, otfAggregatorNames);
                }
                this.mergeMaps(valueToAggregator, specificValueToAggregator);
                this.mergeMaps(valueToOTFAggregator, specificValueToOTFAggregator);
                this.dimensionsDescriptorIDToValueToAggregator.add(valueToAggregator);
                this.dimensionsDescriptorIDToValueToOTFAggregator.add(valueToOTFAggregator);
                ++ddID;
            }
        }
        for (Map<String, Set<String>> map : this.dimensionsDescriptorIDToValueToAggregator) {
            if (specificValueToAggregator.isEmpty()) continue;
            for (Map.Entry entry : specificValueToAggregator.entrySet()) {
                valueName = (String)entry.getKey();
                aggName = (Set)entry.getValue();
                if (aggName.isEmpty()) continue;
                ddAggregatorSet = map.get(valueName);
                if (ddAggregatorSet == null) {
                    ddAggregatorSet = Sets.newHashSet();
                    map.put(valueName, (Set<String>)ddAggregatorSet);
                }
                ddAggregatorSet.addAll(aggName);
            }
        }
        for (Map<String, Set<String>> map : this.dimensionsDescriptorIDToValueToOTFAggregator) {
            if (specificValueToOTFAggregator.isEmpty()) continue;
            for (Map.Entry entry : specificValueToOTFAggregator.entrySet()) {
                valueName = (String)entry.getKey();
                aggName = (Set)entry.getValue();
                if (aggName.isEmpty()) continue;
                ddAggregatorSet = map.get(valueName);
                if (ddAggregatorSet == null) {
                    ddAggregatorSet = Sets.newHashSet();
                    map.put(valueName, ddAggregatorSet);
                }
                ddAggregatorSet.addAll(aggName);
            }
        }
        this.dimensionsDescriptorIDToAggregatorToAggregateDescriptor = this.computeAggregatorToAggregateDescriptor(this.dimensionsDescriptorIDToValueToAggregator);
        this.dimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor = this.computeAggregatorToAggregateDescriptor(this.dimensionsDescriptorIDToValueToOTFAggregator);
        this.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues = Lists.newArrayList();
        this.dimensionsDescriptorIDToKeys = Lists.newArrayList();
        for (DimensionsCombination dimensionsCombination : dimensionsCombinations) {
            this.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues.add(dimensionsCombination.getValueToAggregators());
            this.dimensionsDescriptorIDToKeys.add(dimensionsCombination.getFields());
        }
        JSONArray jSONArray = new JSONArray();
        for (Key key : keys) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("name", (Object)key.getName());
                jSONObject.put("type", (Object)key.getType().getName());
                JSONArray enumArray = new JSONArray();
                for (Object enumVal : key.getEnumValues()) {
                    enumArray.put(enumVal);
                }
                jSONObject.put(FIELD_KEYS_ENUMVALUES, (Object)enumArray);
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
            jSONArray.put((Object)jSONObject);
        }
        this.keysString = jSONArray.toString();
        JSONArray jSONArray2 = new JSONArray();
        for (CustomTimeBucket customTimeBucket : this.customTimeBuckets) {
            jSONArray2.put((Object)customTimeBucket.getText());
        }
        this.bucketsString = jSONArray2.toString();
        this.dimensionsDescriptorIDToCompositeAggregatorToAggregateDescriptor = Lists.newArrayList();
        this.buildDimensionsDescriptorIDAggregatorIDMaps();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize(String json) throws JSONException {
        JSONArray dimensionsArray;
        Object aggregators;
        JSONArray timeBucketsJSON;
        JSONObject jo = new JSONObject(json);
        this.tags = this.getTags(jo);
        this.keysToEnumValuesList = Maps.newHashMap();
        JSONArray keysArray = jo.has(FIELD_KEYS) ? jo.getJSONArray(FIELD_KEYS) : new JSONArray();
        this.keysString = keysArray.toString();
        this.keyToTags = Maps.newHashMap();
        HashMap fieldToType = Maps.newHashMap();
        for (int keyIndex = 0; keyIndex < keysArray.length(); ++keyIndex) {
            JSONObject tempKeyDescriptor = keysArray.getJSONObject(keyIndex);
            SchemaUtils.checkValidKeysEx(tempKeyDescriptor, VALID_KEY_FIELDS);
            String keyName = tempKeyDescriptor.getString("name");
            String typeName = tempKeyDescriptor.getString("type");
            try {
                String keyExpression = tempKeyDescriptor.getString("expression");
                if (keyExpression != null) {
                    this.keyToExpression.put(keyName, keyExpression);
                }
            }
            catch (JSONException keyExpression) {
                // empty catch block
            }
            List<String> keyTags = this.getTags(tempKeyDescriptor);
            this.keyToTags.put(keyName, keyTags);
            Type type = Type.getTypeEx(typeName);
            fieldToType.put(keyName, type);
            ArrayList valuesList = Lists.newArrayList();
            this.keysToEnumValuesList.put(keyName, valuesList);
            if (!tempKeyDescriptor.has(FIELD_KEYS_ENUMVALUES)) continue;
            Type maxType = null;
            JSONArray valArray = tempKeyDescriptor.getJSONArray(FIELD_KEYS_ENUMVALUES);
            for (int valIndex = 0; valIndex < valArray.length(); ++valIndex) {
                Object val = valArray.get(valIndex);
                valuesList.add(val);
                Preconditions.checkState((!(val instanceof JSONArray) && !(val instanceof JSONObject) ? 1 : 0) != 0, (Object)"The value must be a primitive.");
                Type currentType = Type.CLASS_TO_TYPE.get(val.getClass());
                if (maxType == null) {
                    maxType = currentType;
                    continue;
                }
                if (maxType == currentType) continue;
                if (maxType.getHigherTypes().contains(currentType)) {
                    maxType = currentType;
                    continue;
                }
                Preconditions.checkState((boolean)currentType.getHigherTypes().contains(maxType), (Object)("Conficting types: " + currentType.getName() + " cannot be converted to " + maxType.getName()));
            }
            if (Type.areRelated(maxType, type)) continue;
            throw new IllegalArgumentException("The type of the values in " + valArray + " is " + maxType.getName() + " while the specified type is " + type.getName());
        }
        this.timeBuckets = Lists.newArrayList();
        this.customTimeBuckets = Lists.newArrayList();
        if (!jo.has("timeBuckets")) {
            timeBucketsJSON = new JSONArray();
            timeBucketsJSON.put((Object)TimeBucket.ALL.getText());
        } else {
            timeBucketsJSON = jo.getJSONArray("timeBuckets");
            if (timeBucketsJSON.length() == 0) {
                throw new IllegalArgumentException("A time bucket must be specified.");
            }
        }
        this.customTimeBucketRegistry = new CustomTimeBucketRegistry(256);
        HashSet customTimeBucketsAllSet = Sets.newHashSet();
        ArrayList customTimeBucketsAll = Lists.newArrayList();
        HashSet customTimeBucketsTotalSet = Sets.newHashSet();
        for (int timeBucketIndex = 0; timeBucketIndex < timeBucketsJSON.length(); ++timeBucketIndex) {
            String timeBucketString = timeBucketsJSON.getString(timeBucketIndex);
            CustomTimeBucket customTimeBucket = new CustomTimeBucket(timeBucketString);
            if (!customTimeBucketsAllSet.add(customTimeBucket)) {
                throw new IllegalArgumentException("The bucket " + customTimeBucket.getText() + " was defined twice.");
            }
            customTimeBucketsAll.add(customTimeBucket);
            this.customTimeBuckets.add(customTimeBucket);
            if (!customTimeBucket.isUnit() && customTimeBucket.getTimeBucket() != TimeBucket.ALL) continue;
            this.timeBuckets.add(customTimeBucket.getTimeBucket());
        }
        customTimeBucketsTotalSet.addAll(customTimeBucketsAllSet);
        JSONArray customTimeBucketsJSON = new JSONArray();
        for (CustomTimeBucket customTimeBucket : this.customTimeBuckets) {
            customTimeBucketsJSON.put((Object)customTimeBucket.toString());
        }
        this.bucketsString = customTimeBucketsJSON.toString();
        this.keyDescriptor = new FieldsDescriptor(fieldToType);
        HashMap fieldToTypeWithTime = Maps.newHashMap((Map)fieldToType);
        this.keyDescriptorWithTime = this.keyDescriptorWithTime(fieldToTypeWithTime, this.customTimeBuckets);
        HashMap allValueToAggregator = Maps.newHashMap();
        HashMap allValueToOTFAggregator = Maps.newHashMap();
        HashMap valueToAggregators = Maps.newHashMap();
        HashMap valueToOTFAggregators = Maps.newHashMap();
        HashMap allValueToCompositeAggregator = Maps.newHashMap();
        HashMap valueToCompositeAggregators = Maps.newHashMap();
        HashMap aggFieldToType = Maps.newHashMap();
        JSONArray valuesArray = jo.getJSONArray(FIELD_VALUES);
        this.schemaAllValueToAggregatorToType = Maps.newHashMap();
        this.valueToTags = Maps.newHashMap();
        for (int valueIndex = 0; valueIndex < valuesArray.length(); ++valueIndex) {
            JSONObject value = valuesArray.getJSONObject(valueIndex);
            String name = value.getString("name");
            String type = value.getString("type");
            try {
                String valueExpression = value.getString("expression");
                if (valueExpression != null) {
                    this.valueToExpression.put(name, valueExpression);
                }
            }
            catch (JSONException valueExpression) {
                // empty catch block
            }
            List<String> valueTags = this.getTags(value);
            this.valueToTags.put(name, valueTags);
            Type typeT = Type.NAME_TO_TYPE.get(type);
            if (aggFieldToType.containsKey(name)) {
                throw new IllegalArgumentException("Cannot define the value " + name + " twice.");
            }
            HashMap aggregatorToType = Maps.newHashMap();
            this.schemaAllValueToAggregatorToType.put(name, aggregatorToType);
            aggFieldToType.put(name, typeT);
            HashSet aggregatorSet = Sets.newHashSet();
            HashSet aggregatorOTFSet = Sets.newHashSet();
            HashSet aggregateCompositeSet = Sets.newHashSet();
            if (value.has(FIELD_VALUES_AGGREGATIONS)) {
                aggregators = value.getJSONArray(FIELD_VALUES_AGGREGATIONS);
                if (aggregators.length() == 0) {
                    throw new IllegalArgumentException("Empty aggregators array for: " + name);
                }
                for (int aggregatorIndex = 0; aggregatorIndex < aggregators.length(); ++aggregatorIndex) {
                    String aggregatorType = null;
                    aggregatorType = aggregators.getString(aggregatorIndex);
                    if (this.isJsonSimpleString(aggregatorType)) {
                        this.addNonCompositeAggregator(aggregatorType, allValueToAggregator, allValueToOTFAggregator, name, aggregatorSet, aggregatorToType, typeT, aggregatorOTFSet, true);
                        continue;
                    }
                    JSONObject jsonAggregator = aggregators.getJSONObject(aggregatorIndex);
                    aggregatorType = jsonAggregator.getString(FIELD_VALUES_AGGREGATOR);
                    Map<String, Object> propertyNameToValue = this.getPropertyNameToValue(jsonAggregator, aggregatorType);
                    if (!this.isCompositeAggregator(aggregatorType)) throw new IllegalArgumentException("Unknow aggregator type: " + aggregatorType + ", please check if it valid.");
                    String embededAggregatorName = (String)propertyNameToValue.get(PROPERTY_NAME_EMBEDED_AGGREGATOR);
                    CompositeAggregator compositeAggregator = this.addCompositeAggregator(aggregatorType, allValueToCompositeAggregator, aggregateCompositeSet, name, embededAggregatorName, propertyNameToValue, aggregatorToType);
                }
            }
            if (!aggregatorSet.isEmpty()) {
                valueToAggregators.put(name, aggregatorSet);
                valueToOTFAggregators.put(name, aggregatorOTFSet);
            }
            if (aggregateCompositeSet.isEmpty()) continue;
            valueToCompositeAggregators.put(name, aggregateCompositeSet);
        }
        LOG.debug("allValueToAggregator {}", (Object)allValueToAggregator);
        LOG.debug("valueToAggregators {}", (Object)valueToAggregators);
        this.inputValuesDescriptor = new FieldsDescriptor(aggFieldToType);
        this.dimensionsDescriptorIDToValueToAggregator = Lists.newArrayList();
        this.dimensionsDescriptorIDToValueToOTFAggregator = Lists.newArrayList();
        this.dimensionsDescriptorIDToValueToCompositeAggregator = Lists.newArrayList();
        this.dimensionsDescriptorIDToKeyDescriptor = Lists.newArrayList();
        this.dimensionsDescriptorIDToDimensionsDescriptor = Lists.newArrayList();
        this.dimensionsDescriptorIDToAggregatorToAggregateDescriptor = Lists.newArrayList();
        this.dimensionsDescriptorIDToKeys = Lists.newArrayList();
        this.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues = Lists.newArrayList();
        if (jo.has(FIELD_DIMENSIONS)) {
            Object dimensionsVal = jo.get(FIELD_DIMENSIONS);
            if (dimensionsVal instanceof String) {
                if (!((String)dimensionsVal).equals(FIELD_DIMENSIONS_ALL_COMBINATIONS)) {
                    throw new IllegalArgumentException(dimensionsVal + " is an invalid value for " + FIELD_DIMENSIONS);
                }
                dimensionsArray = new JSONArray();
                LOG.debug("Combinations size {}", (Object)fieldToType.keySet().size());
                Set<Set<String>> combinations = this.buildCombinations(fieldToType.keySet());
                LOG.debug("Combinations size {}", (Object)combinations.size());
                ArrayList dimensionDescriptors = Lists.newArrayList();
                for (Set<String> combination : combinations) {
                    dimensionDescriptors.add(new DimensionsDescriptor(new Fields(combination)));
                }
                Collections.sort(dimensionDescriptors);
                LOG.debug("Dimensions descriptor size {}", (Object)dimensionDescriptors.size());
                for (DimensionsDescriptor dimensionsDescriptor : dimensionDescriptors) {
                    JSONObject combination = new JSONObject();
                    JSONArray combinationKeys = new JSONArray();
                    for (String field : dimensionsDescriptor.getFields().getFields()) {
                        combinationKeys.put((Object)field);
                    }
                    combination.put(FIELD_DIMENSIONS_COMBINATIONS, (Object)combinationKeys);
                    dimensionsArray.put((Object)combination);
                }
            } else {
                if (!(dimensionsVal instanceof JSONArray)) throw new IllegalArgumentException("The value for dimensions must be a string or an array.");
                dimensionsArray = jo.getJSONArray(FIELD_DIMENSIONS);
            }
        } else {
            dimensionsArray = new JSONArray();
            JSONObject combination = new JSONObject();
            combination.put(FIELD_DIMENSIONS_COMBINATIONS, (Object)new JSONArray());
            dimensionsArray.put((Object)combination);
        }
        HashSet dimensionsDescriptorFields = Sets.newHashSet();
        for (int dimensionsIndex = 0; dimensionsIndex < dimensionsArray.length(); ++dimensionsIndex) {
            JSONObject dimension = dimensionsArray.getJSONObject(dimensionsIndex);
            JSONArray combinationFields = dimension.getJSONArray(FIELD_DIMENSIONS_COMBINATIONS);
            HashMap specificValueToAggregator = Maps.newHashMap();
            HashMap specificValueToOTFAggregator = Maps.newHashMap();
            HashMap specificValueToCompositeAggregator = Maps.newHashMap();
            for (Map.Entry entry : valueToAggregators.entrySet()) {
                aggregators = Sets.newHashSet();
                aggregators.addAll((Collection)entry.getValue());
                specificValueToAggregator.put(entry.getKey(), aggregators);
            }
            for (Map.Entry entry : valueToOTFAggregators.entrySet()) {
                aggregators = Sets.newHashSet();
                aggregators.addAll((Collection)entry.getValue());
                specificValueToOTFAggregator.put(entry.getKey(), aggregators);
            }
            for (Map.Entry entry : valueToCompositeAggregators.entrySet()) {
                aggregators = Sets.newHashSet();
                aggregators.addAll((Collection)entry.getValue());
                specificValueToCompositeAggregator.put(entry.getKey(), aggregators);
            }
            ArrayList keyNames = Lists.newArrayList();
            for (int keyIndex = 0; keyIndex < combinationFields.length(); ++keyIndex) {
                String keyName = combinationFields.getString(keyIndex);
                keyNames.add(keyName);
            }
            Fields dimensionDescriptorFields = new Fields(keyNames);
            if (!dimensionsDescriptorFields.add(dimensionDescriptorFields)) {
                throw new IllegalArgumentException("Duplicate dimension descriptor: " + dimensionDescriptorFields);
            }
            HashMap fieldToAggregatorAdditionalValues = Maps.newHashMap();
            this.dimensionsDescriptorIDToKeys.add(dimensionDescriptorFields);
            this.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues.add(fieldToAggregatorAdditionalValues);
            HashSet customTimeBucketsCombinationSet = Sets.newHashSet((Iterable)customTimeBucketsAllSet);
            this.customTimeBucketsCombination = Lists.newArrayList((Iterable)customTimeBucketsAll);
            if (dimension.has("timeBuckets")) {
                JSONArray timeBuckets = dimension.getJSONArray("timeBuckets");
                if (timeBuckets.length() == 0) {
                    throw new IllegalArgumentException(dimensionDescriptorFields.getFields().toString());
                }
                for (int timeBucketIndex = 0; timeBucketIndex < timeBuckets.length(); ++timeBucketIndex) {
                    CustomTimeBucket customTimeBucket = new CustomTimeBucket(timeBuckets.getString(timeBucketIndex));
                    if (!customTimeBucketsCombinationSet.add(customTimeBucket)) {
                        throw new IllegalArgumentException("The time bucket " + customTimeBucket + " is defined twice for the dimensions combination " + dimensionDescriptorFields.getFields().toString());
                    }
                    customTimeBucketsCombinationSet.add(customTimeBucket);
                    this.customTimeBucketsCombination.add(customTimeBucket);
                }
            }
            customTimeBucketsTotalSet.addAll(customTimeBucketsCombinationSet);
            for (CustomTimeBucket timeBucket : this.customTimeBucketsCombination) {
                DimensionsDescriptor dimensionsDescriptor = new DimensionsDescriptor(timeBucket, dimensionDescriptorFields);
                this.dimensionsDescriptorIDToKeyDescriptor.add(dimensionsDescriptor.createFieldsDescriptor(this.keyDescriptor));
                this.dimensionsDescriptorIDToDimensionsDescriptor.add(dimensionsDescriptor);
            }
            if (dimension.has(FIELD_DIMENSIONS_ADDITIONAL_VALUES)) {
                JSONArray additionalValues = dimension.getJSONArray(FIELD_DIMENSIONS_ADDITIONAL_VALUES);
                for (int additionalValueIndex = 0; additionalValueIndex < additionalValues.length(); ++additionalValueIndex) {
                    String valueName;
                    String additionalValue = additionalValues.getString(additionalValueIndex);
                    if (this.isJsonSimpleString(additionalValue)) {
                        Set aggregators2;
                        Set aggregatorNames;
                        String[] components = additionalValue.split(ADDITIONAL_VALUE_SEPERATOR);
                        if (components.length != 2) {
                            throw new IllegalArgumentException("The number of component values in an additional value must be 2 not " + components.length);
                        }
                        valueName = components[0];
                        this.verifyValueDefined(valueName, aggFieldToType.keySet());
                        String aggregatorName = components[1];
                        Set aggregators3 = (Set)fieldToAggregatorAdditionalValues.get(valueName);
                        if (aggregators3 == null) {
                            aggregators3 = Sets.newHashSet();
                            fieldToAggregatorAdditionalValues.put(valueName, aggregators3);
                        }
                        aggregators3.add(aggregatorName);
                        if (!this.aggregatorRegistry.isAggregator(aggregatorName)) {
                            throw new IllegalArgumentException(aggregatorName + " is not a valid aggregator.");
                        }
                        if (this.aggregatorRegistry.isIncrementalAggregator(aggregatorName)) {
                            aggregatorNames = (Set)allValueToAggregator.get(valueName);
                            if (aggregatorNames == null) {
                                aggregatorNames = Sets.newHashSet();
                                allValueToAggregator.put(valueName, aggregatorNames);
                            }
                            aggregatorNames.add(aggregatorName);
                            aggregators2 = (Set)specificValueToAggregator.get(valueName);
                            if (aggregators2 == null) {
                                aggregators2 = Sets.newHashSet();
                                specificValueToAggregator.put(valueName, aggregators2);
                            }
                            if (aggregators2.add(aggregatorName)) continue;
                            throw new IllegalArgumentException("The aggregator " + aggregatorName + " was already defined in the " + FIELD_VALUES + " section for the value " + valueName);
                        }
                        aggregatorNames = (Set)specificValueToOTFAggregator.get(valueName);
                        if (aggregatorNames == null) {
                            aggregatorNames = Sets.newHashSet();
                            specificValueToOTFAggregator.put(valueName, aggregatorNames);
                        }
                        if (!aggregatorNames.add(aggregatorName)) {
                            throw new IllegalArgumentException("The aggregator " + aggregatorName + " cannot be specified twice for the value " + valueName);
                        }
                        aggregatorNames = (Set)allValueToOTFAggregator.get(valueName);
                        if (aggregatorNames == null) {
                            aggregatorNames = Sets.newHashSet();
                            allValueToOTFAggregator.put(valueName, aggregatorNames);
                        }
                        if (!aggregatorNames.add(aggregatorName)) {
                            throw new IllegalArgumentException("The aggregator " + aggregatorName + " cannot be specified twice for the value " + valueName);
                        }
                        aggregators2 = (Set)specificValueToAggregator.get(valueName);
                        if (aggregators2 == null) {
                            aggregators2 = Sets.newHashSet();
                            specificValueToAggregator.put(valueName, aggregators2);
                        }
                        if (aggregators2 == null) {
                            throw new IllegalArgumentException("The additional value " + additionalValue + "Does not have a corresponding value " + valueName + " defined in the " + FIELD_VALUES + " section.");
                        }
                        aggregators2.addAll((Collection)this.aggregatorRegistry.getOTFAggregatorToIncrementalAggregators().get(aggregatorName));
                        continue;
                    }
                    JSONObject jsonAddition = additionalValues.getJSONObject(additionalValueIndex);
                    valueName = (String)jsonAddition.keys().next();
                    this.verifyValueDefined(valueName, aggFieldToType.keySet());
                    JSONObject jsonAggregator = jsonAddition.getJSONObject(valueName);
                    String aggregatorName = jsonAggregator.getString(FIELD_VALUES_AGGREGATOR);
                    Map<String, Object> propertyNameToValue = this.getPropertyNameToValue(jsonAggregator, aggregatorName);
                    if (!this.isCompositeAggregator(aggregatorName)) throw new IllegalArgumentException("Unknow aggregator name: " + aggregatorName + ", please check if it valid.");
                    String embededAggregatorName = (String)propertyNameToValue.get(PROPERTY_NAME_EMBEDED_AGGREGATOR);
                    Set compositeAggregators = (Set)specificValueToCompositeAggregator.get(valueName);
                    if (compositeAggregators == null) {
                        compositeAggregators = Sets.newHashSet();
                        specificValueToCompositeAggregator.put(valueName, compositeAggregators);
                    }
                    CompositeAggregator compositeAggregator = this.addCompositeAggregator(aggregatorName, allValueToCompositeAggregator, compositeAggregators, valueName, embededAggregatorName, propertyNameToValue, null);
                }
            }
            if (specificValueToAggregator.isEmpty() && specificValueToCompositeAggregator.isEmpty()) {
                throw new IllegalArgumentException("No aggregations defined for the following field combination " + combinationFields.toString());
            }
            for (CustomTimeBucket customTimeBucket : this.customTimeBucketsCombination) {
                this.dimensionsDescriptorIDToValueToAggregator.add(specificValueToAggregator);
                this.dimensionsDescriptorIDToValueToOTFAggregator.add(specificValueToOTFAggregator);
                this.dimensionsDescriptorIDToValueToCompositeAggregator.add(specificValueToCompositeAggregator);
            }
        }
        customTimeBucketsAll.clear();
        customTimeBucketsAll.addAll(customTimeBucketsTotalSet);
        Collections.sort(customTimeBucketsAll);
        for (CustomTimeBucket customTimeBucket : customTimeBucketsAll) {
            if (this.customTimeBucketRegistry.getTimeBucketId(customTimeBucket) != null) continue;
            if (customTimeBucket.isUnit() || customTimeBucket.getTimeBucket() == TimeBucket.ALL) {
                this.customTimeBucketRegistry.register(customTimeBucket, customTimeBucket.getTimeBucket().ordinal());
                continue;
            }
            this.customTimeBucketRegistry.register(customTimeBucket);
        }
        this.computeAdditionalDimensionForCompositeAggregators();
        this.dimensionsDescriptorIDToAggregatorToAggregateDescriptor = this.computeAggregatorToAggregateDescriptor(this.dimensionsDescriptorIDToValueToAggregator);
        this.dimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor = this.computeAggregatorToAggregateDescriptor(this.dimensionsDescriptorIDToValueToOTFAggregator);
        this.dimensionsDescriptorIDToCompositeAggregatorToAggregateDescriptor = this.computeAggregatorToAggregateDescriptor(this.dimensionsDescriptorIDToValueToCompositeAggregator);
        this.dimensionsDescriptorToID = Maps.newHashMap();
        for (int index = 0; index < this.dimensionsDescriptorIDToDimensionsDescriptor.size(); ++index) {
            this.dimensionsDescriptorToID.put(this.dimensionsDescriptorIDToDimensionsDescriptor.get(index), index);
        }
        this.buildDimensionsDescriptorIDAggregatorIDMaps();
        this.aggregatorRegistry.buildTopBottomAggregatorIDToAggregator();
        this.fulfillCompositeAggregatorExtraInfo();
    }

    protected Map<String, Object> getPropertyNameToValue(JSONObject jsonAggregator, String aggregatorName) throws JSONException {
        Set<String> propertyNames = aggregatorToPropertiesMap.get(aggregatorName);
        if (propertyNames == null) {
            return Collections.emptyMap();
        }
        HashMap propertyNameToValue = Maps.newHashMap();
        for (String propertyName : propertyNames) {
            String propertyValue = jsonAggregator.getString(propertyName);
            if (propertyValue == null) continue;
            if (this.isJsonSimpleString(propertyValue)) {
                propertyNameToValue.put(propertyName, propertyValue);
                continue;
            }
            JSONArray propertyValues = jsonAggregator.getJSONArray(propertyName);
            if (propertyValues == null) continue;
            int valueLength = propertyValues.length();
            String[] values = new String[valueLength];
            for (int i = 0; i < valueLength; ++i) {
                values[i] = propertyValues.getString(i);
            }
            propertyNameToValue.put(propertyName, values);
        }
        return propertyNameToValue;
    }

    protected boolean isCompositeAggregator(String aggregatorName) {
        aggregatorName = aggregatorName.split("-")[0];
        for (int index = 0; index < COMPOSITE_AGGREGATORS.length; ++index) {
            if (!COMPOSITE_AGGREGATORS[index].equals(aggregatorName)) continue;
            return true;
        }
        return false;
    }

    private List<String> getStringsFromJSONArray(JSONArray jsonStringArray) throws JSONException {
        ArrayList stringArray = Lists.newArrayListWithCapacity((int)jsonStringArray.length());
        for (int stringIndex = 0; stringIndex < jsonStringArray.length(); ++stringIndex) {
            stringArray.add(jsonStringArray.getString(stringIndex));
        }
        return stringArray;
    }

    protected void computeAdditionalDimensionForCompositeAggregators() {
        Map<Set<String>, Integer> keysToCombinationId = this.getKeysToCombinationId();
        int initialKeysCombinationsSize = this.dimensionsDescriptorIDToKeys.size();
        for (int keysIndex = 0; keysIndex < initialKeysCombinationsSize; ++keysIndex) {
            Set<String> keys = this.dimensionsDescriptorIDToKeys.get(keysIndex).getFields();
            int ddId = keysIndex * this.customTimeBucketsCombination.size();
            Map<String, Set<String>> valueToAggregators = this.dimensionsDescriptorIDToValueToCompositeAggregator.get(ddId);
            Map<String, Set<String>> compositeAggregatorToValues = this.getAggregatorToValues(valueToAggregators);
            for (Map.Entry<String, Set<String>> aggregatorToValuesEntry : compositeAggregatorToValues.entrySet()) {
                AbstractTopBottomAggregator aggregator = this.getCompositeAggregatorByName(aggregatorToValuesEntry.getKey());
                Set<String> subCombination = aggregator.getSubCombinations();
                this.addSubKeysAndAggregator(aggregatorToValuesEntry.getValue(), keys, subCombination, aggregator.getEmbedAggregatorName(), keysToCombinationId);
            }
        }
    }

    protected Map<String, Set<String>> getAggregatorToValues(Map<String, Set<String>> valueToAggregators) {
        HashMap aggregatorToValues = Maps.newHashMap();
        for (Map.Entry<String, Set<String>> entry : valueToAggregators.entrySet()) {
            for (String aggregator : entry.getValue()) {
                Set values = (Set)aggregatorToValues.get(aggregator);
                if (values == null) {
                    values = Sets.newHashSet();
                    aggregatorToValues.put(aggregator, values);
                }
                values.add(entry.getKey());
            }
        }
        return aggregatorToValues;
    }

    protected AbstractTopBottomAggregator getCompositeAggregatorByName(String compositeAggregatorName) {
        return this.aggregatorRegistry.getNameToTopBottomAggregator().get(compositeAggregatorName);
    }

    protected Map<Set<String>, Integer> getKeysToCombinationId() {
        HashMap keysToDdid = Maps.newHashMap();
        for (int index = 0; index < this.dimensionsDescriptorIDToKeys.size(); ++index) {
            HashSet keys = Sets.newHashSet();
            keys.addAll(this.dimensionsDescriptorIDToKeys.get(index).getFieldsList());
            Integer orgIndex = keysToDdid.put(keys, index);
            if (orgIndex == null) continue;
            throw new RuntimeException("The keys" + keys + "already have a index " + index + " associated with it.");
        }
        return keysToDdid;
    }

    protected void addSubKeysAndAggregator(Set<String> values, Set<String> keysOfCompositeAggregator, Set<String> subKeys, String aggregatorName, Map<Set<String>, Integer> keysToCombinationId) {
        if (keysOfCompositeAggregator == null || subKeys == null || keysOfCompositeAggregator.isEmpty() || subKeys.isEmpty()) {
            throw new IllegalArgumentException("Both keys and subKeys can't be null or empty");
        }
        HashSet allKeys = Sets.newHashSet();
        allKeys.addAll(keysOfCompositeAggregator);
        allKeys.addAll(subKeys);
        if (allKeys.size() != keysOfCompositeAggregator.size() + subKeys.size()) {
            throw new IllegalArgumentException("Should NOT have overlap between keys " + keysOfCompositeAggregator.toString() + " and subKeys " + subKeys);
        }
        Integer combinationId = keysToCombinationId.get(allKeys);
        if (combinationId == null) {
            if (!this.dimensionsDescriptorIDToKeys.add(new Fields(allKeys))) {
                throw new RuntimeException("The keys " + allKeys + " already existed.");
            }
            combinationId = this.dimensionsDescriptorIDToKeys.size() - 1;
            keysToCombinationId.put(allKeys, combinationId);
            this.addValueToAggregatorToCombination(values, allKeys, aggregatorName);
        } else {
            Set<Object> incrementalAggregatorNames;
            boolean isOTFAggregator = false;
            if (!this.isIncrementalAggregator(aggregatorName)) {
                incrementalAggregatorNames = this.getOTFDependedIncrementalAggregatorNames(aggregatorName);
                isOTFAggregator = true;
            } else {
                incrementalAggregatorNames = Sets.newHashSet();
                incrementalAggregatorNames.add(aggregatorName);
            }
            HashMap newValueToIncrementalAggregators = Maps.newHashMap();
            HashMap newValueToOTFAggregators = Maps.newHashMap();
            for (String value : values) {
                newValueToIncrementalAggregators.put(value, incrementalAggregatorNames);
                if (!isOTFAggregator) continue;
                newValueToOTFAggregators.put(value, Sets.newHashSet((Object[])new String[]{aggregatorName}));
            }
            int ddid = combinationId * this.customTimeBucketsCombination.size();
            int index = 0;
            while (index < this.customTimeBucketsCombination.size()) {
                this.mergeMaps(this.dimensionsDescriptorIDToValueToAggregator.get(ddid), newValueToIncrementalAggregators);
                this.mergeMaps(this.dimensionsDescriptorIDToValueToOTFAggregator.get(ddid), newValueToOTFAggregators);
                ++index;
                ++ddid;
            }
        }
    }

    protected void addValueToAggregatorToCombination(Set<String> values, Set<String> allKeys, String aggregatorName) {
        Set<Object> incrementalAggregatorNames;
        HashMap valueToIncrementalAggregators = Maps.newHashMap();
        HashMap valueToOTFAggregators = Maps.newHashMap();
        boolean isOTFAggregator = false;
        if (!this.isIncrementalAggregator(aggregatorName)) {
            incrementalAggregatorNames = this.getOTFDependedIncrementalAggregatorNames(aggregatorName);
            isOTFAggregator = true;
        } else {
            incrementalAggregatorNames = Sets.newHashSet();
            incrementalAggregatorNames.add(aggregatorName);
        }
        for (String value : values) {
            valueToIncrementalAggregators.put(value, incrementalAggregatorNames);
            if (!isOTFAggregator) continue;
            valueToOTFAggregators.put(value, Sets.newHashSet((Object[])new String[]{aggregatorName}));
        }
        for (CustomTimeBucket customTimeBucket : this.customTimeBucketsCombination) {
            this.dimensionsDescriptorIDToValueToAggregator.add(valueToIncrementalAggregators);
            this.dimensionsDescriptorIDToValueToOTFAggregator.add(valueToOTFAggregators);
            this.dimensionsDescriptorIDToValueToCompositeAggregator.add(Collections.emptyMap());
            this.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues.add(Collections.emptyMap());
            DimensionsDescriptor dimensionsDescriptor = new DimensionsDescriptor(customTimeBucket, new Fields(allKeys));
            this.dimensionsDescriptorIDToDimensionsDescriptor.add(dimensionsDescriptor);
            this.dimensionsDescriptorIDToKeyDescriptor.add(dimensionsDescriptor.createFieldsDescriptor(this.keyDescriptor));
        }
    }

    protected boolean isIncrementalAggregator(String aggregatorName) {
        return this.aggregatorRegistry.getNameToIncrementalAggregator().get(aggregatorName) != null;
    }

    protected boolean isOTFAggregator(String aggregatorName) {
        return this.aggregatorRegistry.getNameToOTFAggregators().get(aggregatorName) != null;
    }

    protected Set<String> getOTFDependedIncrementalAggregatorNames(String oftAggregatorName) {
        return Sets.newHashSet(this.aggregatorRegistry.getOTFAggregatorToIncrementalAggregators().get(oftAggregatorName).iterator());
    }

    protected void verifyValueDefined(String valueName, Set<String> valueNames) {
        if (valueNames == null || !valueNames.contains(valueName)) {
            throw new IllegalArgumentException("The additional value " + valueName + "Does not have a corresponding value " + valueName + " defined in the " + FIELD_VALUES + " section.");
        }
    }

    protected boolean isJsonSimpleString(String string) {
        return !string.contains("{") && !string.contains("[");
    }

    protected Object addNonCompositeAggregator(String aggregatorName, Map<String, Set<String>> allValueToAggregator, Map<String, Set<String>> allValueToOTFAggregator, String valueName, Set<String> aggregatorSet, Map<String, Type> aggregatorToType, Type typeT, Set<String> aggregatorOTFSet, boolean checkDuplicate) {
        if (this.aggregatorRegistry.isIncrementalAggregator(aggregatorName)) {
            HashSet aggregatorNames = allValueToAggregator.get(valueName);
            if (aggregatorNames == null) {
                aggregatorNames = Sets.newHashSet();
                allValueToAggregator.put(valueName, aggregatorNames);
            }
            aggregatorNames.add(aggregatorName);
            if (!aggregatorSet.add(aggregatorName) && checkDuplicate) {
                throw new IllegalArgumentException("An aggregator " + aggregatorName + " cannot be specified twice for a value");
            }
            IncrementalAggregator aggregator = this.aggregatorRegistry.getNameToIncrementalAggregator().get(aggregatorName);
            aggregatorToType.put(aggregatorName, aggregator.getOutputType(typeT));
            return aggregator;
        }
        if (this.aggregatorRegistry.isOTFAggregator(aggregatorName)) {
            Set<Object> aggregatorNames = allValueToOTFAggregator.get(valueName);
            if (aggregatorNames == null) {
                aggregatorNames = Sets.newHashSet();
                allValueToOTFAggregator.put(valueName, (Set<String>)aggregatorNames);
            }
            if (!aggregatorNames.add(aggregatorName) && checkDuplicate) {
                throw new IllegalArgumentException("An aggregator " + aggregatorName + " cannot be specified twice for a value");
            }
            aggregatorOTFSet.add(aggregatorName);
            aggregatorNames = allValueToAggregator.get(valueName);
            if (aggregatorNames == null) {
                aggregatorNames = Sets.newHashSet();
                allValueToAggregator.put(valueName, (Set<String>)aggregatorNames);
            }
            OTFAggregator aggregator = this.aggregatorRegistry.getNameToOTFAggregators().get(aggregatorName);
            aggregatorNames.addAll((Collection)this.aggregatorRegistry.getOTFAggregatorToIncrementalAggregators().get(aggregatorName));
            aggregatorSet.addAll((Collection<String>)this.aggregatorRegistry.getOTFAggregatorToIncrementalAggregators().get(aggregatorName));
            aggregatorToType.put(aggregatorName, aggregator.getOutputType());
            LOG.debug("field name {} and adding aggregator names {}:", (Object)valueName, aggregatorNames);
            return aggregator;
        }
        throw new IllegalArgumentException(aggregatorName + " is not a valid non-composit aggregator.");
    }

    protected CompositeAggregator addCompositeAggregator(String aggregatorType, Map<String, Set<String>> allValueToCompositeAggregator, Set<String> aggregateCompositeSet, String valueName, String embededAggregatorName, Map<String, Object> properties, Map<String, Type> aggregatorToType) {
        if (!this.aggregatorRegistry.isTopBottomAggregatorType(aggregatorType)) {
            throw new IllegalArgumentException(aggregatorType + " is not a valid composite aggregator.");
        }
        String aggregatorName = this.compositeAggregatorFactory.getCompositeAggregatorName(aggregatorType, embededAggregatorName, properties);
        CompositeAggregator aggregator = this.compositeAggregatorFactory.createCompositeAggregator(aggregatorType, embededAggregatorName, properties);
        HashSet aggregatorNames = allValueToCompositeAggregator.get(valueName);
        if (aggregatorNames == null) {
            aggregatorNames = Sets.newHashSet();
            allValueToCompositeAggregator.put(valueName, aggregatorNames);
        }
        if (!aggregatorNames.add(aggregatorName)) {
            throw new IllegalArgumentException("An aggregator " + aggregatorName + " cannot be specified twice for value '" + valueName + "'");
        }
        allValueToCompositeAggregator.put(valueName, aggregatorNames);
        aggregateCompositeSet.add(aggregatorName);
        if (aggregator instanceof AbstractTopBottomAggregator) {
            this.aggregatorRegistry.getNameToTopBottomAggregator().put(aggregatorName, (AbstractTopBottomAggregator)aggregator);
        }
        LOG.debug("field name {} and adding aggregator names {}:", (Object)valueName, (Object)aggregatorNames);
        if (aggregatorToType != null) {
            aggregatorToType.put(aggregatorName, aggregator.getOutputType());
        }
        return aggregator;
    }

    private List<String> getTags(JSONObject jo) throws JSONException {
        if (jo.has(FIELD_TAGS)) {
            return this.getStringsFromJSONArray(jo.getJSONArray(FIELD_TAGS));
        }
        return Lists.newArrayList();
    }

    private Set<Set<String>> buildCombinations(Set<String> fields) {
        if (fields.isEmpty()) {
            HashSet combinations = Sets.newHashSet();
            HashSet combination = Sets.newHashSet();
            combinations.add(combination);
            return combinations;
        }
        fields = Sets.newHashSet(fields);
        String item = (String)fields.iterator().next();
        fields.remove(item);
        Set<Set<String>> combinations = this.buildCombinations(fields);
        HashSet newCombinations = Sets.newHashSet(combinations);
        for (Set<String> combination : combinations) {
            HashSet newCombination = Sets.newHashSet(combination);
            newCombination.add(item);
            newCombinations.add(newCombination);
        }
        return newCombinations;
    }

    protected void buildDimensionsDescriptorIDAggregatorIDMaps() {
        this.dimensionsDescriptorIDToIncrementalAggregatorIDs = Lists.newArrayList();
        this.dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor = Lists.newArrayList();
        this.dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor = Lists.newArrayList();
        for (int index = 0; index < this.dimensionsDescriptorIDToAggregatorToAggregateDescriptor.size(); ++index) {
            IntArrayList aggIDList = new IntArrayList();
            Int2ObjectOpenHashMap inputMap = new Int2ObjectOpenHashMap();
            Int2ObjectOpenHashMap outputMap = new Int2ObjectOpenHashMap();
            this.dimensionsDescriptorIDToIncrementalAggregatorIDs.add(aggIDList);
            this.dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor.add((Int2ObjectMap<FieldsDescriptor>)inputMap);
            this.dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor.add((Int2ObjectMap<FieldsDescriptor>)outputMap);
            for (Map.Entry<String, FieldsDescriptor> entry : this.dimensionsDescriptorIDToAggregatorToAggregateDescriptor.get(index).entrySet()) {
                this.buildNonCompositeAggregatorIDMap(entry.getKey(), entry.getValue(), aggIDList, (Int2ObjectMap<FieldsDescriptor>)inputMap, (Int2ObjectMap<FieldsDescriptor>)outputMap);
            }
        }
        int maxAggregatorID = this.getLargestNonCompositeAggregatorID();
        this.dimensionsDescriptorIDToCompositeAggregatorIDs = Lists.newArrayList();
        for (int index = 0; index < this.dimensionsDescriptorIDToCompositeAggregatorToAggregateDescriptor.size(); ++index) {
            IntArrayList aggIDList = new IntArrayList();
            Int2ObjectMap<FieldsDescriptor> inputMap = this.dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor.get(index);
            Int2ObjectMap<FieldsDescriptor> outputMap = this.dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor.get(index);
            this.dimensionsDescriptorIDToCompositeAggregatorIDs.add(aggIDList);
            for (Map.Entry<String, FieldsDescriptor> entry : this.dimensionsDescriptorIDToCompositeAggregatorToAggregateDescriptor.get(index).entrySet()) {
                int aggregatorID;
                String aggregatorName = entry.getKey();
                FieldsDescriptor inputDescriptor = entry.getValue();
                AbstractCompositeAggregator compositeAggregator = this.aggregatorRegistry.getNameToTopBottomAggregator().get(aggregatorName);
                Integer objAggregatorID = this.aggregatorRegistry.getTopBottomAggregatorNameToID().get(aggregatorName);
                if (objAggregatorID == null) {
                    aggregatorID = ++maxAggregatorID;
                    this.aggregatorRegistry.getTopBottomAggregatorNameToID().put(aggregatorName, aggregatorID);
                } else {
                    aggregatorID = objAggregatorID;
                }
                aggIDList.add(aggregatorID);
                inputMap.put(aggregatorID, (Object)inputDescriptor);
                outputMap.put(aggregatorID, (Object)AggregatorUtils.getOutputFieldsDescriptor(inputDescriptor, compositeAggregator));
            }
        }
    }

    protected int getLargestNonCompositeAggregatorID() {
        int maxAggregatorID = 0;
        Collection<Integer> aggregatorIDs = this.aggregatorRegistry.getIncrementalAggregatorNameToID().values();
        for (int aggregatorID : aggregatorIDs) {
            if (aggregatorID <= maxAggregatorID) continue;
            maxAggregatorID = aggregatorID;
        }
        return maxAggregatorID;
    }

    protected void buildNonCompositeAggregatorIDMap(String aggregatorName, FieldsDescriptor inputDescriptor, IntArrayList aggIDList, Int2ObjectMap<FieldsDescriptor> inputMap, Int2ObjectMap<FieldsDescriptor> outputMap) {
        IncrementalAggregator incrementalAggregator = this.aggregatorRegistry.getNameToIncrementalAggregator().get(aggregatorName);
        if (incrementalAggregator == null) {
            return;
        }
        int aggregatorID = this.aggregatorRegistry.getIncrementalAggregatorNameToID().get(aggregatorName);
        this.mergeAggregatorID(aggIDList, aggregatorID);
        inputMap.put(aggregatorID, (Object)inputDescriptor);
        outputMap.put(aggregatorID, (Object)AggregatorUtils.getOutputFieldsDescriptor(inputDescriptor, incrementalAggregator));
    }

    protected void fulfillCompositeAggregatorExtraInfo() {
        Map<Set<String>, Integer> keysToCombinationId = this.getKeysToCombinationId();
        int timeBucketSize = this.customTimeBuckets.size();
        for (int index = 0; index < this.dimensionsDescriptorIDToCompositeAggregatorToAggregateDescriptor.size(); ++index) {
            Map<String, FieldsDescriptor> compositeAggregatorNameToDescriptor = this.dimensionsDescriptorIDToCompositeAggregatorToAggregateDescriptor.get(index);
            for (String compositeAggregatorName : compositeAggregatorNameToDescriptor.keySet()) {
                AbstractTopBottomAggregator compositeAggregator = this.aggregatorRegistry.getNameToTopBottomAggregator().get(compositeAggregatorName);
                compositeAggregator.setDimensionDescriptorID(index);
                compositeAggregator.setAggregatorID(this.aggregatorRegistry.getTopBottomAggregatorNameToID().get(compositeAggregatorName));
                HashSet keys = Sets.newHashSet();
                DimensionsDescriptor dd = this.dimensionsDescriptorIDToDimensionsDescriptor.get(index);
                keys.addAll(dd.getFields().getFieldsList());
                HashSet compositeKeys = Sets.newHashSet();
                compositeKeys.addAll(keys);
                compositeAggregator.setFields(compositeKeys);
                compositeAggregator.setAggregateDescriptor(compositeAggregatorNameToDescriptor.get(compositeAggregatorName));
                keys.addAll(compositeAggregator.getSubCombinations());
                Integer combinationId = keysToCombinationId.get(keys);
                if (combinationId == null) {
                    throw new RuntimeException("Can't find combination id for keys: " + keys);
                }
                for (int ddid = combinationId * timeBucketSize; ddid < (combinationId + 1) * timeBucketSize; ++ddid) {
                    compositeAggregator.addEmbedAggregatorDdId(ddid);
                }
            }
        }
    }

    protected String getEmbededAggregatorName(String compositeAggregatorName) {
        try {
            return compositeAggregatorName.split("-")[1];
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid Composite Aggregator Name: " + compositeAggregatorName);
        }
    }

    protected void mergeAggregatorID(IntArrayList aggIDList, int aggregatorID) {
        for (int index = 0; index < aggIDList.size(); ++index) {
            if (aggIDList.get(index) != aggregatorID) continue;
            return;
        }
        aggIDList.add(aggregatorID);
    }

    private void mergeMaps(Map<String, Set<String>> destmap, Map<String, Set<String>> srcmap) {
        for (Map.Entry<String, Set<String>> entry : srcmap.entrySet()) {
            String key = entry.getKey();
            HashSet destset = destmap.get(key);
            Set<String> srcset = srcmap.get(key);
            if (destset == null) {
                destset = Sets.newHashSet();
                destmap.put(key, destset);
            }
            if (srcset == null) continue;
            destset.addAll(srcset);
        }
    }

    private FieldsDescriptor keyDescriptorWithTime(Map<String, Type> fieldToTypeWithTime, List<CustomTimeBucket> customTimeBuckets) {
        if (customTimeBuckets.size() > 1 || !customTimeBuckets.isEmpty() && !customTimeBuckets.get(0).getTimeBucket().equals((Object)TimeBucket.ALL)) {
            fieldToTypeWithTime.put("time", DimensionsDescriptor.DIMENSION_TIME_TYPE);
        }
        return new FieldsDescriptor(fieldToTypeWithTime);
    }

    public FieldsDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    public FieldsDescriptor getInputValuesDescriptor() {
        return this.inputValuesDescriptor;
    }

    public List<FieldsDescriptor> getDimensionsDescriptorIDToKeyDescriptor() {
        return this.dimensionsDescriptorIDToKeyDescriptor;
    }

    public Map<DimensionsDescriptor, Integer> getDimensionsDescriptorToID() {
        return this.dimensionsDescriptorToID;
    }

    public List<DimensionsDescriptor> getDimensionsDescriptorIDToDimensionsDescriptor() {
        return this.dimensionsDescriptorIDToDimensionsDescriptor;
    }

    public List<Map<String, Set<String>>> getDimensionsDescriptorIDToValueToAggregator() {
        return this.dimensionsDescriptorIDToValueToAggregator;
    }

    public String getKeysString() {
        return this.keysString;
    }

    public String getBucketsString() {
        return this.bucketsString;
    }

    public Map<String, List<Object>> getKeysToEnumValuesList() {
        return this.keysToEnumValuesList;
    }

    public List<Map<String, Set<String>>> getDimensionsDescriptorIDToValueToOTFAggregator() {
        return this.dimensionsDescriptorIDToValueToOTFAggregator;
    }

    public List<Int2ObjectMap<FieldsDescriptor>> getDimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor() {
        return this.dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor;
    }

    public List<Int2ObjectMap<FieldsDescriptor>> getDimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor() {
        return this.dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor;
    }

    public List<IntArrayList> getDimensionsDescriptorIDToIncrementalAggregatorIDs() {
        return this.dimensionsDescriptorIDToIncrementalAggregatorIDs;
    }

    public List<IntArrayList> getDimensionsDescriptorIDToAggregatorIDs() {
        return this.getDimensionsDescriptorIDToIncrementalAggregatorIDs();
    }

    public List<IntArrayList> getDimensionsDescriptorIDToCompositeAggregatorIDs() {
        return this.dimensionsDescriptorIDToCompositeAggregatorIDs;
    }

    public List<Fields> getDimensionsDescriptorIDToKeys() {
        return this.dimensionsDescriptorIDToKeys;
    }

    public List<Map<String, Set<String>>> getDimensionsDescriptorIDToFieldToAggregatorAdditionalValues() {
        return this.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues;
    }

    public Map<String, Map<String, Type>> getSchemaAllValueToAggregatorToType() {
        return this.schemaAllValueToAggregatorToType;
    }

    @Deprecated
    public List<TimeBucket> getTimeBuckets() {
        return this.timeBuckets;
    }

    public List<CustomTimeBucket> getCustomTimeBuckets() {
        return this.customTimeBuckets;
    }

    public CustomTimeBucketRegistry getCustomTimeBucketRegistry() {
        return this.customTimeBucketRegistry;
    }

    @VisibleForTesting
    public List<Map<String, FieldsDescriptor>> getDimensionsDescriptorIDToAggregatorToAggregateDescriptor() {
        return this.dimensionsDescriptorIDToAggregatorToAggregateDescriptor;
    }

    @VisibleForTesting
    public List<Map<String, FieldsDescriptor>> getDimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor() {
        return this.dimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor;
    }

    @VisibleForTesting
    public List<Map<String, FieldsDescriptor>> getDimensionsDescriptorIDToCompositeAggregatorToAggregateDescriptor() {
        return this.dimensionsDescriptorIDToCompositeAggregatorToAggregateDescriptor;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.keyDescriptor != null ? this.keyDescriptor.hashCode() : 0);
        hash = 97 * hash + (this.inputValuesDescriptor != null ? this.inputValuesDescriptor.hashCode() : 0);
        hash = 97 * hash + (this.keysToEnumValuesList != null ? this.keysToEnumValuesList.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorIDToKeyDescriptor != null ? this.dimensionsDescriptorIDToKeyDescriptor.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorIDToDimensionsDescriptor != null ? this.dimensionsDescriptorIDToDimensionsDescriptor.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorIDToValueToAggregator != null ? this.dimensionsDescriptorIDToValueToAggregator.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorIDToValueToOTFAggregator != null ? this.dimensionsDescriptorIDToValueToOTFAggregator.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorIDToAggregatorToAggregateDescriptor != null ? this.dimensionsDescriptorIDToAggregatorToAggregateDescriptor.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor != null ? this.dimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorToID != null ? this.dimensionsDescriptorToID.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor != null ? this.dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor != null ? this.dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorIDToIncrementalAggregatorIDs != null ? this.dimensionsDescriptorIDToIncrementalAggregatorIDs.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues != null ? this.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues.hashCode() : 0);
        hash = 97 * hash + (this.dimensionsDescriptorIDToKeys != null ? this.dimensionsDescriptorIDToKeys.hashCode() : 0);
        hash = 97 * hash + (this.keysString != null ? this.keysString.hashCode() : 0);
        hash = 97 * hash + (this.bucketsString != null ? this.bucketsString.hashCode() : 0);
        hash = 97 * hash + (this.aggregatorRegistry != null ? this.aggregatorRegistry.hashCode() : 0);
        hash = 97 * hash + (this.customTimeBuckets != null ? this.customTimeBuckets.hashCode() : 0);
        hash = 97 * hash + (this.schemaAllValueToAggregatorToType != null ? this.schemaAllValueToAggregatorToType.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DimensionalConfigurationSchema other = (DimensionalConfigurationSchema)obj;
        if (!(this.keyDescriptor == other.keyDescriptor || this.keyDescriptor != null && this.keyDescriptor.equals(other.keyDescriptor))) {
            return false;
        }
        if (!(this.inputValuesDescriptor == other.inputValuesDescriptor || this.inputValuesDescriptor != null && this.inputValuesDescriptor.equals(other.inputValuesDescriptor))) {
            return false;
        }
        if (!(this.keysToEnumValuesList == other.keysToEnumValuesList || this.keysToEnumValuesList != null && this.keysToEnumValuesList.equals(other.keysToEnumValuesList))) {
            return false;
        }
        if (!(this.dimensionsDescriptorIDToKeyDescriptor == other.dimensionsDescriptorIDToKeyDescriptor || this.dimensionsDescriptorIDToKeyDescriptor != null && this.dimensionsDescriptorIDToKeyDescriptor.equals(other.dimensionsDescriptorIDToKeyDescriptor))) {
            return false;
        }
        if (!(this.dimensionsDescriptorIDToDimensionsDescriptor == other.dimensionsDescriptorIDToDimensionsDescriptor || this.dimensionsDescriptorIDToDimensionsDescriptor != null && this.dimensionsDescriptorIDToDimensionsDescriptor.equals(other.dimensionsDescriptorIDToDimensionsDescriptor))) {
            return false;
        }
        if (!(this.dimensionsDescriptorIDToValueToAggregator == other.dimensionsDescriptorIDToValueToAggregator || this.dimensionsDescriptorIDToValueToAggregator != null && this.dimensionsDescriptorIDToValueToAggregator.equals(other.dimensionsDescriptorIDToValueToAggregator))) {
            return false;
        }
        if (!(this.dimensionsDescriptorIDToValueToOTFAggregator == other.dimensionsDescriptorIDToValueToOTFAggregator || this.dimensionsDescriptorIDToValueToOTFAggregator != null && this.dimensionsDescriptorIDToValueToOTFAggregator.equals(other.dimensionsDescriptorIDToValueToOTFAggregator))) {
            return false;
        }
        if (!(this.dimensionsDescriptorIDToAggregatorToAggregateDescriptor == other.dimensionsDescriptorIDToAggregatorToAggregateDescriptor || this.dimensionsDescriptorIDToAggregatorToAggregateDescriptor != null && this.dimensionsDescriptorIDToAggregatorToAggregateDescriptor.equals(other.dimensionsDescriptorIDToAggregatorToAggregateDescriptor))) {
            return false;
        }
        if (!(this.dimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor == other.dimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor || this.dimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor != null && this.dimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor.equals(other.dimensionsDescriptorIDToOTFAggregatorToAggregateDescriptor))) {
            return false;
        }
        if (!(this.dimensionsDescriptorToID == other.dimensionsDescriptorToID || this.dimensionsDescriptorToID != null && this.dimensionsDescriptorToID.equals(other.dimensionsDescriptorToID))) {
            return false;
        }
        if (!(this.dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor == other.dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor || this.dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor != null && this.dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor.equals(other.dimensionsDescriptorIDToAggregatorIDToInputAggregatorDescriptor))) {
            return false;
        }
        if (!(this.dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor == other.dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor || this.dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor != null && this.dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor.equals(other.dimensionsDescriptorIDToAggregatorIDToOutputAggregatorDescriptor))) {
            return false;
        }
        if (!(this.dimensionsDescriptorIDToIncrementalAggregatorIDs == other.dimensionsDescriptorIDToIncrementalAggregatorIDs || this.dimensionsDescriptorIDToIncrementalAggregatorIDs != null && this.dimensionsDescriptorIDToIncrementalAggregatorIDs.equals(other.dimensionsDescriptorIDToIncrementalAggregatorIDs))) {
            return false;
        }
        if (!(this.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues == other.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues || this.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues != null && this.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues.equals(other.dimensionsDescriptorIDToFieldToAggregatorAdditionalValues))) {
            return false;
        }
        if (!(this.dimensionsDescriptorIDToKeys == other.dimensionsDescriptorIDToKeys || this.dimensionsDescriptorIDToKeys != null && this.dimensionsDescriptorIDToKeys.equals(other.dimensionsDescriptorIDToKeys))) {
            return false;
        }
        if (this.keysString == null ? other.keysString != null : !this.keysString.equals(other.keysString)) {
            return false;
        }
        if (this.bucketsString == null ? other.bucketsString != null : !this.bucketsString.equals(other.bucketsString)) {
            return false;
        }
        if (!(this.aggregatorRegistry == other.aggregatorRegistry || this.aggregatorRegistry != null && this.aggregatorRegistry.equals(other.aggregatorRegistry))) {
            return false;
        }
        if (!(this.customTimeBuckets == other.customTimeBuckets || this.customTimeBuckets != null && this.customTimeBuckets.equals(other.customTimeBuckets))) {
            return false;
        }
        return this.schemaAllValueToAggregatorToType == other.schemaAllValueToAggregatorToType || this.schemaAllValueToAggregatorToType != null && this.schemaAllValueToAggregatorToType.equals(other.schemaAllValueToAggregatorToType);
    }

    public FieldsDescriptor getKeyDescriptorWithTime() {
        return this.keyDescriptorWithTime;
    }

    public void setKeyDescriptorWithTime(FieldsDescriptor keyDescriptorWithTime) {
        this.keyDescriptorWithTime = keyDescriptorWithTime;
    }

    public Map<String, List<String>> getKeyToTags() {
        return this.keyToTags;
    }

    public Map<String, List<String>> getValueToTags() {
        return this.valueToTags;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, String> getKeyToExpression() {
        return this.keyToExpression;
    }

    public Map<String, String> getValueToExpression() {
        return this.valueToExpression;
    }

    static {
        HashSet topBottomProperties = Sets.newHashSet((Object[])new String[]{PROPERTY_NAME_COUNT, PROPERTY_NAME_EMBEDED_AGGREGATOR, PROPERTY_NAME_SUB_COMBINATIONS});
        aggregatorToPropertiesMap.put("TOPN", topBottomProperties);
        aggregatorToPropertiesMap.put("BOTTOMN", topBottomProperties);
        LOG = LoggerFactory.getLogger(DimensionalConfigurationSchema.class);
    }

    public static class DimensionsCombination {
        private Fields fields;
        private Map<String, Set<String>> valueToAggregators;

        public DimensionsCombination(Fields fields, Map<String, Set<String>> valueToAggregators) {
            this.setFields(fields);
            this.setValueToAggregators(valueToAggregators);
        }

        private void setFields(@NotNull Fields fields) {
            this.fields = (Fields)Preconditions.checkNotNull((Object)fields);
        }

        public Fields getFields() {
            return this.fields;
        }

        private void setValueToAggregators(@NotNull Map<String, Set<String>> valueToAggregators) {
            Preconditions.checkNotNull(valueToAggregators);
            HashMap newValueToAggregators = Maps.newHashMap();
            for (Map.Entry<String, Set<String>> entry : valueToAggregators.entrySet()) {
                Preconditions.checkNotNull((Object)entry.getKey());
                Preconditions.checkNotNull(entry.getValue());
                newValueToAggregators.put(entry.getKey(), Sets.newHashSet((Iterable)entry.getValue()));
                for (String aggregator : entry.getValue()) {
                    Preconditions.checkNotNull((Object)aggregator);
                }
            }
            this.valueToAggregators = newValueToAggregators;
        }

        public Map<String, Set<String>> getValueToAggregators() {
            return this.valueToAggregators;
        }
    }

    public static class Key {
        private String name;
        private Type type;
        private List<Object> enumValues;

        public Key(String name, Type type, List<Object> enumValues) {
            this.setName(name);
            this.setType(type);
            this.setEnumValues(enumValues);
        }

        private void setName(@NotNull String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        private void setType(@NotNull Type type) {
            this.type = (Type)Preconditions.checkNotNull((Object)type);
        }

        private void setEnumValues(@NotNull List<Object> enumValues) {
            Preconditions.checkNotNull(enumValues);
            for (Object values : enumValues) {
                Preconditions.checkNotNull((Object)values);
            }
            this.enumValues = enumValues;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public List<Object> getEnumValues() {
            return this.enumValues;
        }
    }

    public static class Value {
        private String name;
        private Type type;
        private Set<String> aggregators;

        public Value(String name, Type type, Set<String> aggregators) {
            this.setName(name);
            this.setType(type);
            this.setAggregators(aggregators);
        }

        private void setName(@NotNull String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        private void setType(@NotNull Type type) {
            this.type = (Type)Preconditions.checkNotNull((Object)type);
        }

        private void setAggregators(@NotNull Set<String> aggregators) {
            Preconditions.checkNotNull(aggregators);
            for (String aggregator : aggregators) {
                Preconditions.checkNotNull((Object)aggregator);
            }
            this.aggregators = Sets.newHashSet(aggregators);
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public Set<String> getAggregators() {
            return this.aggregators;
        }
    }
}

