/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.schemas.DimensionalConfigurationSchema;
import com.datatorrent.lib.appdata.schemas.Fields;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.Schema;
import com.datatorrent.lib.appdata.schemas.SchemaUtils;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.apex.malhar.lib.dimensions.aggregator.AggregatorRegistry;
import org.apache.apex.malhar.lib.dimensions.aggregator.IncrementalAggregator;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionalSchema
implements Schema {
    public static final String SCHEMA_TYPE = "dimensions";
    public static final String SCHEMA_VERSION = "1.0";
    public static final String FIELD_TIME_FROM = "from";
    public static final String FIELD_TIME = "time";
    public static final String FIELD_TIME_TO = "to";
    public static final String FIELD_TIME_BUCKETS = "buckets";
    public static final String FIELD_SLIDING_AGGREGATE_SUPPORTED = "slidingAggregateSupported";
    private static final String FIELD_TAGS = "tags";
    public static final List<Fields> VALID_KEYS = ImmutableList.of((Object)new Fields(Sets.newHashSet((Object[])new String[]{"time"})));
    public static final List<Fields> VALID_TIME_KEYS = ImmutableList.of((Object)new Fields(Sets.newHashSet((Object[])new String[]{"from", "to"})));
    public static final String FIELD_RESPONSE_DELAY_MILLS = "responseDelayMillis";
    private Long from;
    private Long to;
    private boolean changed = false;
    private boolean changedFromTo = false;
    private boolean changedSchemaKeys = false;
    private boolean areEnumsUpdated = false;
    private String schemaJSON;
    private DimensionalConfigurationSchema configurationSchema;
    private JSONObject schema;
    private JSONObject time;
    private JSONArray keys;
    private boolean predefinedFromTo = false;
    private Map<String, String> schemaKeys;
    private Map<String, List<Object>> currentEnumVals;
    private int schemaID = 0;
    protected long responseDelayMillis;
    private static final Logger LOG = LoggerFactory.getLogger(DimensionalSchema.class);

    private DimensionalSchema() {
    }

    public DimensionalSchema(String schemaStub, DimensionalConfigurationSchema configurationSchema, Map<String, String> schemaKeys, long responseDelayMillis) {
        this(configurationSchema, schemaKeys, responseDelayMillis);
        if (schemaStub != null) {
            this.predefinedFromTo = true;
            try {
                this.setSchemaStub(schemaStub);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public DimensionalSchema(int schemaID, String schemaStub, DimensionalConfigurationSchema configurationSchema, Map<String, String> schemaKeys) {
        this(schemaStub, configurationSchema, schemaKeys, 0L);
        this.schemaID = schemaID;
    }

    public DimensionalSchema(String schemaStub, DimensionalConfigurationSchema configurationSchema, long responseDelayMillis) {
        this(schemaStub, configurationSchema, null, responseDelayMillis);
    }

    public DimensionalSchema(int schemaID, String schemaStub, DimensionalConfigurationSchema configurationSchema, long responseDelayMillis) {
        this(schemaStub, configurationSchema, responseDelayMillis);
        this.schemaID = schemaID;
    }

    public DimensionalSchema(DimensionalConfigurationSchema configurationSchema, Map<String, String> schemaKeys, long responseDelayMillis) {
        this.setConfigurationSchema(configurationSchema);
        this.setSchemaKeys(schemaKeys);
        this.responseDelayMillis = responseDelayMillis;
        try {
            this.initialize();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public DimensionalSchema(int schemaID, DimensionalConfigurationSchema configurationSchema, Map<String, String> schemaKeys) {
        this(configurationSchema, schemaKeys, 0L);
        this.schemaID = schemaID;
    }

    public DimensionalSchema(DimensionalConfigurationSchema configurationSchema) {
        this(configurationSchema, null, 0L);
    }

    public DimensionalSchema(int schemaID, DimensionalConfigurationSchema configurationSchema) {
        this(configurationSchema);
        this.schemaID = schemaID;
    }

    public AggregatorRegistry getAggregatorRegistry() {
        return this.configurationSchema.getAggregatorRegistry();
    }

    @Override
    public final void setSchemaKeys(Map<String, String> schemaKeys) {
        this.changed = true;
        this.changedSchemaKeys = true;
        if (schemaKeys == null) {
            this.schemaKeys = null;
            return;
        }
        for (Map.Entry<String, String> entry : schemaKeys.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull((Object)entry.getValue());
        }
        this.schemaKeys = Maps.newHashMap(schemaKeys);
    }

    private void setConfigurationSchema(DimensionalConfigurationSchema configurationSchema) {
        this.configurationSchema = (DimensionalConfigurationSchema)Preconditions.checkNotNull((Object)configurationSchema, (Object)"eventSchema");
    }

    private void setSchemaStub(String schemaStub) throws JSONException {
        JSONObject jo = new JSONObject(schemaStub);
        SchemaUtils.checkValidKeysEx(jo, VALID_KEYS);
        JSONObject tempTime = jo.getJSONObject(FIELD_TIME);
        SchemaUtils.checkValidKeys(jo, VALID_TIME_KEYS);
        this.from = tempTime.getLong(FIELD_TIME_FROM);
        this.to = tempTime.getLong(FIELD_TIME_TO);
    }

    private void initialize() throws JSONException {
        this.schema = new JSONObject();
        if (this.schemaKeys != null) {
            this.schema.put("schemaKeys", (Object)SchemaUtils.createJSONObject(this.schemaKeys));
        }
        this.schema.put("schemaType", (Object)SCHEMA_TYPE);
        this.schema.put("schemaVersion", (Object)SCHEMA_VERSION);
        if (this.responseDelayMillis > 0L) {
            this.schema.put(FIELD_RESPONSE_DELAY_MILLS, this.responseDelayMillis);
        }
        if (!this.configurationSchema.getTags().isEmpty()) {
            this.schema.put(FIELD_TAGS, (Object)new JSONArray(this.configurationSchema.getTags()));
        }
        this.time = new JSONObject();
        this.schema.put(FIELD_TIME, (Object)this.time);
        JSONArray bucketsArray = new JSONArray(this.configurationSchema.getBucketsString());
        this.time.put(FIELD_TIME_BUCKETS, (Object)bucketsArray);
        this.time.put(FIELD_SLIDING_AGGREGATE_SUPPORTED, true);
        this.keys = new JSONArray(this.configurationSchema.getKeysString());
        for (int keyIndex = 0; keyIndex < this.keys.length(); ++keyIndex) {
            JSONObject keyJo = this.keys.getJSONObject(keyIndex);
            String keyName = keyJo.getString("name");
            List<String> tags = this.configurationSchema.getKeyToTags().get(keyName);
            if (tags.isEmpty()) continue;
            keyJo.put(FIELD_TAGS, (Object)new JSONArray(tags));
        }
        this.schema.put("keys", (Object)this.keys);
        JSONArray values = new JSONArray();
        this.schema.put("values", (Object)values);
        FieldsDescriptor inputValuesDescriptor = this.configurationSchema.getInputValuesDescriptor();
        Map<String, Map<String, Type>> allValueToAggregator = this.configurationSchema.getSchemaAllValueToAggregatorToType();
        for (Map.Entry<String, Map<String, Type>> entry : allValueToAggregator.entrySet()) {
            String valueName = entry.getKey();
            for (Map.Entry<String, Type> entryAggType : entry.getValue().entrySet()) {
                String aggregatorName = entryAggType.getKey();
                Type outputValueType = entryAggType.getValue();
                JSONObject value = new JSONObject();
                String combinedName = valueName + ":" + aggregatorName;
                value.put("name", (Object)combinedName);
                value.put("type", (Object)outputValueType.getName());
                List<String> tags = this.configurationSchema.getValueToTags().get(valueName);
                if (!tags.isEmpty()) {
                    value.put(FIELD_TAGS, (Object)new JSONArray(tags));
                }
                values.put((Object)value);
            }
        }
        JSONArray dimensions = new JSONArray();
        for (int combinationID = 0; combinationID < this.configurationSchema.getDimensionsDescriptorIDToKeys().size(); ++combinationID) {
            Fields fields = this.configurationSchema.getDimensionsDescriptorIDToKeys().get(combinationID);
            Map<String, Set<String>> fieldToAggregatorAdditionalValues = this.configurationSchema.getDimensionsDescriptorIDToFieldToAggregatorAdditionalValues().get(combinationID);
            JSONObject combination = new JSONObject();
            JSONArray combinationArray = new JSONArray();
            for (String field : fields.getFields()) {
                combinationArray.put((Object)field);
            }
            combination.put("combination", (Object)combinationArray);
            if (!fieldToAggregatorAdditionalValues.isEmpty()) {
                JSONArray additionalValueArray = new JSONArray();
                for (Map.Entry<String, Set<String>> entry : fieldToAggregatorAdditionalValues.entrySet()) {
                    String valueName = entry.getKey();
                    for (String aggregatorName : entry.getValue()) {
                        Type outputValueType;
                        JSONObject additionalValueObject = new JSONObject();
                        String combinedName = valueName + ":" + aggregatorName;
                        Type inputValueType = inputValuesDescriptor.getType(valueName);
                        if (!this.configurationSchema.getAggregatorRegistry().isAggregator(aggregatorName) && aggregatorName == null) {
                            LOG.error("{} is not a valid aggregator.", (Object)aggregatorName);
                        }
                        if (this.configurationSchema.getAggregatorRegistry().isIncrementalAggregator(aggregatorName)) {
                            IncrementalAggregator aggregator = this.configurationSchema.getAggregatorRegistry().getNameToIncrementalAggregator().get(aggregatorName);
                            outputValueType = aggregator.getOutputType(inputValueType);
                        } else {
                            outputValueType = this.configurationSchema.getAggregatorRegistry().getNameToOTFAggregators().get(aggregatorName).getOutputType();
                        }
                        additionalValueObject.put("name", (Object)combinedName);
                        additionalValueObject.put("type", (Object)outputValueType.getName());
                        additionalValueArray.put((Object)additionalValueObject);
                    }
                }
                combination.put("additionalValues", (Object)additionalValueArray);
            }
            dimensions.put((Object)combination);
        }
        this.schema.put(SCHEMA_TYPE, (Object)dimensions);
        this.schemaJSON = this.schema.toString();
    }

    public void setFrom(Long from) {
        this.from = from;
        this.changed = true;
        this.changedFromTo = true;
    }

    public void setTo(Long to) {
        this.to = to;
        this.changed = true;
        this.changedFromTo = true;
    }

    public void setEnumsSet(Map<String, Set<Object>> enums) {
        Preconditions.checkNotNull(enums);
        this.areEnumsUpdated = true;
        HashMap enumsList = Maps.newHashMap();
        Preconditions.checkArgument((boolean)this.configurationSchema.getKeyDescriptor().getFields().getFields().containsAll(enums.keySet()), (String)"The given map doesn't contain valid keys. Valid keys are %s and the provided keys are %s", (Object[])new Object[]{this.configurationSchema.getKeyDescriptor().getFields().getFields(), enums.keySet()});
        for (Map.Entry<String, Set<Object>> entry : enums.entrySet()) {
            String name = entry.getKey();
            Set<Object> vals = entry.getValue();
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull(vals);
            for (Object value : entry.getValue()) {
                Preconditions.checkNotNull((Object)value);
            }
            ArrayList valsList = Lists.newArrayList(vals);
            enumsList.put(name, valsList);
        }
        this.currentEnumVals = Maps.newHashMap((Map)enumsList);
    }

    public void setEnumsSetComparable(Map<String, Set<Comparable>> enums) {
        Preconditions.checkNotNull(enums);
        this.areEnumsUpdated = true;
        HashMap enumsList = Maps.newHashMap();
        Preconditions.checkArgument((boolean)this.configurationSchema.getKeyDescriptor().getFields().getFields().containsAll(enums.keySet()), (String)"The given map doesn't contain valid keys. Valid keys are %s and the provided keys are %s", (Object[])new Object[]{this.configurationSchema.getKeyDescriptor().getFields().getFields(), enums.keySet()});
        for (Map.Entry<String, Set<Comparable>> entry : enums.entrySet()) {
            String name = entry.getKey();
            Set<Comparable> vals = entry.getValue();
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull(vals);
            for (Comparable value : entry.getValue()) {
                Preconditions.checkNotNull((Object)value);
            }
            ArrayList valsListComparable = Lists.newArrayList(vals);
            Collections.sort(valsListComparable);
            ArrayList valsList = valsListComparable;
            enumsList.put(name, valsList);
        }
        this.currentEnumVals = Maps.newHashMap((Map)enumsList);
    }

    public void setEnumsList(Map<String, List<Object>> enums) {
        Preconditions.checkNotNull(enums);
        this.areEnumsUpdated = true;
        Preconditions.checkArgument((boolean)this.configurationSchema.getKeyDescriptor().getFields().getFields().containsAll(enums.keySet()), (String)"The given map doesn't contain valid keys. Valid keys are %s and the provided keys are %s", (Object[])new Object[]{this.configurationSchema.getKeyDescriptor().getFields().getFields(), enums.keySet()});
        for (Map.Entry<String, List<Object>> entry : enums.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull(entry.getValue());
        }
        HashMap tempEnums = Maps.newHashMap();
        for (Map.Entry<String, List<Object>> entry : enums.entrySet()) {
            String key = entry.getKey();
            List<Object> enumValues = entry.getValue();
            ArrayList tempEnumValues = Lists.newArrayList();
            for (Object enumValue : enumValues) {
                tempEnumValues.add(enumValue);
            }
            tempEnums.put(key, tempEnumValues);
        }
        this.currentEnumVals = tempEnums;
    }

    @Override
    public String getSchemaJSON() {
        if (!this.changed && this.schemaJSON != null) {
            return this.schemaJSON;
        }
        if (this.changedSchemaKeys) {
            this.changedSchemaKeys = false;
            if (this.schemaKeys == null) {
                this.schema.remove("schemaKeys");
            } else {
                try {
                    this.schema.put("schemaKeys", (Object)SchemaUtils.createJSONObject(this.schemaKeys));
                }
                catch (JSONException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if (this.changedFromTo) {
            this.changedFromTo = false;
            Preconditions.checkState((!(this.from == null ^ this.to == null) ? 1 : 0) != 0, (Object)"Either both from and to should be set or both should be not set.");
            if (this.from != null) {
                Preconditions.checkState((this.to >= this.from ? 1 : 0) != 0, (String)"to {} must be greater than or equal to from {}.", (Object[])new Object[]{this.to, this.from});
            }
            if (this.from == null) {
                this.time.remove(FIELD_TIME_FROM);
                this.time.remove(FIELD_TIME_TO);
            } else {
                try {
                    this.time.put(FIELD_TIME_FROM, (Object)this.from);
                    this.time.put(FIELD_TIME_TO, (Object)this.to);
                }
                catch (JSONException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if (this.areEnumsUpdated) {
            for (int keyIndex = 0; keyIndex < this.keys.length(); ++keyIndex) {
                String name;
                JSONObject keyData;
                try {
                    keyData = this.keys.getJSONObject(keyIndex);
                    name = keyData.getString("name");
                }
                catch (JSONException ex) {
                    throw new RuntimeException(ex);
                }
                List<Object> enumVals = this.currentEnumVals.get(name);
                if (enumVals == null || enumVals.isEmpty()) {
                    keyData.remove("enumValues");
                    continue;
                }
                JSONArray newEnumValues = new JSONArray();
                for (Object enumVal : enumVals) {
                    newEnumValues.put(enumVal);
                }
                try {
                    keyData.put("enumValues", (Object)newEnumValues);
                    continue;
                }
                catch (JSONException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.areEnumsUpdated = false;
        }
        this.schemaJSON = this.schema.toString();
        return this.schemaJSON;
    }

    public DimensionalConfigurationSchema getDimensionalConfigurationSchema() {
        return this.configurationSchema;
    }

    @Override
    public String getSchemaType() {
        return SCHEMA_TYPE;
    }

    @Override
    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    @Override
    public Map<String, String> getSchemaKeys() {
        return this.schemaKeys;
    }

    public boolean isPredefinedFromTo() {
        return this.predefinedFromTo;
    }

    @Override
    public int getSchemaID() {
        return this.schemaID;
    }

    public Map<String, List<Object>> getCurrentEnumVals() {
        return this.currentEnumVals;
    }
}

