/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fields
implements Serializable {
    private static final long serialVersionUID = 201506251241L;
    private Set<String> fields;
    private List<String> fieldsList;
    private static final Logger LOG = LoggerFactory.getLogger(Fields.class);

    public Fields() {
    }

    public Fields(Collection<String> fields) {
        this.fields = Sets.newHashSet();
        for (String field : fields) {
            Preconditions.checkNotNull((Object)field);
            if (this.fields.add(field)) continue;
            throw new IllegalArgumentException("Duplicate field: " + field);
        }
        this.fieldsList = Lists.newArrayList();
        this.fieldsList.addAll(fields);
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public List<String> getFieldsList() {
        return this.fieldsList;
    }

    public String toString() {
        return "Fields{fields=" + this.fields + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.fields != null ? this.fields.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fields other = (Fields)obj;
        return this.fields == other.fields || this.fields != null && this.fields.equals(other.fields);
    }
}

