/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.gpo.Serde;
import com.datatorrent.lib.appdata.gpo.SerdeObjectPayloadFix;
import com.datatorrent.lib.appdata.schemas.Fields;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldsDescriptor
implements Serializable {
    private static final long serialVersionUID = 201506251228L;
    private List<String> fieldList;
    private List<Type> typesList;
    private Fields fields;
    private Set<Type> types;
    private Map<Type, Object2IntLinkedOpenHashMap<String>> typeToFieldToIndex;
    private Map<Type, List<String>> typeToFields;
    private Map<String, Type> fieldToType;
    private Set<Type> compressedTypes;
    private Object2IntLinkedOpenHashMap<Type> typeToSize;
    private Serde[] serdes;
    private SerdeObjectPayloadFix serdePayloadFix;
    private static final Logger LOG = LoggerFactory.getLogger(FieldsDescriptor.class);

    private FieldsDescriptor() {
    }

    public FieldsDescriptor(Map<String, Type> fieldToType) {
        this.setFieldToType(fieldToType);
        this.compressedTypes = Sets.newHashSet();
        this.initialize();
    }

    public FieldsDescriptor(Map<String, Type> fieldToType, Map<String, Serde> fieldToSerdeObject) {
        this.setFieldToType(fieldToType);
        this.compressedTypes = Sets.newHashSet();
        this.initialize();
        List<String> fieldNames = this.typeToFields.get(Type.OBJECT);
        if (fieldNames == null) {
            throw new IllegalArgumentException("There are no fields of type " + Type.OBJECT + " in this fieldsdescriptor");
        }
        this.serdes = new Serde[fieldNames.size()];
        for (int index = 0; index < fieldNames.size(); ++index) {
            String fieldName = fieldNames.get(index);
            Serde serdeObject = fieldToSerdeObject.get(fieldName);
            if (serdeObject == null) {
                throw new IllegalArgumentException("The field " + fieldName + " doesn't have a serde object.");
            }
            this.serdes[index] = serdeObject;
        }
    }

    public FieldsDescriptor(Map<String, Type> fieldToType, Map<String, Serde> fieldToSerdeObject, SerdeObjectPayloadFix serdePayloadFix) {
        this(fieldToType, fieldToSerdeObject);
        this.serdePayloadFix = serdePayloadFix;
    }

    public FieldsDescriptor(Map<String, Type> fieldToType, Set<Type> compressedTypes) {
        this.setFieldToType(fieldToType);
        this.setCompressedTypes(compressedTypes);
        this.initialize();
    }

    private void initialize() {
        Type type;
        this.typeToFieldToIndex = Maps.newHashMap();
        this.typeToFields = Maps.newHashMap();
        for (Map.Entry<String, Type> entry : this.fieldToType.entrySet()) {
            String field = entry.getKey();
            Type type2 = entry.getValue();
            ArrayList fieldsList = this.typeToFields.get(type2);
            if (fieldsList == null) {
                fieldsList = Lists.newArrayList();
                this.typeToFields.put(type2, fieldsList);
            }
            fieldsList.add(field);
        }
        for (Map.Entry<Object, Object> entry : this.typeToFields.entrySet()) {
            type = (Type)entry.getKey();
            List tempFields = (List)entry.getValue();
            Collections.sort(tempFields);
            Object2IntLinkedOpenHashMap fieldToIndex = new Object2IntLinkedOpenHashMap();
            for (int index = 0; index < tempFields.size(); ++index) {
                String field = (String)tempFields.get(index);
                if (this.compressedTypes.contains(type)) {
                    fieldToIndex.put((Object)field, 0);
                    continue;
                }
                fieldToIndex.put((Object)field, index);
            }
            this.typeToFieldToIndex.put(type, (Object2IntLinkedOpenHashMap<String>)fieldToIndex);
        }
        this.types = !this.typeToFields.isEmpty() ? EnumSet.copyOf(this.typeToFields.keySet()) : Sets.newHashSet();
        this.typesList = Lists.newArrayList();
        this.typesList.addAll(this.types);
        this.fieldList = Lists.newArrayList();
        this.fieldList.addAll(this.fieldToType.keySet());
        ((ArrayList)this.fieldList).trimToSize();
        Collections.sort(this.fieldList);
        this.typeToSize = new Object2IntLinkedOpenHashMap();
        for (Map.Entry<Object, Object> entry : this.typeToFields.entrySet()) {
            type = (Type)entry.getKey();
            if (this.compressedTypes.contains(type)) {
                this.getTypeToSize().put((Object)type, 1);
                continue;
            }
            this.getTypeToSize().put((Object)type, ((List)entry.getValue()).size());
        }
    }

    public Map<Type, Object2IntLinkedOpenHashMap<String>> getTypeToFieldToIndex() {
        return this.typeToFieldToIndex;
    }

    private void setFieldToType(Map<String, Type> fieldToType) {
        for (Map.Entry<String, Type> entry : fieldToType.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull((Object)entry.getValue());
        }
        this.fieldToType = Maps.newHashMap(fieldToType);
    }

    private void setCompressedTypes(Set<Type> compressedTypes) {
        for (Type type : compressedTypes) {
            Preconditions.checkNotNull((Object)type);
        }
        this.compressedTypes = Sets.newHashSet(compressedTypes);
    }

    public Map<String, Type> getFieldToType() {
        return this.fieldToType;
    }

    public Type getType(String field) {
        return this.fieldToType.get(field);
    }

    public Fields getFields() {
        if (this.fields == null) {
            this.fields = new Fields(this.fieldToType.keySet());
        }
        return this.fields;
    }

    public FieldsDescriptor getSubset(Fields fields) {
        HashMap newFieldToType = Maps.newHashMap();
        for (String field : fields.getFields()) {
            Type type = this.fieldToType.get(field);
            newFieldToType.put(field, type);
        }
        return new FieldsDescriptor(newFieldToType);
    }

    public Map<Type, List<String>> getTypeToFields() {
        return this.typeToFields;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public List<Type> getTypesList() {
        return this.typesList;
    }

    public List<String> getFieldList() {
        return this.fieldList;
    }

    public Set<Type> getCompressedTypes() {
        return this.compressedTypes;
    }

    public Object2IntLinkedOpenHashMap<Type> getTypeToSize() {
        return this.typeToSize;
    }

    public Serde[] getSerdes() {
        return this.serdes;
    }

    public SerdeObjectPayloadFix getSerdePayloadFix() {
        return this.serdePayloadFix;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.fieldToType != null ? this.fieldToType.hashCode() : 0);
        hash = 53 * hash + (this.compressedTypes != null ? this.compressedTypes.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldsDescriptor other = (FieldsDescriptor)obj;
        if (!(this.fieldToType == other.fieldToType || this.fieldToType != null && this.fieldToType.equals(other.fieldToType))) {
            return false;
        }
        return this.compressedTypes == other.compressedTypes || this.compressedTypes != null && this.compressedTypes.equals(other.compressedTypes);
    }

    public String toString() {
        return "FieldsDescriptor{fieldToType=" + this.fieldToType + ", compressedTypes=" + this.compressedTypes + '}';
    }
}

