/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.schemas.QRBase;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;

public abstract class Query
extends QRBase {
    public static final String FIELD_SCHEMA_KEYS = "schemaKeys";
    protected Map<String, String> schemaKeys;

    public Query() {
    }

    public Query(String id) {
        super(id);
    }

    public Query(String id, String type) {
        super(id, type);
    }

    public Query(String id, String type, Map<String, String> schemaKeys) {
        super(id, type);
        this.setSchemaKeys(schemaKeys);
    }

    public Query(String id, String type, long countdown) {
        super(id, type, countdown);
    }

    public Query(String id, String type, long countdown, Map<String, String> schemaKeys) {
        super(id, type, countdown);
        this.setSchemaKeys(schemaKeys);
    }

    private void setSchemaKeys(Map<String, String> schemaKeys) {
        if (schemaKeys == null) {
            return;
        }
        for (Map.Entry<String, String> entry : schemaKeys.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull((Object)entry.getValue());
        }
        this.schemaKeys = Collections.unmodifiableMap(Maps.newHashMap(schemaKeys));
    }

    public Map<String, String> getSchemaKeys() {
        return this.schemaKeys;
    }
}

