/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.schemas.Type;
import java.io.Serializable;
import java.text.DecimalFormat;

public class ResultFormatter
implements Serializable {
    private static final long serialVersionUID = 201505121109L;
    private String floatFormatString;
    private String doubleFormatString;
    private String byteFormatString;
    private String shortFormatString;
    private String intFormatString;
    private String longFormatString;
    private String discreteFormatString;
    private String continuousFormatString;
    private transient DecimalFormat floatFormat;
    private transient DecimalFormat doubleFormat;
    private transient DecimalFormat byteFormat;
    private transient DecimalFormat shortFormat;
    private transient DecimalFormat intFormat;
    private transient DecimalFormat longFormat;

    public String format(Object object) {
        Type type = Type.CLASS_TO_TYPE.get(object.getClass());
        if (type == null) {
            return object.toString();
        }
        switch (type) {
            case FLOAT: {
                return this.format(((Float)object).floatValue());
            }
            case DOUBLE: {
                return this.format((Double)object);
            }
            case BYTE: {
                return this.format((Byte)object);
            }
            case SHORT: {
                return this.format((Short)object);
            }
            case INTEGER: {
                return this.format((Integer)object);
            }
            case LONG: {
                return this.format((Long)object);
            }
        }
        return object.toString();
    }

    public String format(float val) {
        DecimalFormat df = this.getFloatFormat();
        if (df != null) {
            return df.format(val);
        }
        return Float.toString(val);
    }

    public String format(double val) {
        DecimalFormat df = this.getDoubleFormat();
        if (df != null) {
            return df.format(val);
        }
        return Double.toString(val);
    }

    public String format(byte val) {
        DecimalFormat df = this.getByteFormat();
        if (df != null) {
            return df.format(val);
        }
        return Byte.toString(val);
    }

    public String format(short val) {
        DecimalFormat df = this.getShortFormat();
        if (df != null) {
            return df.format(val);
        }
        return Short.toString(val);
    }

    public String format(int val) {
        DecimalFormat df = this.getIntFormat();
        if (df != null) {
            return df.format(val);
        }
        return Integer.toString(val);
    }

    public String format(long val) {
        DecimalFormat df = this.getLongFormat();
        if (df != null) {
            return df.format(val);
        }
        return Long.toString(val);
    }

    public DecimalFormat getFloatFormat() {
        if (this.floatFormat == null && this.floatFormatString != null) {
            this.floatFormat = new DecimalFormat(this.floatFormatString);
        }
        return this.floatFormat;
    }

    public DecimalFormat getDoubleFormat() {
        if (this.doubleFormat == null && this.doubleFormatString != null) {
            this.doubleFormat = new DecimalFormat(this.doubleFormatString);
        }
        return this.doubleFormat;
    }

    public DecimalFormat getByteFormat() {
        if (this.byteFormat == null && this.byteFormatString != null) {
            this.byteFormat = new DecimalFormat(this.byteFormatString);
        }
        return this.byteFormat;
    }

    public DecimalFormat getShortFormat() {
        if (this.shortFormat == null && this.shortFormatString != null) {
            this.shortFormat = new DecimalFormat(this.shortFormatString);
        }
        return this.shortFormat;
    }

    public DecimalFormat getIntFormat() {
        if (this.intFormat == null && this.intFormatString != null) {
            this.intFormat = new DecimalFormat(this.intFormatString);
        }
        return this.intFormat;
    }

    public DecimalFormat getLongFormat() {
        if (this.longFormat == null && this.longFormatString != null) {
            this.longFormat = new DecimalFormat(this.longFormatString);
        }
        return this.longFormat;
    }

    public String getDiscreteFormatString() {
        return this.discreteFormatString;
    }

    public void setDiscreteFormatString(String discreteFormatString) {
        this.discreteFormatString = discreteFormatString;
        this.byteFormatString = discreteFormatString;
        this.shortFormatString = discreteFormatString;
        this.intFormatString = discreteFormatString;
        this.longFormatString = discreteFormatString;
    }

    public String getContinuousFormatString() {
        return this.continuousFormatString;
    }

    public void setContinuousFormatString(String continuousFormatString) {
        this.continuousFormatString = continuousFormatString;
        this.floatFormatString = continuousFormatString;
        this.doubleFormatString = continuousFormatString;
    }

    public String getFloatFormatString() {
        return this.floatFormatString;
    }

    public void setFloatFormatString(String decimalFormatString) {
        this.floatFormatString = decimalFormatString;
    }

    public String getDoubleFormatString() {
        return this.doubleFormatString;
    }

    public void setDoubleFormatString(String doubleFormatString) {
        this.doubleFormatString = doubleFormatString;
    }

    public String getIntFormatString() {
        return this.intFormatString;
    }

    public void setIntFormatString(String intFormatString) {
        this.intFormatString = intFormatString;
    }

    public String getByteFormatString() {
        return this.byteFormatString;
    }

    public void setByteFormatString(String byteFormatString) {
        this.byteFormatString = byteFormatString;
    }

    public String getShortFormatString() {
        return this.shortFormatString;
    }

    public void setShortFormatString(String shortFormatString) {
        this.shortFormatString = shortFormatString;
    }

    public String getLongFormatString() {
        return this.longFormatString;
    }

    public void setLongFormatString(String longFormatString) {
        this.longFormatString = longFormatString;
    }
}

