/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.datastructs.DimensionalTable;
import com.datatorrent.lib.appdata.schemas.Schema;
import com.datatorrent.lib.appdata.schemas.SchemaQuery;
import com.datatorrent.lib.appdata.schemas.SchemaRegistry;
import com.datatorrent.lib.appdata.schemas.SchemaResult;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class SchemaRegistryMultiple
implements SchemaRegistry,
Serializable {
    private static final long serialVersionUID = 201505121108L;
    private DimensionalTable<Schema> table;
    private Comparator<Schema> schemaComparator;

    private SchemaRegistryMultiple() {
    }

    public SchemaRegistryMultiple(List<String> schemaKeys) {
        this.table = new DimensionalTable(schemaKeys);
    }

    public SchemaRegistryMultiple(List<String> schemaKeys, Comparator<Schema> schemaComparator) {
        this(schemaKeys);
        this.schemaComparator = (Comparator)Preconditions.checkNotNull(schemaComparator);
    }

    @Override
    public SchemaResult getSchemaResult(SchemaQuery schemaQuery) {
        Map<String, String> schemaKeys = schemaQuery.getSchemaKeys();
        List<Schema> data = null;
        data = schemaKeys == null ? this.table.getAllDataPoints() : this.table.getDataPoints(schemaKeys);
        if (this.schemaComparator != null) {
            Collections.sort(data, this.schemaComparator);
        }
        if (data.isEmpty()) {
            return null;
        }
        return new SchemaResult(schemaQuery, data);
    }

    @Override
    public void registerSchema(Schema schema) {
        Map<String, String> schemaKeys = schema.getSchemaKeys();
        this.table.appendRow(schema, schemaKeys);
    }

    @Override
    public Schema getSchema(Map<String, String> schemaKeys) {
        return this.table.getDataPoint(schemaKeys);
    }

    @Override
    public void registerSchema(Schema schema, Map<String, String> schemaKeys) {
        schema.setSchemaKeys(schemaKeys);
        this.table.appendRow(schema, schemaKeys);
    }

    @Override
    public int size() {
        return this.table.size();
    }
}

