/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.schemas.Schema;
import com.datatorrent.lib.appdata.schemas.SchemaQuery;
import com.datatorrent.lib.appdata.schemas.SchemaRegistry;
import com.datatorrent.lib.appdata.schemas.SchemaResult;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistrySingle
implements SchemaRegistry,
Serializable {
    private static final long serialVersionUID = 20150513928L;
    private static final Logger logger = LoggerFactory.getLogger(SchemaRegistrySingle.class);
    private Schema schema;

    public SchemaRegistrySingle() {
    }

    public SchemaRegistrySingle(Schema schema) {
        this.setSchema(schema);
    }

    private void setSchema(Schema schema) {
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkArgument((schema.getSchemaKeys() == null ? 1 : 0) != 0, (Object)("The provided schema should not have schema keys " + schema.getSchemaKeys() + " since they will never be used."));
        this.schema = schema;
    }

    @Override
    public SchemaResult getSchemaResult(SchemaQuery schemaQuery) {
        Preconditions.checkNotNull((Object)schemaQuery, (Object)"This should never happen.");
        if (schemaQuery.getSchemaKeys() != null) {
            logger.error("Schema keys in the given query don't apply for single schema registry: schemaKeys={}", schemaQuery.getSchemaKeys());
            return null;
        }
        return new SchemaResult(schemaQuery, this.schema);
    }

    @Override
    public void registerSchema(Schema schema) {
        Preconditions.checkState((this.schema == null ? 1 : 0) != 0, (Object)"A schema is already set.");
        this.schema = schema;
    }

    @Override
    public Schema getSchema(Map<String, String> schemaKeys) {
        return this.schema;
    }

    @Override
    public void registerSchema(Schema schema, Map<String, String> schemaKeys) {
        throw new UnsupportedOperationException("Schema keys are not supported in SchemaRegistrySingle.");
    }

    @Override
    public int size() {
        return this.schema == null ? 0 : 1;
    }
}

