/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.query.serde.MessageSerializerInfo;
import com.datatorrent.lib.appdata.query.serde.MessageType;
import com.datatorrent.lib.appdata.schemas.Result;
import com.datatorrent.lib.appdata.schemas.Schema;
import com.datatorrent.lib.appdata.schemas.SchemaQuery;
import com.datatorrent.lib.appdata.schemas.SchemaResultSerializer;
import com.google.common.base.Preconditions;
import java.util.List;

@MessageType(type="schemaResult")
@MessageSerializerInfo(clazz=SchemaResultSerializer.class)
public class SchemaResult
extends Result {
    public static final String TYPE = "schemaResult";
    private Schema[] genericSchemas;

    public SchemaResult(SchemaQuery schemaQuery, Schema ... genericSchemas) {
        super(schemaQuery);
        this.setGenericSchemas(genericSchemas);
    }

    public SchemaResult(SchemaQuery schemaQuery, List<Schema> genericSchemas) {
        super(schemaQuery);
        this.setGenericSchemas(genericSchemas);
    }

    private void setGenericSchemas(List<Schema> genericSchemas) {
        Preconditions.checkNotNull(genericSchemas);
        Preconditions.checkArgument((!genericSchemas.isEmpty() ? 1 : 0) != 0, (Object)"Atleast one schema must be provided.");
        this.genericSchemas = genericSchemas.toArray(new Schema[0]);
    }

    private void setGenericSchemas(Schema ... genericSchemas) {
        Preconditions.checkNotNull((Object)genericSchemas);
        Preconditions.checkArgument((genericSchemas.length > 0 ? 1 : 0) != 0, (Object)"Atleast one schema must be provided.");
        this.genericSchemas = genericSchemas;
    }

    public Schema[] getGenericSchemas() {
        return this.genericSchemas;
    }
}

