/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.query.serde.CustomMessageSerializer;
import com.datatorrent.lib.appdata.schemas.Message;
import com.datatorrent.lib.appdata.schemas.ResultFormatter;
import com.datatorrent.lib.appdata.schemas.Schema;
import com.datatorrent.lib.appdata.schemas.SchemaResult;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaResultSerializer
implements CustomMessageSerializer {
    private static final Logger logger = LoggerFactory.getLogger(SchemaResultSerializer.class);

    @Override
    public String serialize(Message message, ResultFormatter resultFormatter) {
        if (!(message instanceof SchemaResult)) {
            throw new IllegalArgumentException("Must receive a " + SchemaResult.class + " object.");
        }
        SchemaResult genericSchemaResult = (SchemaResult)message;
        StringBuilder sb = new StringBuilder();
        logger.debug("result {}", (Object)genericSchemaResult);
        logger.debug("result id {}", (Object)genericSchemaResult.getId());
        logger.debug("result type {}", (Object)genericSchemaResult.getType());
        sb.append("{\"").append("id").append("\":\"").append(genericSchemaResult.getId()).append("\",\"").append("type").append("\":\"").append(genericSchemaResult.getType()).append("\",\"").append("data").append("\":");
        JSONArray schemaArray = new JSONArray();
        for (Schema schema : genericSchemaResult.getGenericSchemas()) {
            try {
                schemaArray.put((Object)new JSONObject(schema.getSchemaJSON()));
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
        sb.append(schemaArray.toString()).append("}");
        return sb.toString();
    }
}

